/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorLakes;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorTaigaTree;
import com.google.common.base.CaseFormat;
import java.util.Locale;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;

public class BiomeGenAlps
extends BOPOverworldBiome {
    public AlpsType type;

    public BiomeGenAlps(AlpsType type) {
        super(type.name().toLowerCase(Locale.ENGLISH), new BOPBiome.PropsBuilder(CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, type.toString())).withGuiColour(0xCCCCCC).withSnowEnabled().withTemperature(Float.valueOf(-0.25f)).withRainfall(Float.valueOf(0.3f)));
        this.type = type;
        switch (type) {
            case ALPS: {
                this.terrainSettings.avgHeight(198.0).heightVariation(12.0, 12.0).octaves(1.0, 1.0, 2.0, 2.0, 3.0, 3.0);
                this.field_76752_A = Blocks.field_150433_aE.func_176223_P();
                this.field_76753_B = Blocks.field_150433_aE.func_176223_P();
                break;
            }
            case ALPS_FOOTHILLS: {
                this.terrainSettings.avgHeight(120.0).heightVariation(48.0, 64.0).octaves(0.0, 1.0, 1.0, 3.0, 1.0, 0.0);
                this.hasBiomeEssence = false;
                this.field_76752_A = BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.OVERGROWN_STONE));
                this.field_76753_B = Blocks.field_150348_b.func_176223_P();
            }
        }
        this.canGenerateRivers = false;
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.beachBiomeLocation = null;
        if (type == AlpsType.ALPS) {
            this.addWeight(BOPClimates.TUNDRA, 3);
            this.addWeight(BOPClimates.ICE_CAP, 5);
        }
        this.avgDirtDepth = 8;
        this.field_76762_K.clear();
        if (type == AlpsType.ALPS_FOOTHILLS) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityLlama.class, 5, 4, 6));
            IBlockPosQuery emptyStone = BlockQuery.buildAnd().withAirAbove().states(BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.OVERGROWN_STONE))).create();
            GeneratorWeighted treeGenerator = new GeneratorWeighted(0.5f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("fir", 1, ((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)((GeneratorTaigaTree.Builder)new GeneratorTaigaTree.Builder().placeOn(emptyStone)).log(BOPWoods.FIR)).leaves(BOPTrees.FIR)).minHeight(10)).maxHeight(19)).create());
            this.addGenerator("hot_springs", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(0.5f)).liquid(BOPBlocks.hot_spring_water).frozenLiquid((IBlockState)null).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_SURFACE).create());
        }
        this.addGenerator("emeralds", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(Blocks.field_150412_bA.func_176223_P())).create());
    }

    public static enum AlpsType {
        ALPS,
        ALPS_FOOTHILLS;

    }
}

