/*
 * Decompiled with CFR 0.152.
 */
package surreal.fixeroo.core.transformers;

import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import surreal.fixeroo.FixerooConfig;
import surreal.fixeroo.core.transformers.TypicalTransformer;

public class XPOrbTransformer
extends TypicalTransformer {
    public static byte[] transformEntityXPOrb(String transformedName, byte[] basicClass) {
        if (!FixerooConfig.xpOrbClump.enable) {
            return basicClass;
        }
        ClassNode cls = XPOrbTransformer.read(transformedName, basicClass);
        block0: for (MethodNode method : cls.methods) {
            AbstractInsnNode node;
            if (method.name.equals(XPOrbTransformer.getName("onUpdate", "func_70071_h_"))) {
                for (AbstractInsnNode node2 : method.instructions) {
                    if (node2.getOpcode() != 183) continue;
                    node2 = node2.getNext();
                    method.instructions.insertBefore(node2, (AbstractInsnNode)new VarInsnNode(25, 0));
                    method.instructions.insertBefore(node2, (AbstractInsnNode)XPOrbTransformer.hook("EntityXPOrb$onUpdate", "(Lnet/minecraft/entity/item/EntityXPOrb;)V"));
                    continue block0;
                }
                continue;
            }
            if (method.name.equals(XPOrbTransformer.getName("writeEntityToNBT", "func_70014_b"))) {
                node = method.instructions.getLast();
                while (node.getOpcode() != 182) {
                    node = node.getPrevious();
                }
                method.instructions.remove(node.getPrevious());
                method.instructions.insert(node, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/nbt/NBTTagCompound", XPOrbTransformer.getName("setInteger", "func_74768_a"), "(Ljava/lang/String;I)V", false));
                method.instructions.remove(node);
                continue;
            }
            if (method.name.equals(XPOrbTransformer.getName("readEntityFromNBT", "func_70037_a"))) {
                node = method.instructions.getLast();
                while (node.getOpcode() != 182) {
                    node = node.getPrevious();
                }
                while (node.getOpcode() != 25) {
                    node = node.getPrevious();
                    method.instructions.remove(node.getNext());
                }
                method.instructions.insert(node, (AbstractInsnNode)XPOrbTransformer.hook("EntityXPOrb$getXPValue", "(Lnet/minecraft/nbt/NBTTagCompound;)I"));
                continue;
            }
            if (!FixerooConfig.xpOrbClump.removeCooldown || !method.name.equals(XPOrbTransformer.getName("onCollideWithPlayer", "func_70100_b_"))) continue;
            ListIterator iterator = method.instructions.iterator();
            while (iterator.hasNext()) {
                AbstractInsnNode node2;
                node2 = (AbstractInsnNode)iterator.next();
                if (node2.getOpcode() != 5) continue;
                method.instructions.insertBefore(node2, (AbstractInsnNode)new InsnNode(3));
                iterator.remove();
            }
            break;
        }
        return XPOrbTransformer.write(cls);
    }

    public static byte[] transformRenderXPOrb(String transformedName, byte[] basicClass) {
        if (!FixerooConfig.xpOrbClump.changeOrbSize) {
            return basicClass;
        }
        ClassNode cls = XPOrbTransformer.read(transformedName, basicClass);
        block0: for (MethodNode method : cls.methods) {
            if (!method.name.equals(XPOrbTransformer.getName("doRender", "func_76986_a"))) continue;
            ListIterator iterator = method.instructions.iterator();
            boolean first = true;
            int i = 0;
            while (iterator.hasNext()) {
                Object cst;
                AbstractInsnNode node = (AbstractInsnNode)iterator.next();
                if (!(node instanceof LdcInsnNode) || !((cst = ((LdcInsnNode)node).cst) instanceof Float) || !cst.equals(Float.valueOf(0.3f))) continue;
                if (first) {
                    first = false;
                } else {
                    method.instructions.insertBefore(node, (AbstractInsnNode)new VarInsnNode(25, 1));
                    method.instructions.insertBefore(node, (AbstractInsnNode)XPOrbTransformer.hook("RenderXPOrb$getSize", "(Lnet/minecraft/entity/item/EntityXPOrb;)F"));
                    iterator.remove();
                }
                if (++i != 4) continue;
                break block0;
            }
            break block0;
        }
        return XPOrbTransformer.write(cls);
    }
}

