/*
 * Decompiled with CFR 0.152.
 */
package surreal.fixeroo.core;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import surreal.fixeroo.FixerooConfig;
import surreal.fixeroo.core.FixerooPlugin;
import surreal.fixeroo.core.transformers.ElytraTransformer;
import surreal.fixeroo.core.transformers.GolemTransformer;
import surreal.fixeroo.core.transformers.MPSTransformer;
import surreal.fixeroo.core.transformers.MisrotatedModdedTETransformer;
import surreal.fixeroo.core.transformers.PreciseEntityPositionTransformer;
import surreal.fixeroo.core.transformers.ShulkerColoringTransformer;
import surreal.fixeroo.core.transformers.TESRRenderDistanceTransformer;
import surreal.fixeroo.core.transformers.XPOrbTransformer;

public class FixerooTransformer
implements IClassTransformer {
    private final Set<String> addTEs = this.buildAddTEs();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!FixerooPlugin.configAnytime) {
            return basicClass;
        }
        switch (transformedName) {
            case "net.minecraft.entity.item.EntityXPOrb": {
                return XPOrbTransformer.transformEntityXPOrb(transformedName, basicClass);
            }
            case "net.minecraft.client.renderer.entity.RenderXPOrb": {
                return XPOrbTransformer.transformRenderXPOrb(transformedName, basicClass);
            }
            case "net.minecraft.block.BlockPumpkin": {
                return GolemTransformer.transformBlockPumpkin(transformedName, basicClass);
            }
            case "net.minecraft.client.model.ModelPlayer": 
            case "net.minecraft.client.model.ModelBiped": {
                return ElytraTransformer.transformModelPlayer(transformedName, basicClass);
            }
            case "net.minecraft.client.renderer.entity.RenderPlayer": {
                return ElytraTransformer.transformRenderPlayer(transformedName, basicClass);
            }
            case "net.minecraft.entity.player.EntityPlayer": {
                return ElytraTransformer.transformEntityPlayer(transformedName, basicClass);
            }
            case "net.minecraft.client.entity.EntityPlayerSP": {
                return PreciseEntityPositionTransformer.transformEntityPlayerSP(transformedName, basicClass);
            }
            case "net.minecraft.entity.monster.EntityShulker": {
                return ShulkerColoringTransformer.transformEntityShulker(transformedName, basicClass);
            }
            case "net.darkhax.darkutils.features.shulkerpearl.FeatureShulkerPearlItem": {
                return ShulkerColoringTransformer.transformFeatureShulkerPearlItem(transformedName, basicClass);
            }
            case "net.minecraft.tileentity.TileEntity": {
                return TESRRenderDistanceTransformer.transformTileEntity(transformedName, basicClass);
            }
            case "net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher": {
                return TESRRenderDistanceTransformer.transformTileEntityRendererDispatcher(transformedName, basicClass);
            }
            case "net.machinemuse.powersuits.common.base.ModuleManager": {
                return MPSTransformer.transformModuleManager(transformedName, basicClass);
            }
            case "net.machinemuse.powersuits.common.config.MPSSettings": {
                return MPSTransformer.transformMPSSettings(transformedName, basicClass);
            }
        }
        if (FixerooConfig.TERotationFix.enableRotationFix && this.addTEs.contains(transformedName)) {
            return MisrotatedModdedTETransformer.transformModdedTE(transformedName, basicClass);
        }
        return basicClass;
    }

    private Set<String> buildAddTEs() {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.add((Object[])new String[]{"funwayguy.bdsandm.blocks.tiles.TileEntityBarrel", "funwayguy.bdsandm.blocks.tiles.TileEntityCrate", "com.tiviacz.travelersbackpack.tileentity.TileEntityTravelersBackpack"});
        builder.add((Object[])FixerooConfig.TERotationFix.tileEntities);
        return builder.build();
    }
}

