/*
 * Decompiled with CFR 0.152.
 */
package surreal.fixeroo.core;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import surreal.fixeroo.Fixeroo;
import surreal.fixeroo.FixerooConfig;
import surreal.fixeroo.IntegrationHandler;

public class FixerooHooks {
    public static void EntityXPOrb$onUpdate(EntityXPOrb orb) {
        if (orb.field_70530_e == Integer.MAX_VALUE) {
            return;
        }
        World world = orb.field_70170_p;
        double a = FixerooConfig.xpOrbClump.areaSize / 2.0;
        List orbs = world.func_175674_a((Entity)orb, new AxisAlignedBB(orb.field_70165_t - a, orb.field_70163_u - a, orb.field_70161_v - a, orb.field_70165_t + a, orb.field_70163_u + a, orb.field_70161_v + a), e -> e instanceof EntityXPOrb);
        if (orbs.size() <= FixerooConfig.xpOrbClump.maxOrbCount) {
            return;
        }
        int count = orbs.size();
        for (Entity e2 : orbs) {
            if (count <= FixerooConfig.xpOrbClump.maxOrbCount) {
                return;
            }
            EntityXPOrb o = (EntityXPOrb)e2;
            if (o.field_70530_e == Integer.MAX_VALUE) continue;
            orb.field_70530_e = (long)orb.field_70530_e + (long)o.field_70530_e > Integer.MAX_VALUE ? Integer.MAX_VALUE : (orb.field_70530_e += o.field_70530_e);
            o.func_70106_y();
            --count;
        }
    }

    public static int EntityXPOrb$getXPValue(NBTTagCompound tag) {
        if (tag.func_150297_b("Value", 2)) {
            return tag.func_74765_d("Value");
        }
        return tag.func_74762_e("Value");
    }

    public static float RenderXPOrb$getSize(EntityXPOrb orb) {
        int xpValue = orb.field_70530_e;
        return Math.max(0.3f, MathHelper.func_76129_c((float)xpValue) / 100.0f);
    }

    public static Predicate<BlockWorldState> BlockPumpkin$predicateAny() {
        return state -> true;
    }

    public static void BlockPumpkin$trySpawnGolem(BlockPattern snowman, BlockPattern ironGolem, World worldIn, BlockPos pos) {
        block11: {
            Block blockBelow = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
            boolean isSnowMan = false;
            BlockPattern.PatternHelper pattern = null;
            if (blockBelow == Blocks.field_150433_aE) {
                pattern = snowman.func_177681_a(worldIn, pos);
                isSnowMan = true;
            } else if (blockBelow == Blocks.field_150339_S) {
                pattern = ironGolem.func_177681_a(worldIn, pos);
            }
            if (pattern == null) break block11;
            if (isSnowMan) {
                for (int i = 0; i < snowman.func_177685_b(); ++i) {
                    BlockPos p = pattern.func_177670_a(0, i, 0).func_177508_d();
                    worldIn.func_180501_a(p, Blocks.field_150350_a.func_176223_P(), 2);
                    worldIn.func_175722_b(p, Blocks.field_150350_a, false);
                }
                EntitySnowman entitysnowman = new EntitySnowman(worldIn);
                BlockPos blockpos1 = pattern.func_177670_a(0, 2, 0).func_177508_d();
                entitysnowman.func_70012_b((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.05, (double)blockpos1.func_177952_p() + 0.5, 0.0f, 0.0f);
                worldIn.func_72838_d((Entity)entitysnowman);
                for (EntityPlayerMP player : worldIn.func_72872_a(EntityPlayerMP.class, entitysnowman.func_174813_aQ().func_186662_g(5.0))) {
                    CriteriaTriggers.field_192133_m.func_192229_a(player, (Entity)entitysnowman);
                }
            } else {
                for (int i = 0; i < ironGolem.func_177685_b(); ++i) {
                    if (i == 1) {
                        for (int g = 0; g < ironGolem.func_177684_c(); ++g) {
                            BlockPos p = pattern.func_177670_a(g, i, 0).func_177508_d();
                            worldIn.func_180501_a(p, Blocks.field_150350_a.func_176223_P(), 2);
                            worldIn.func_175722_b(p, Blocks.field_150350_a, false);
                        }
                        continue;
                    }
                    BlockPos p = pattern.func_177670_a(1, i, 0).func_177508_d();
                    worldIn.func_180501_a(p, Blocks.field_150350_a.func_176223_P(), 2);
                    worldIn.func_175722_b(p, Blocks.field_150350_a, false);
                }
                BlockPos blockpos = pattern.func_177670_a(1, 2, 0).func_177508_d();
                EntityIronGolem entityirongolem = new EntityIronGolem(worldIn);
                entityirongolem.func_70849_f(true);
                entityirongolem.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.05, (double)blockpos.func_177952_p() + 0.5, 0.0f, 0.0f);
                worldIn.func_72838_d((Entity)entityirongolem);
                for (EntityPlayerMP player : worldIn.func_72872_a(EntityPlayerMP.class, entityirongolem.func_174813_aQ().func_186662_g(5.0))) {
                    CriteriaTriggers.field_192133_m.func_192229_a(player, (Entity)entityirongolem);
                }
            }
        }
    }

    public static float EntityPlayer$getEyeHeight(float original, EntityPlayer player) {
        return player.func_184613_cA() ? 0.4f : original;
    }

    public static boolean RenderPlayer$isSneak(boolean original, EntityLivingBase entity) {
        return original && !entity.func_184613_cA();
    }

    public static float ModelPlayer$setRotationAngles(Entity entity, float original) {
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_184613_cA()) {
            return 0.0f;
        }
        return original;
    }

    public static EnumDyeColor EntityShulker$getColorFromStack(EntityShulker shulker, EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        EnumDyeColor color = IntegrationHandler.ShulkerColoring$getColor(player, hand, stack);
        if (color != null) {
            return color;
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        if (ids.length == 0) {
            return null;
        }
        for (int i : ids) {
            if (i == OreDictionary.getOreID((String)"dyeWhite")) {
                color = EnumDyeColor.WHITE;
                break;
            }
            if (i == OreDictionary.getOreID((String)"dyeOrange")) {
                color = EnumDyeColor.ORANGE;
                break;
            }
            if (i == OreDictionary.getOreID((String)"dyeMagenta")) {
                color = EnumDyeColor.MAGENTA;
                break;
            }
            if (i == OreDictionary.getOreID((String)"dyeLightBlue")) {
                color = EnumDyeColor.LIGHT_BLUE;
                break;
            }
            if (i == OreDictionary.getOreID((String)"dyeYellow")) {
                color = EnumDyeColor.YELLOW;
                break;
            }
            if (i == OreDictionary.getOreID((String)"dyeLime")) {
                color = EnumDyeColor.LIME;
                break;
            }
            if (i == OreDictionary.getOreID((String)"dyePink")) {
                color = EnumDyeColor.PINK;
                break;
            }
            if (i == OreDictionary.getOreID((String)"dyeGray")) {
                color = EnumDyeColor.GRAY;
                break;
            }
            if (i == OreDictionary.getOreID((String)"dyeLightGray")) {
                color = EnumDyeColor.SILVER;
                break;
            }
            if (i == OreDictionary.getOreID((String)"dyeCyan")) {
                color = EnumDyeColor.CYAN;
                break;
            }
            if (i == OreDictionary.getOreID((String)"dyePurple")) {
                color = EnumDyeColor.PURPLE;
                break;
            }
            if (i == OreDictionary.getOreID((String)"dyeBlue")) {
                color = EnumDyeColor.BLUE;
                break;
            }
            if (i == OreDictionary.getOreID((String)"dyeBrown")) {
                color = EnumDyeColor.BROWN;
                break;
            }
            if (i == OreDictionary.getOreID((String)"dyeGreen")) {
                color = EnumDyeColor.GREEN;
                break;
            }
            if (i == OreDictionary.getOreID((String)"dyeRed")) {
                color = EnumDyeColor.RED;
                break;
            }
            if (i != OreDictionary.getOreID((String)"dyeBlack")) continue;
            color = EnumDyeColor.BLACK;
            break;
        }
        if (shulker.func_190769_dn() == color) {
            return null;
        }
        if (color != null) {
            if (stack.func_77984_f()) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            } else {
                stack.func_190918_g(1);
            }
        }
        return color;
    }

    public static double TileEntity$getDistance(double d, TileEntity te) {
        double defVal;
        double d2 = defVal = FixerooConfig.TESRDistance.maxDistance == 0.0 ? d : FixerooConfig.TESRDistance.maxDistance;
        if (Fixeroo.TE_DISTANCE == null || Fixeroo.TE_DISTANCE.isEmpty()) {
            return defVal;
        }
        ResourceLocation location = TileEntity.func_190559_a(te.getClass());
        double distance = Fixeroo.TE_DISTANCE.getDouble((Object)location);
        if (distance == 0.0) {
            return defVal;
        }
        return distance;
    }
}

