/*
 * Decompiled with CFR 0.152.
 */
package surreal.fixeroo;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import org.jetbrains.annotations.Nullable;
import surreal.fixeroo.FixerooConfig;
import surreal.fixeroo.events.EventXPOrb;

@Mod.EventBusSubscriber
@Mod(modid="xporbclump", name="Fixeroo", version="2.3.5-hotfix.1", dependencies="required-after:configanytime")
public class Fixeroo {
    public static final String MODID = "xporbclump";
    public static final Object2DoubleMap<ResourceLocation> TE_DISTANCE = Fixeroo.getDistanceMap();

    @Mod.EventHandler
    public void construction(FMLConstructionEvent event) {
        if (FixerooConfig.xpOrbClump.enable) {
            MinecraftForge.EVENT_BUS.register(EventXPOrb.class);
        }
    }

    @Nullable
    public static Object2DoubleMap<ResourceLocation> getDistanceMap() {
        System.out.println(Arrays.toString(FixerooConfig.TESRDistance.distanceList));
        if (FixerooConfig.TESRDistance.distanceList.length == 0) {
            return null;
        }
        Object2DoubleOpenHashMap map = new Object2DoubleOpenHashMap();
        for (String str : FixerooConfig.TESRDistance.distanceList) {
            String[] split = str.split("#");
            if (split.length != 2) {
                throw new RuntimeException("Config expression is wrong " + str);
            }
            double d = split[1].toLowerCase(Locale.US).equals("max") ? Double.MAX_VALUE : Double.parseDouble(split[1]);
            if (d <= 0.0) {
                throw new RuntimeException("Config the given distance can't be 0 or negative");
            }
            map.put((Object)new ResourceLocation(split[0]), d);
        }
        return map;
    }
}

