/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.util.handlers;

import com.p1ut0nium.roughmobsrevamped.entities.BossSkeleton;
import com.p1ut0nium.roughmobsrevamped.entities.BossZombie;
import com.p1ut0nium.roughmobsrevamped.misc.BossHelper;
import com.p1ut0nium.roughmobsrevamped.util.Helpers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="roughmobsrevamped", value={Side.CLIENT})
public class FogEventHandler {
    private static double FOG_RED = 0.7116436;
    private static double FOG_GREEN = 0.81895345;
    private static double FOG_BLUE = 0.99999976;
    private static float FOG_MAX_FARPLANE = 192.0f;
    private static float FOG_MAX_FARPLANE_SCALE = 1.0f;
    private static int FOG_FADE_TIME = 60;
    private static int fog_colorfade_tick = 0;
    private static int fog_farplane_tick = 0;
    private static EntityLiving closestBoss;
    private static float closestBossDistance;
    private static int fogNearPlaneConfig;
    private static int fogMaxDistConfig;
    private static int fogFarPlaneConfig;
    private static float fogFarPlaneScaleConfig;
    private static float fogColorConfigRed;
    private static float fogColorConfigGreen;
    private static float fogColorConfigBlue;
    private static float currentFogColorRed;
    private static float currentFogColorGreen;
    private static float currentFogColorBlue;
    private static float addToRed;
    private static float addToGreen;
    private static float addToBlue;
    private static int currentFarPlane;
    private static float currentFarPlaneScale;
    private static float addToFarPlane;
    private static float addToFarPlaneScale;
    private static boolean outOfRange;
    public static boolean bossDied;
    public static boolean playerRespawned;

    @SubscribeEvent
    public static void onGetFogColor(EntityViewRenderEvent.FogColors event) {
        FOG_RED = event.getRed();
        FOG_GREEN = event.getGreen();
        FOG_BLUE = event.getBlue();
        if (event.getEntity() instanceof EntityPlayer && playerRespawned) {
            event.setRed((float)FOG_RED);
            event.setGreen((float)FOG_GREEN);
            event.setBlue((float)FOG_BLUE);
        }
        if (event.getEntity() instanceof EntityPlayer && BossHelper.bossFogEnabled) {
            EntityLiving boss = FogEventHandler.checkForBossInRange((EntityViewRenderEvent)event);
            if (boss != null && !outOfRange && !bossDied) {
                currentFogColorRed = (float)Helpers.scaleValue(Math.max((float)fogNearPlaneConfig, closestBossDistance), fogNearPlaneConfig, fogMaxDistConfig, fogColorConfigRed, FOG_RED);
                currentFogColorGreen = (float)Helpers.scaleValue(Math.max((float)fogNearPlaneConfig, closestBossDistance), fogNearPlaneConfig, fogMaxDistConfig, fogColorConfigGreen, FOG_GREEN);
                currentFogColorBlue = (float)Helpers.scaleValue(Math.max((float)fogNearPlaneConfig, closestBossDistance), fogNearPlaneConfig, fogMaxDistConfig, fogColorConfigBlue, FOG_BLUE);
                event.setRed(currentFogColorRed);
                event.setGreen(currentFogColorGreen);
                event.setBlue(currentFogColorBlue);
            } else if (bossDied && boss == closestBoss) {
                FogEventHandler.fadeOutFogColor(event);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        FOG_MAX_FARPLANE = event.getFarPlaneDistance();
        if (event.getEntity() instanceof EntityPlayer && playerRespawned) {
            FogEventHandler.renderFog(event.getFogMode(), FOG_MAX_FARPLANE, FOG_MAX_FARPLANE_SCALE);
            playerRespawned = false;
        }
        if (event.getEntity() instanceof EntityPlayer && BossHelper.bossFogEnabled) {
            EntityLiving boss = FogEventHandler.checkForBossInRange((EntityViewRenderEvent)event);
            if (boss != null && !outOfRange && !bossDied) {
                currentFarPlane = (int)Helpers.scaleValue(Math.max((float)fogNearPlaneConfig, closestBossDistance), fogNearPlaneConfig, fogMaxDistConfig, fogFarPlaneConfig, FOG_MAX_FARPLANE);
                currentFarPlaneScale = (float)Helpers.scaleValue(Math.max((float)fogNearPlaneConfig, closestBossDistance), fogNearPlaneConfig, fogMaxDistConfig, fogFarPlaneScaleConfig, FOG_MAX_FARPLANE_SCALE);
                FogEventHandler.renderFog(event.getFogMode(), currentFarPlane, currentFarPlaneScale);
            } else if (bossDied && boss == closestBoss) {
                FogEventHandler.adjustFogFarPlane(event);
            }
        }
    }

    private static void renderFog(int fogMode, float farPlaneDistance, float farPlaneDistanceScale) {
        if (fogMode < 0) {
            GL11.glFogf((int)2915, (float)0.0f);
            GL11.glFogf((int)2916, (float)farPlaneDistance);
        } else {
            GL11.glFogf((int)2915, (float)(farPlaneDistance * farPlaneDistanceScale));
            GL11.glFogf((int)2916, (float)farPlaneDistance);
        }
    }

    private static EntityLiving checkForBossInRange(EntityViewRenderEvent event) {
        EntityPlayer player;
        World world = player.field_70170_p;
        player = (EntityPlayer)event.getEntity();
        List entities = world.func_72872_a(EntityLiving.class, player.func_174813_aQ().func_186662_g((double)fogMaxDistConfig));
        if (!Helpers.containsInstance(entities, BossZombie.class, BossSkeleton.class)) {
            closestBoss = null;
            closestBossDistance = fogMaxDistConfig + 1;
            outOfRange = true;
            return closestBoss;
        }
        for (EntityLiving entity : entities) {
            if (entity.getClass() != BossZombie.class && entity.getClass() != BossSkeleton.class) continue;
            float entityDistance = player.func_70032_d((Entity)entity);
            if (closestBoss == null && entityDistance <= (float)fogMaxDistConfig || closestBoss != null && closestBoss != entity && entityDistance < player.func_70032_d((Entity)closestBoss)) {
                closestBoss = entity;
                outOfRange = false;
                return closestBoss;
            }
            if (entity != closestBoss || !(entityDistance > (float)fogMaxDistConfig)) continue;
            closestBoss = null;
            closestBossDistance = fogMaxDistConfig + 1;
            outOfRange = true;
            return closestBoss;
        }
        if (closestBoss != null) {
            closestBossDistance = player.func_70032_d((Entity)closestBoss);
        }
        return closestBoss;
    }

    private static void fadeOutFogColor(EntityViewRenderEvent.FogColors event) {
        if (!outOfRange && ++fog_colorfade_tick == 1) {
            float diff = event.getRed() - currentFogColorRed;
            addToRed = diff / (float)FOG_FADE_TIME;
            diff = event.getGreen() - currentFogColorGreen;
            addToGreen = diff / (float)FOG_FADE_TIME;
            diff = event.getBlue() - currentFogColorBlue;
            addToBlue = diff / (float)FOG_FADE_TIME;
        }
        if (!outOfRange && fog_colorfade_tick <= FOG_FADE_TIME) {
            event.setRed(currentFogColorRed += addToRed);
            event.setGreen(currentFogColorGreen += addToGreen);
            event.setBlue(currentFogColorBlue += addToBlue);
        } else if (fog_colorfade_tick > FOG_FADE_TIME) {
            fog_colorfade_tick = 0;
            outOfRange = true;
            bossDied = false;
        }
    }

    private static void adjustFogFarPlane(EntityViewRenderEvent.RenderFogEvent event) {
        if (!outOfRange && ++fog_farplane_tick == 1) {
            float diff = event.getFarPlaneDistance() - (float)currentFarPlane;
            addToFarPlane = diff / (float)FOG_FADE_TIME;
            diff = FOG_MAX_FARPLANE_SCALE - currentFarPlaneScale;
            addToFarPlaneScale = diff / (float)FOG_FADE_TIME;
        }
        if (!outOfRange && fog_farplane_tick <= FOG_FADE_TIME) {
            currentFarPlane = (int)((float)currentFarPlane + addToFarPlane);
            FogEventHandler.renderFog(event.getFogMode(), currentFarPlane, Math.min(FOG_MAX_FARPLANE_SCALE, currentFarPlaneScale += addToFarPlaneScale));
        } else if (fog_farplane_tick > FOG_FADE_TIME) {
            fog_farplane_tick = 0;
            outOfRange = true;
            bossDied = false;
            FogEventHandler.renderFog(event.getFogMode(), FOG_MAX_FARPLANE, FOG_MAX_FARPLANE_SCALE);
        }
    }

    static {
        fogNearPlaneConfig = BossHelper.bossFogStartDistance;
        fogMaxDistConfig = BossHelper.bossFogMaxDistance;
        fogFarPlaneConfig = BossHelper.bossFogFarPlane;
        fogFarPlaneScaleConfig = BossHelper.bossFogFarPlaneScale;
        fogColorConfigRed = Float.parseFloat(BossHelper.bossFogColor[0]);
        fogColorConfigGreen = Float.parseFloat(BossHelper.bossFogColor[1]);
        fogColorConfigBlue = Float.parseFloat(BossHelper.bossFogColor[2]);
        addToRed = 0.0f;
        addToGreen = 0.0f;
        addToBlue = 0.0f;
        addToFarPlane = 0.0f;
        addToFarPlaneScale = 0.0f;
        outOfRange = true;
    }
}

