/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.misc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.p1ut0nium.roughmobsrevamped.RoughMobs;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.util.Constants;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.ResourceLocation;

public class AttributeHelper {
    private static Multimap<Class<? extends Entity>, AttributeEntry> map;
    public static final String KEY_ATTRIBUTES;

    public static void initAttributeOption() {
        RoughConfig.getConfig().addCustomCategoryComment("attributes", "Add attribute modifiers to entities to change their stats. Takes 4-6 values seperated by a semicolon:\nFormat: entity;attribute;operator;value;dimension;child\nentity:\t\tentity name\nattribute:\tattribute name (Possible attributes: " + AttributeHelper.getAttributesString() + ")\noperator:\t\toperator type (0 = add, 1 = multiply and add)\nvalue:\t\tvalue which will be used for the calculation\ndimension:\tdimension (ID) in which the entity should get the boost (optional! Leave this blank or use a \"/\" for any dimension)\nchild:\t0 = the modifier doesn't care if the entity is a child or not, 1 = adults only, 2 = childs only (optional! Leave this blank for 0)");
        String[] options = RoughConfig.getStringArray("attributes", "Modifier", Constants.ATTRIBUTE_DEFAULT, "Attributes:");
        AttributeHelper.fillMap(options);
    }

    public static boolean applyAttributeModifier(EntityLivingBase entity, IAttribute attribute, String name, int operator, double amount) {
        if (amount != 0.0) {
            IAttributeInstance instance = entity.func_110148_a(attribute);
            AttributeModifier modifier = new AttributeModifier(Constants.unique(name), amount, operator);
            if (instance != null && !instance.func_180374_a(modifier)) {
                instance.func_111121_a(modifier);
                if (attribute == SharedMonsterAttributes.field_111267_a) {
                    entity.func_70606_j(entity.func_110138_aP());
                }
                return true;
            }
        }
        return false;
    }

    public static void addAttributes(EntityLivingBase entity) {
        if (entity.getEntityData().func_74767_n(KEY_ATTRIBUTES)) {
            return;
        }
        Collection attributes = map.get(entity.getClass());
        int i = 0;
        for (AttributeEntry attribute : attributes) {
            if (!attribute.checkChild(entity)) continue;
            IAttributeInstance instance = entity.func_110140_aT().func_111152_a(attribute.attribute);
            if (instance != null) {
                AttributeModifier modifier = new AttributeModifier(attribute.getUuid(), Constants.unique("mod" + i), attribute.getValue(), attribute.getOperator());
                instance.func_111121_a(modifier);
                if (instance.func_111123_a() == SharedMonsterAttributes.field_111267_a) {
                    entity.func_70606_j(entity.func_110138_aP());
                }
            } else {
                RoughMobs.logger.error("Error on attribute modification: \"" + attribute.attribute + "\" is not a valid attribute. Affected Entity: " + entity);
            }
            ++i;
        }
        entity.getEntityData().func_74757_a(KEY_ATTRIBUTES, true);
    }

    private static void fillMap(String[] options) {
        map = ArrayListMultimap.create();
        for (String line : options) {
            String[] pars = line.split(";");
            if (pars.length >= 4) {
                Class entityClass = EntityList.getClass((ResourceLocation)new ResourceLocation(pars[0]));
                if (entityClass != null) {
                    try {
                        int child;
                        int operator = Integer.parseInt(pars[2]);
                        double value = Double.parseDouble(pars[3]);
                        int dimension = pars.length >= 5 && !pars[4].equals("/") ? Integer.parseInt(pars[4]) : Integer.MIN_VALUE;
                        int n = child = pars.length >= 6 ? Integer.parseInt(pars[5]) : 0;
                        if (child < 0 || child > 2) {
                            RoughMobs.logger.error("Error on attribute initialization: child is not between 0 and 2: " + line);
                            continue;
                        }
                        map.put((Object)entityClass, (Object)new AttributeEntry(UUID.randomUUID(), pars[1], operator, value, dimension, child));
                    }
                    catch (NumberFormatException e) {
                        RoughMobs.logger.error("Error on attribute initialization: Invalid numbers: " + line);
                    }
                    continue;
                }
                RoughMobs.logger.error("Error on attribute initialization: Entity " + pars[0] + " does not exist");
                continue;
            }
            RoughMobs.logger.error("Error on attribute initialization: Wrong amount of arguments: " + line);
        }
    }

    private static String getAttributesString() {
        String attributes = "";
        try {
            for (Field field : SharedMonsterAttributes.class.getFields()) {
                field.setAccessible(true);
                Object obj = field.get(null);
                if (obj == null || !(obj instanceof IAttribute)) continue;
                attributes = attributes + ", " + ((IAttribute)obj).func_111108_a();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attributes.length() > 2 ? attributes.substring(2) : "";
    }

    static {
        KEY_ATTRIBUTES = Constants.unique("attributesApplied");
    }

    public static class AttributeEntry {
        private UUID uuid;
        private String attribute;
        private int operator;
        private double value;
        private int dimension;
        private int child;

        public AttributeEntry(UUID uuid, String attribute, int operator, double value, int dimension, int child) {
            this.uuid = uuid;
            this.attribute = attribute;
            this.operator = operator;
            this.value = value;
            this.dimension = dimension;
            this.child = child;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public int getOperator() {
            return this.operator;
        }

        public double getValue() {
            return this.value;
        }

        public int getDimension() {
            return this.dimension;
        }

        public int getChild() {
            return this.child;
        }

        public boolean hasDimension() {
            return this.dimension != Integer.MIN_VALUE;
        }

        public boolean checkChild(EntityLivingBase entity) {
            return this.child == 0 || this.child == 1 && !entity.func_70631_g_() || this.child == 2 && entity.func_70631_g_();
        }
    }
}

