/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.RoughMobs;
import com.p1ut0nium.roughmobsrevamped.ai.combat.RoughAIMobBuff;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.misc.FeatureHelper;
import com.p1ut0nium.roughmobsrevamped.util.Constants;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class WitchFeatures
extends EntityFeatures {
    private float applyEffectsRange;
    private String[] applyEffectNames;
    protected int lingeringChance;
    private int batsOnDeath;
    private Map<Potion, Integer> effects;

    public WitchFeatures() {
        super("witch", EntityWitch.class);
    }

    public EntityFeatures addPotionHandler(List<EntityFeatures> features) {
        features.add(new WitchPotionFeatures(this));
        return this;
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.applyEffectsRange = RoughConfig.getFloat(this.name, "ApplyEffectsRange", 10.0f, 0.0f, 32767.0f, "Range in each direction from the %ses position in which allied mobs get buffed\nSet to 0 to disable this feature");
        this.applyEffectNames = RoughConfig.getStringArray(this.name, "ApplyEffectsNames", Constants.DEFAULT_WITCH_BUFFS, "Potion effects which may be added to nearby mobs\nFormat: effect;amplifier");
        this.lingeringChance = RoughConfig.getInteger(this.name, "LingeringChance", 5, 0, Short.MAX_VALUE, "Chance (1 in X) for a %ses thrown potion to become a lingering potion\nSet to 0 to disable this feature");
        this.batsOnDeath = RoughConfig.getInteger(this.name, "BatsOnDeath", 5, 0, Short.MAX_VALUE, "Amount of bats which spawn on %ses death\nSet to 0 to disable this feature");
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, Entity entity, EntityAITasks tasks, EntityAITasks targetTasks) {
        if (entity instanceof EntityLivingBase && this.applyEffectsRange > 0.0f && !this.effects.isEmpty()) {
            tasks.func_75776_a(1, (EntityAIBase)new RoughAIMobBuff((EntityLivingBase)entity, this.effects, this.applyEffectsRange));
        }
    }

    @Override
    public void onDeath(Entity deadEntity, DamageSource source) {
        for (int i = 0; i < this.batsOnDeath; ++i) {
            EntityBat bat = new EntityBat(deadEntity.func_130014_f_());
            bat.func_70107_b(deadEntity.field_70165_t + Math.random() - Math.random(), deadEntity.field_70163_u + Math.random(), deadEntity.field_70161_v + Math.random() - Math.random());
            bat.func_180482_a(deadEntity.func_130014_f_().func_175649_E(deadEntity.func_180425_c()), null);
            deadEntity.func_130014_f_().func_72838_d((Entity)bat);
        }
    }

    @Override
    public void postInit() {
        this.effects = FeatureHelper.getPotionsFromNames(this.applyEffectNames);
    }

    public static class WitchPotionFeatures
    extends EntityFeatures {
        private WitchFeatures features;

        public WitchPotionFeatures(WitchFeatures features) {
            super("potion", EntityPotion.class);
            this.features = features;
        }

        @Override
        public void addFeatures(EntityJoinWorldEvent event, Entity entity) {
            if (entity instanceof EntityPlayer) {
                RoughMobs.logger.debug("Entity is player...skipping addFeatures");
                return;
            }
            if (this.features.lingeringChance <= 0 || !(entity instanceof EntityPotion) || !(((EntityPotion)entity).func_85052_h() instanceof EntityWitch)) {
                return;
            }
            if (entity.func_130014_f_().field_73012_v.nextInt(this.features.lingeringChance) == 0) {
                ItemStack potion = new ItemStack((Item)Items.field_185156_bI);
                PotionUtils.func_185188_a((ItemStack)potion, (PotionType)PotionUtils.func_185191_c((ItemStack)((EntityPotion)entity).func_184543_l()));
                ((EntityPotion)entity).func_184541_a(potion);
            }
        }
    }
}

