/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.entities;

import com.p1ut0nium.roughmobsrevamped.entities.IBoss;
import com.p1ut0nium.roughmobsrevamped.misc.BossHelper;
import com.p1ut0nium.roughmobsrevamped.util.DamageSourceFog;
import com.p1ut0nium.roughmobsrevamped.util.Helpers;
import com.p1ut0nium.roughmobsrevamped.util.handlers.FogEventHandler;
import com.p1ut0nium.roughmobsrevamped.util.handlers.SoundHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class BossSkeleton
extends EntitySkeleton
implements IBoss {
    private static boolean FOG_DOT_ENABLED = BossHelper.bossFogDoTEnabled;
    private static boolean FOG_WARNING_ENABLED = BossHelper.bossFogDoTWarning;
    private static int FOG_MAX_DISTANCE = BossHelper.bossFogMaxDistance;
    private static int FOG_DOT_DELAY = BossHelper.bossFogDoTDelay * 20;
    private static int FOG_WARNING_TIME = BossHelper.bossFogDoTWarningTime * 20;
    private HashMap<String, Long> playersWarned = new HashMap();
    private List<EntityPlayer> playersInFog = new ArrayList<EntityPlayer>();
    private TextComponentTranslation fogWarningMsg;
    private static int fog_dot_tick;

    public BossSkeleton(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 100;
        fog_dot_tick = 0;
        this.fogWarningMsg = new TextComponentTranslation("translation.warning.fog", new Object[0]);
        this.fogWarningMsg.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.field_70170_p.field_72995_K && this.field_70163_u >= (double)this.field_70170_p.func_181545_F() && this.field_70170_p.func_175678_i(this.func_180425_c())) {
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, true));
            SoundEvent soundEvent = new SoundEvent(new ResourceLocation("entity.lightning.thunder"));
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, soundEvent, SoundCategory.AMBIENT, 100.0f, 1.0f, true);
        }
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (!this.field_70170_p.field_72995_K && FOG_DOT_ENABLED) {
            List playersInRange = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g((double)FOG_MAX_DISTANCE));
            if (Helpers.containsInstance(playersInRange, EntityPlayer.class)) {
                for (EntityPlayer player : playersInRange) {
                    if (this.playersInFog.contains(player)) continue;
                    this.playersInFog.add(player);
                    if (!FOG_WARNING_ENABLED) continue;
                    if (!this.playersWarned.containsKey(player.func_70005_c_())) {
                        this.playersWarned.put(player.func_70005_c_(), this.field_70170_p.func_72820_D() + (long)FOG_WARNING_TIME);
                        player.func_145747_a((ITextComponent)this.fogWarningMsg);
                        continue;
                    }
                    if (!this.playersWarned.containsKey(player.func_70005_c_()) || this.field_70170_p.func_72820_D() < this.playersWarned.get(player.func_70005_c_())) continue;
                    this.playersWarned.replace(player.func_70005_c_(), this.field_70170_p.func_72820_D() + (long)FOG_WARNING_TIME);
                    player.func_145747_a((ITextComponent)this.fogWarningMsg);
                }
                Iterator<EntityPlayer> playersInFogIterator = this.playersInFog.iterator();
                while (playersInFogIterator.hasNext()) {
                    EntityPlayer playerInFog = playersInFogIterator.next();
                    if (Helpers.containsPlayer(playersInRange, playerInFog)) continue;
                    playersInFogIterator.remove();
                }
                if (fog_dot_tick == FOG_DOT_DELAY) {
                    fog_dot_tick = 0;
                }
                if (fog_dot_tick == 0) {
                    for (EntityPlayer player : playersInRange) {
                        player.func_70097_a(DamageSourceFog.POISONOUS_FOG, 0.0f);
                    }
                }
                ++fog_dot_tick;
            } else if (!Helpers.containsInstance(playersInRange, EntityPlayer.class)) {
                this.playersInFog.clear();
            }
        }
        super.func_70636_d();
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        FogEventHandler.bossDied = true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundHandler.ENTITY_BOSS_IDLE;
    }

    protected SoundEvent func_184615_bR() {
        return SoundHandler.ENTITY_BOSS_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186383_ah;
    }
}

