/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.compat;

import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;

public abstract class GameStagesCompat {
    private static boolean registered;
    private static Boolean useEquipmentStage;
    private static Boolean useAllStages;
    private static Boolean useBossStage;
    private static Boolean useEnchantStage;
    private static Boolean useAbilitiesStage;

    private GameStagesCompat() {
    }

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        GameStagesCompat.preInit();
    }

    private static void preInit() {
        if (!GameStagesCompat.hasDefaultConfig()) {
            return;
        }
        RoughConfig.getConfig().addCustomCategoryComment("GameStages", "Configuration options for enabling/disabling Game Stages.\nThe mod Game Stages must be installed for these features to work.\n\nStages to give player in-game: \n\nroughmobsall - gives all stages at once.\nroughmobsequip - allows mobs to spawn with equipment.\nroughmobsenchant - allows mob gear to be enchanted.\nroughmobsboss - allows some mobs to be bosses.\nroughmobsabils - allows mobs to have special abilities.");
        useAllStages = RoughConfig.getBoolean("GameStages", "_All", false, "Enable this Game Stage to allow all Rough Mobs stages at once. Or turn them on individually");
        useEquipmentStage = RoughConfig.getBoolean("GameStages", "_Equipment", false, "Enable this Game stage for Rough Mobs to have equipment.");
        useBossStage = RoughConfig.getBoolean("GameStages", "_Bosses", false, "Enable this Game Stage needed for Rough Mob Bosses to spawn. Must also enable Equipment stage for this to work.");
        useAbilitiesStage = RoughConfig.getBoolean("GameStages", "_Abilities", false, "Enable this Game Stage for Rough Mobs to have special combat AI and attributes.");
        useEnchantStage = RoughConfig.getBoolean("GameStages", "_Enchantments", false, "Enable this Game Stage for Rough Mob equipment to be enchanted.");
        if (useAllStages.booleanValue()) {
            useAbilitiesStage = useEnchantStage = Boolean.valueOf(true);
            useBossStage = useEnchantStage;
            useEquipmentStage = useEnchantStage;
        }
    }

    private static boolean hasDefaultConfig() {
        return true;
    }

    public static Boolean useEquipmentStage() {
        if (registered) {
            return useEquipmentStage;
        }
        return false;
    }

    public static Boolean useAllStages() {
        if (registered) {
            return useAllStages;
        }
        return false;
    }

    public static Boolean useBossStage() {
        if (registered) {
            return useBossStage;
        }
        return false;
    }

    public static Boolean useEnchantStage() {
        if (registered) {
            return useEnchantStage;
        }
        return false;
    }

    public static Boolean useAbilitiesStage() {
        if (registered) {
            return useAbilitiesStage;
        }
        return false;
    }
}

