/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped;

import com.p1ut0nium.roughmobsrevamped.RoughMobs;
import com.p1ut0nium.roughmobsrevamped.compat.CompatHandler;
import com.p1ut0nium.roughmobsrevamped.compat.GameStagesCompat;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.entities.IBoss;
import com.p1ut0nium.roughmobsrevamped.features.BlazeFeatures;
import com.p1ut0nium.roughmobsrevamped.features.CreeperFeatures;
import com.p1ut0nium.roughmobsrevamped.features.EndermanFeatures;
import com.p1ut0nium.roughmobsrevamped.features.EndermiteFeatures;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.features.GhastFeatures;
import com.p1ut0nium.roughmobsrevamped.features.GuardianFeatures;
import com.p1ut0nium.roughmobsrevamped.features.HostileHorseFeatures;
import com.p1ut0nium.roughmobsrevamped.features.MagmaCubeFeatures;
import com.p1ut0nium.roughmobsrevamped.features.SilverfishFeatures;
import com.p1ut0nium.roughmobsrevamped.features.SkeletonFeatures;
import com.p1ut0nium.roughmobsrevamped.features.SlimeFeatures;
import com.p1ut0nium.roughmobsrevamped.features.SpiderFeatures;
import com.p1ut0nium.roughmobsrevamped.features.WitchFeatures;
import com.p1ut0nium.roughmobsrevamped.features.WitherFeatures;
import com.p1ut0nium.roughmobsrevamped.features.ZombieFeatures;
import com.p1ut0nium.roughmobsrevamped.features.ZombiePigmanFeatures;
import com.p1ut0nium.roughmobsrevamped.misc.AttributeHelper;
import com.p1ut0nium.roughmobsrevamped.misc.BossHelper;
import com.p1ut0nium.roughmobsrevamped.misc.EquipHelper;
import com.p1ut0nium.roughmobsrevamped.misc.SpawnHelper;
import com.p1ut0nium.roughmobsrevamped.misc.TargetHelper;
import com.p1ut0nium.roughmobsrevamped.util.Constants;
import com.p1ut0nium.roughmobsrevamped.util.DamageSourceFog;
import com.p1ut0nium.roughmobsrevamped.util.handlers.FogEventHandler;
import com.p1ut0nium.roughmobsrevamped.util.handlers.SoundHandler;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RoughApplier {
    public static final String FEATURES_APPLIED = Constants.unique("featuresApplied");
    public static final List<EntityFeatures> FEATURES = new ArrayList<EntityFeatures>();
    private static boolean gameStagesEnabled;
    private static boolean playerHasAbilsStage;
    private static boolean abilsStageEnabled;
    private static boolean equipStageEnabled;
    private static boolean playerHasEquipStage;

    public RoughApplier() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FEATURES.add(new ZombieFeatures());
        FEATURES.add(new SkeletonFeatures());
        FEATURES.add(new HostileHorseFeatures());
        FEATURES.add(new CreeperFeatures());
        FEATURES.add(new SlimeFeatures());
        FEATURES.add(new EndermanFeatures());
        FEATURES.add(new SpiderFeatures());
        FEATURES.add(new WitchFeatures().addPotionHandler(FEATURES));
        FEATURES.add(new SilverfishFeatures());
        FEATURES.add(new ZombiePigmanFeatures());
        FEATURES.add(new BlazeFeatures());
        FEATURES.add(new GhastFeatures());
        FEATURES.add(new MagmaCubeFeatures());
        FEATURES.add(new WitherFeatures());
        FEATURES.add(new EndermiteFeatures());
        FEATURES.add(new GuardianFeatures());
    }

    public void preInit() {
        for (EntityFeatures features : FEATURES) {
            features.preInit();
        }
        RoughConfig.loadFeatures();
    }

    public void postInit() {
        for (EntityFeatures features : FEATURES) {
            features.postInit();
        }
        AttributeHelper.initAttributeOption();
        SpawnHelper.initSpawnOption();
        SpawnHelper.addEntries();
        BossHelper.initGlobalBossConfig();
        TargetHelper.init();
        RoughConfig.saveFeatures();
    }

    private void getGameStages(EntityPlayer player) {
        gameStagesEnabled = CompatHandler.isGameStagesLoaded();
        abilsStageEnabled = GameStagesCompat.useAbilitiesStage();
        equipStageEnabled = GameStagesCompat.useEquipmentStage();
        if (gameStagesEnabled) {
            playerHasEquipStage = GameStageHelper.hasAnyOf((EntityPlayer)player, (String[])new String[]{"roughmobsall", "roughmobsequip"});
            playerHasAbilsStage = GameStageHelper.hasAnyOf((EntityPlayer)player, (String[])new String[]{"roughmobsall", "roughmobsabils"});
        } else {
            playerHasAbilsStage = false;
            playerHasEquipStage = false;
        }
    }

    private void addAttributes(EntityLiving entity) {
        if ((!abilsStageEnabled || abilsStageEnabled && playerHasAbilsStage) && entity instanceof EntityLiving) {
            AttributeHelper.addAttributes((EntityLivingBase)entity);
        }
    }

    private void addFeatures(EntityJoinWorldEvent event, EntityLiving entity) {
        boolean isBoss = entity instanceof IBoss;
        if (entity.getClass().equals(EntityPlayer.class)) {
            RoughMobs.logger.debug("Entity is player...skipping addFeatures");
            return;
        }
        for (EntityFeatures features : FEATURES) {
            if (!features.isEntity((Entity)entity)) continue;
            if ((!isBoss || entity.func_70631_g_() && !EquipHelper.disableBabyZombieEquipment()) && (!equipStageEnabled || equipStageEnabled && playerHasEquipStage) && !entity.getEntityData().func_74767_n(FEATURES_APPLIED)) {
                features.addFeatures(event, (Entity)entity);
            }
            if (abilsStageEnabled && (!abilsStageEnabled || !playerHasAbilsStage) || !(entity instanceof EntityLiving)) continue;
            features.addAI(event, (Entity)entity, entity.field_70714_bg, entity.field_70715_bh);
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingAttackEvent event) {
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer && !(player = (EntityPlayer)event.getEntity()).func_184812_l_() && event.getSource().equals(DamageSourceFog.POISONOUS_FOG) && BossHelper.bossFogPlayerCough) {
            this.playHurtSound(player);
        }
    }

    private void playHurtSound(EntityPlayer player) {
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundHandler.ENTITY_PLAYER_COUGH, SoundCategory.PLAYERS, 1.0f, (float)Math.max(0.75, Math.random()));
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            FogEventHandler.playerRespawned = true;
        }
        if (event.getWorld().field_72995_K || event.getEntity() instanceof EntityPlayer || !(event.getEntity() instanceof EntityLiving)) {
            return;
        }
        EntityLiving entity = (EntityLiving)event.getEntity();
        boolean isBoss = entity instanceof IBoss;
        boolean canSpawn = SpawnHelper.checkSpawnConditions(event);
        if (TargetHelper.targetAttackerEnabled() && canSpawn || TargetHelper.targetAttackerEnabled() && TargetHelper.ignoreSpawnConditions) {
            TargetHelper.setTargets((Entity)entity);
        }
        if (!isBoss && !canSpawn) {
            return;
        }
        this.getGameStages(entity.field_70170_p.func_72890_a((Entity)entity, -1.0));
        this.addAttributes(entity);
        this.addFeatures(event, entity);
        entity.getEntityData().func_74757_a(FEATURES_APPLIED, true);
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        Entity trueSource = event.getSource().func_76346_g();
        Entity immediateSource = event.getSource().func_76364_f();
        Entity target = event.getEntity();
        if (trueSource == null || target == null || target instanceof FakePlayer || trueSource instanceof FakePlayer || immediateSource instanceof FakePlayer || target.field_70170_p.field_72995_K) {
            return;
        }
        for (EntityFeatures features : FEATURES) {
            if (trueSource instanceof EntityLiving && features.isEntity((Entity)((EntityLiving)trueSource)) && (!(target instanceof EntityPlayer) || !((EntityPlayer)target).func_184812_l_())) {
                features.onAttack((Entity)((EntityLiving)trueSource), immediateSource, target, event);
            }
            if (!(target instanceof EntityLiving) || !features.isEntity((Entity)((EntityLiving)target)) || trueSource instanceof EntityPlayer && ((EntityPlayer)trueSource).func_184812_l_()) continue;
            features.onDefend((Entity)((EntityLiving)target), trueSource, immediateSource, event);
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        Entity deadEntity = event.getEntity();
        if (deadEntity == null || deadEntity.field_70170_p.field_72995_K || !(deadEntity instanceof EntityLiving)) {
            return;
        }
        for (EntityFeatures features : FEATURES) {
            if (!features.isEntity((Entity)((EntityLiving)deadEntity))) continue;
            features.onDeath((Entity)((EntityLiving)deadEntity), event.getSource());
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        Entity entity = event.getEntity();
        if (entity == null || entity.field_70170_p.field_72995_K || !(entity instanceof EntityLiving)) {
            return;
        }
        for (EntityFeatures features : FEATURES) {
            if (!features.isEntity((Entity)((EntityLiving)entity))) continue;
            features.onFall((Entity)((EntityLiving)entity), event);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (player == null || player.field_70170_p.field_72995_K || player.func_184812_l_()) {
            return;
        }
        for (EntityFeatures features : FEATURES) {
            features.onBlockBreak(player, event);
        }
    }

    @SubscribeEvent
    public void onTarget(LivingSetAttackTargetEvent event) {
        if (!(TargetHelper.targetBlockerEnabled() && event.getTarget() != null && event.getTarget() instanceof EntityLiving && event.getEntityLiving() instanceof EntityLiving)) {
            return;
        }
        Class<? extends Entity> invalidAttacker = TargetHelper.getBlockerEntityForTarget((Entity)event.getTarget());
        if (invalidAttacker != null && invalidAttacker.isInstance(event.getEntityLiving())) {
            EntityPlayer player = event.getEntityLiving().func_130014_f_().func_184142_a((Entity)event.getEntityLiving(), 32.0, 32.0);
            if (player != null && player.func_184191_r((Entity)event.getEntityLiving())) {
                return;
            }
            event.getEntityLiving().func_70604_c((EntityLivingBase)player);
            ((EntityLiving)event.getEntityLiving()).func_70624_b((EntityLivingBase)player);
            System.out.println("invalidAttacker = " + invalidAttacker.getName() + "; blocked target");
        }
    }
}

