/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.mixins;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ForgeRegistry.class}, remap=false)
public abstract class MixinBlockDirt<V extends IForgeRegistryEntry<V>>
implements IForgeRegistryInternal<V>,
IForgeRegistryModifiable<V> {
    ResourceLocation firstResourceValue = new ResourceLocation("thermalfoundation:ore");
    Set<ResourceLocation> resourceLocations = new HashSet<ResourceLocation>();

    @Shadow
    abstract int add(int var1, V var2);

    @Overwrite
    public void registerAll(V ... values) {
        if (this.resourceLocations.isEmpty()) {
            this.fillResourceLocations();
        }
        for (V value : values) {
            if (this.resourceLocations.contains(value.getRegistryName())) continue;
            this.register(value);
        }
    }

    @Overwrite
    public void register(V value) {
        if (this.resourceLocations.isEmpty()) {
            this.fillResourceLocations();
        }
        if (!this.resourceLocations.contains(value.getRegistryName())) {
            this.add(-1, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fillResourceLocations() {
        String filePath = Loader.instance().getConfigDir().toString();
        String file = "/malekremoveregistries.txt";
        try {
            File myObj = new File(Loader.instance().getConfigDir() + file);
            if (!myObj.createNewFile()) {
                // empty if block
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File text = new File(Loader.instance().getConfigDir() + file);
        Scanner scnr = null;
        try {
            scnr = new Scanner(text);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        while (scnr.hasNext()) {
            this.resourceLocations.add(new ResourceLocation(scnr.next()));
        }
        return;
    }
}

