/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.from_the_depths.resource_loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wuest.from_the_depths.FromTheDepths;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.fml.client.FMLClientHandler;

@ParametersAreNonnullByDefault
public class TotemTextureLoader
implements IResourcePack,
IResourceType {
    public static final String DOMAIN = "from_the_depths_totem";
    private final IResourcePack fromTheDepthsRP = FMLClientHandler.instance().getResourcePackFor("from_the_depths");
    private final Path modDirectory;

    public TotemTextureLoader() {
        this.modDirectory = Minecraft.func_71410_x().field_71412_D.toPath().resolve("config" + File.separatorChar + "FTD_Summons");
        Path subDir = this.modDirectory.resolve("textures");
        subDir.toFile().mkdirs();
        subDir.resolveSibling("models/item").toFile().mkdirs();
    }

    public static void generateItemModels(String bossKey) throws IOException {
        File modelFile = FromTheDepths.proxy.modDirectory.resolve("models" + File.separatorChar + "item" + File.separatorChar + bossKey + ".json").toFile();
        boolean wasCreated = modelFile.createNewFile();
        if (wasCreated) {
            JsonObject modelObj = new JsonObject();
            modelObj.addProperty("parent", "item/generated");
            JsonObject texturesObj = new JsonObject();
            texturesObj.addProperty("layer0", "from_the_depths_totem:" + bossKey);
            modelObj.add("textures", (JsonElement)texturesObj);
            BufferedWriter writer = new BufferedWriter(new FileWriter(modelFile));
            writer.write(modelObj.toString());
            writer.flush();
            writer.close();
        } else {
            FromTheDepths.logger.warn("Warning: Item Model File for boss " + bossKey + " couldn't be generated!");
        }
    }

    @Nullable
    public InputStream func_110590_a(ResourceLocation location) throws IOException {
        if (this.func_110589_b(location)) {
            File file = FromTheDepths.proxy.modDirectory.resolve(location.func_110623_a()).toFile();
            return new FileInputStream(file);
        }
        return this.fromTheDepthsRP.func_110590_a(new ResourceLocation("from_the_depths", "textures/items/item_totem_of_summoning.png"));
    }

    public boolean func_110589_b(ResourceLocation location) {
        return this.modDirectory.resolve(location.func_110623_a()).toFile().exists();
    }

    @Nonnull
    public Set<String> func_110587_b() {
        return Collections.singleton(DOMAIN);
    }

    @Nullable
    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
        return null;
    }

    @Nonnull
    public BufferedImage func_110586_a() throws IOException {
        InputStream stream = this.fromTheDepthsRP.func_110590_a(new ResourceLocation("from_the_depths", "textures/items/item_totem_of_summoning.png"));
        return ImageIO.read(stream);
    }

    @Nonnull
    public String func_130077_b() {
        return "Totem Texture Loader";
    }
}

