/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.from_the_depths.items;

import com.google.common.base.Strings;
import com.wuest.from_the_depths.FromTheDepths;
import com.wuest.from_the_depths.ModRegistry;
import com.wuest.from_the_depths.Utilities;
import com.wuest.from_the_depths.base.Triple;
import com.wuest.from_the_depths.config.ConfigTileEntityAltarOfSpawning;
import com.wuest.from_the_depths.entityinfo.SpawnInfo;
import com.wuest.from_the_depths.entityinfo.restrictions.RestrictionBundle;
import com.wuest.from_the_depths.tileentity.TileEntityAltarOfSpawning;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ItemTotemOfSpawning
extends Item {
    public String key;

    public ItemTotemOfSpawning(String key, String name) {
        this.key = key;
        this.func_77637_a(FromTheDepths.CREATIVE_TAB);
        if (key != null && !key.isEmpty()) {
            String registryName = name + "_" + key.toLowerCase().trim().replace(' ', '_').replace('-', '_').replace('\t', '_');
            ModRegistry.setItemName(this, registryName);
        } else {
            ModRegistry.setItemName(this, name);
        }
        this.func_77655_b("from_the_depths:" + name);
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
            stack.func_77982_d(stack.serializeNBT());
        }
        return stack.func_77978_p();
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        SpawnInfo spawnInfo = this.getSpawnInfoFromItemStack(stack);
        if (spawnInfo != null) {
            String[] splitKey = spawnInfo.key.split("\\W|_");
            String processedKey = Arrays.stream(splitKey).map(Utilities::capitalize).collect(Collectors.joining(" "));
            return Utilities.localize(stack.func_77977_a(), new Object[0]).trim() + " (" + processedKey + ")";
        }
        return Utilities.localize(stack.func_77977_a(), new Object[0]).trim() + " (" + Utilities.localize("from_the_depths.messages.no_boss", new Object[0]) + ")";
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, World worldIn, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                TileEntity tileEntity = worldIn.func_175625_s(pos);
                if (tileEntity instanceof TileEntityAltarOfSpawning) {
                    TileEntityAltarOfSpawning tileEntityAltarOfSpawning = (TileEntityAltarOfSpawning)tileEntity;
                    ItemStack heldStack = player.func_184586_b(hand);
                    if (((ConfigTileEntityAltarOfSpawning)tileEntityAltarOfSpawning.getConfig()).currentSpawnInfo != null && !Strings.isNullOrEmpty((String)((ConfigTileEntityAltarOfSpawning)tileEntityAltarOfSpawning.getConfig()).currentSpawnInfo.key)) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("from_the_depths.messages.early_summon", new Object[0]));
                    } else {
                        ItemTotemOfSpawning totemOfSpawning;
                        SpawnInfo spawnInfo;
                        if (FromTheDepths.proxy.getServerConfiguration().enableArenaStyleRestrictions) {
                            Triple<Boolean, BlockPos, BlockPos> result = Utilities.isSpaceAroundAltarAir(pos, worldIn);
                            if (!result.getFirst().booleanValue()) {
                                TextComponentTranslation message = new TextComponentTranslation("from_the_depths.messages.invalid_arena", new Object[]{FromTheDepths.proxy.getServerConfiguration().altarSpawningRadius, FromTheDepths.proxy.getServerConfiguration().altarSpawningHeight});
                                player.func_145747_a((ITextComponent)message);
                                return EnumActionResult.FAIL;
                            }
                            result = Utilities.isGroundUnderAltarSolid(pos, worldIn, FromTheDepths.proxy.getServerConfiguration().altarSpawningRadius);
                            if (!result.getFirst().booleanValue()) {
                                TextComponentTranslation message = new TextComponentTranslation("from_the_depths.messages.invalid_arena_ground", new Object[]{FromTheDepths.proxy.getServerConfiguration().altarSpawningRadius});
                                player.func_145747_a((ITextComponent)message);
                                return EnumActionResult.FAIL;
                            }
                        }
                        if ((spawnInfo = (totemOfSpawning = (ItemTotemOfSpawning)heldStack.func_77973_b()).getSpawnInfoFromItemStack(heldStack)) != null) {
                            Pair<Boolean, TextComponentTranslation> testResults;
                            RestrictionBundle restrictionBundle = ModRegistry.spawnRestrictions.get(spawnInfo.key);
                            if (restrictionBundle != null && !((Boolean)(testResults = restrictionBundle.testAll(spawnInfo.key, worldIn, pos)).getLeft()).booleanValue()) {
                                player.func_145747_a((ITextComponent)testResults.getRight());
                                return EnumActionResult.FAIL;
                            }
                            if (spawnInfo.bossInfo.isValidEntity(worldIn)) {
                                if (heldStack.func_190916_E() == 1) {
                                    player.field_71071_by.func_184437_d(heldStack);
                                } else {
                                    heldStack.func_190918_g(1);
                                }
                                player.field_71069_bz.func_75142_b();
                                tileEntityAltarOfSpawning.InitiateSpawning(spawnInfo.clone(), 20, worldIn);
                                return EnumActionResult.SUCCESS;
                            }
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("from_the_depths.messages.boss_entity_not_found", new Object[]{spawnInfo.bossInfo.name, spawnInfo.bossInfo.domain}));
                        }
                    }
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("from_the_depths.messages.peaceful_mode", new Object[0]));
            }
        }
        return EnumActionResult.FAIL;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack heldStack = playerIn.func_184586_b(handIn);
        SpawnInfo info = this.getSpawnInfoFromItemStack(heldStack);
        if (info != null) {
            return new ActionResult(EnumActionResult.PASS, (Object)heldStack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)heldStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        SpawnInfo spawnInfo = this.getSpawnInfoFromItemStack(stack);
        if (spawnInfo != null && ModRegistry.spawnRestrictions.containsKey(spawnInfo.key)) {
            Minecraft minecraft = Minecraft.func_71410_x();
            boolean advancedKeyDown = minecraft.field_71462_r.func_146272_n();
            if (!advancedKeyDown) {
                tooltip.add("Hold" + TextFormatting.BLUE + " Shift " + TextFormatting.GRAY + "for advanced information.");
            } else {
                RestrictionBundle restrictionBundle = ModRegistry.spawnRestrictions.get(spawnInfo.key);
                restrictionBundle.addToolTipInfo(tooltip, spawnInfo.key);
            }
        }
    }

    public SpawnInfo getSpawnInfoFromItemStack(ItemStack stack) {
        NBTTagCompound tagCompound = this.getNBTShareTag(stack);
        String spawn_info = tagCompound.func_74779_i("spawn_info");
        if (spawn_info == null || spawn_info.isEmpty()) {
            spawn_info = ((ItemTotemOfSpawning)stack.func_77973_b()).key;
        }
        return this.getSpawnInfoFromKey(spawn_info);
    }

    public SpawnInfo getSpawnInfoFromKey(String key) {
        if (ModRegistry.SpawnInfosAndItems.containsKey(key)) {
            Tuple<SpawnInfo, ItemTotemOfSpawning> tuple = ModRegistry.SpawnInfosAndItems.get(key);
            return (SpawnInfo)tuple.func_76341_a();
        }
        return null;
    }
}

