/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.from_the_depths.events;

import com.wuest.from_the_depths.FromTheDepths;
import com.wuest.from_the_depths.ModRegistry;
import com.wuest.from_the_depths.blocks.BlockAltarOfSpawning;
import com.wuest.from_the_depths.config.ModConfiguration;
import com.wuest.from_the_depths.entityinfo.DropInfo;
import com.wuest.from_the_depths.proxy.ClientProxy;
import com.wuest.from_the_depths.proxy.CommonProxy;
import com.wuest.from_the_depths.proxy.messages.ConfigSyncMessage;
import com.wuest.from_the_depths.tileentity.TileEntityAltarOfSpawning;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(value={Side.SERVER, Side.CLIENT})
public class ModEventHandler {
    @SubscribeEvent
    public static void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            NBTTagCompound tag = CommonProxy.proxyConfiguration.ToNBTTagCompound();
            FromTheDepths.network.sendTo((IMessage)new ConfigSyncMessage(tag), (EntityPlayerMP)event.player);
            System.out.println("Sent config to '" + event.player.getDisplayNameString() + ".'");
            BlockAltarOfSpawning.SetBreakableStatus();
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            ((ClientProxy)FromTheDepths.proxy).serverConfiguration = null;
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent onConfigChangedEvent) {
        if (onConfigChangedEvent.getModID().equals("from_the_depths")) {
            ModConfiguration.syncConfig();
        }
    }

    @SubscribeEvent
    public static void EntityDied(LivingDropsEvent event) {
        NBTTagList additionalDropList;
        NBTTagCompound trackingTag;
        EntityLivingBase entity;
        NBTTagCompound entityCompoundTag;
        if (!event.getEntity().field_70170_p.field_72995_K && (entityCompoundTag = (entity = event.getEntityLiving()).getEntityData()).func_74764_b("from_the_depths") && (trackingTag = entityCompoundTag.func_74775_l("from_the_depths")).func_74764_b("additionalDrops") && !(additionalDropList = trackingTag.func_150295_c("additionalDrops", 10)).func_82582_d()) {
            for (int i = 0; i < additionalDropList.func_74745_c(); ++i) {
                NBTTagCompound dropInfoTag = additionalDropList.func_150305_b(i);
                DropInfo dropInfo = new DropInfo();
                dropInfo.loadFromNBTData(dropInfoTag);
                EntityItem droppedItem = dropInfo.createEntityItem(entity.func_130014_f_(), entity.func_180425_c());
                if (droppedItem == null) continue;
                event.getDrops().add(droppedItem);
            }
        }
    }

    @SubscribeEvent
    public static void bossLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase bossEntity = event.getEntityLiving();
        NBTTagCompound data = bossEntity.getEntityData();
        if (!data.func_74764_b("from_the_depths") || !data.func_74775_l("from_the_depths").func_74764_b("timeUntilDespawn")) {
            return;
        }
        NBTTagCompound fromTheCompound = data.func_74775_l("from_the_depths");
        if (bossEntity.field_70173_aa % 20 == 0 && bossEntity instanceof EntityLiving) {
            EntityLivingBase targetEntity = ((EntityLiving)bossEntity).func_70638_az();
            FromTheDepths.logger.info("Target: {}", (Object)(targetEntity == null ? "null" : targetEntity.func_145748_c_().func_150254_d()));
            if (targetEntity == null) {
                if (!fromTheCompound.func_74764_b("idleTimeStart")) {
                    fromTheCompound.func_74772_a("idleTimeStart", event.getEntity().field_70170_p.func_82737_E());
                }
            } else {
                fromTheCompound.func_82580_o("idleTimeStart");
            }
            World world = bossEntity.field_70170_p;
            int idleTimeUntilDespawn = fromTheCompound.func_74762_e("timeUntilDespawn");
            long idleTimeStart = fromTheCompound.func_74763_f("idleTimeStart");
            BlockPos pos = BlockPos.func_177969_a((long)fromTheCompound.func_74763_f("tilePos"));
            TileEntityAltarOfSpawning altar = (TileEntityAltarOfSpawning)world.func_175625_s(pos);
            if (idleTimeStart != 0L && idleTimeStart + (long)idleTimeUntilDespawn * 20L <= world.func_82737_E()) {
                if (altar != null) {
                    altar.resetSpawner();
                }
                world.func_175661_b(EntityPlayerMP.class, EntitySelectors.func_188443_a((double)bossEntity.field_70165_t, (double)bossEntity.field_70163_u, (double)bossEntity.field_70161_v, (double)25.0)).forEach(player -> player.func_145747_a((ITextComponent)new TextComponentString("The boss has de-spawned after being idle for " + idleTimeUntilDespawn + " seconds.")));
                world.func_184133_a(null, bossEntity.func_180425_c(), SoundEvents.field_187619_bk, SoundCategory.HOSTILE, 1.0f, 1.0f);
                bossEntity.func_70106_y();
                if (!world.field_72995_K) {
                    WorldServer sWorld = (WorldServer)world;
                    sWorld.func_175739_a(EnumParticleTypes.CRIT_MAGIC, bossEntity.field_70165_t, bossEntity.field_70163_u + 0.5, bossEntity.field_70161_v, 20, Math.random(), Math.random(), Math.random(), Math.random() * 0.1 - 0.05, new int[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModRegistry.ModBlocks.toArray(new Block[ModRegistry.ModBlocks.size()]));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModRegistry.ModItems.toArray(new Item[ModRegistry.ModItems.size()]));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModRegistry.RegisterOreDictionaryRecords();
    }
}

