/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.from_the_depths.events;

import com.wuest.from_the_depths.FromTheDepths;
import com.wuest.from_the_depths.ModRegistry;
import com.wuest.from_the_depths.items.ItemTotemOfSpawning;
import com.wuest.from_the_depths.proxy.ClientProxy;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent
    public static void OnClientDisconnectEvent(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        ((ClientProxy)FromTheDepths.proxy).serverConfiguration = null;
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Block block : ModRegistry.ModBlocks) {
            ClientEventHandler.regBlock(block);
        }
        for (Item item : ModRegistry.ModItems) {
            ClientEventHandler.regItem(item);
        }
    }

    public static void regItem(Item item) {
        if (item instanceof ItemTotemOfSpawning) {
            ItemTotemOfSpawning totem = (ItemTotemOfSpawning)item;
            if (totem.key != null && FromTheDepths.proxy.modDirectory.resolve("textures" + File.separatorChar + totem.key + ".png").toFile().exists()) {
                FromTheDepths.logger.info("Boss with name: " + totem.key + " got custom texture");
                ClientEventHandler.regItem(item, 0, "from_the_depths_totem:" + totem.key);
            } else {
                FromTheDepths.logger.info("Boss with name: " + totem.key + " got default texture");
                ClientEventHandler.regItem(item, 0, "from_the_depths:item_totem_of_summoning");
            }
        }
    }

    public static void regItem(Item item, int metaData, String blockName) {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation(blockName), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metaData, (ModelResourceLocation)location);
    }

    public static void regBlock(Block block) {
        NonNullList stacks = NonNullList.func_191196_a();
        Item itemBlock = Item.func_150898_a((Block)block);
        block.func_149666_a(CreativeTabs.field_78026_f, stacks);
        if (stacks.size() > 0) {
            for (ItemStack stack : stacks) {
                Block subBlock = block.func_176203_a(stack.func_77960_j()).func_177230_c();
                String name = subBlock.getRegistryName().toString();
                ClientEventHandler.regItem(stack.func_77973_b(), stack.func_77960_j(), name);
            }
        } else {
            ClientEventHandler.regItem(itemBlock);
        }
    }
}

