/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.from_the_depths.entityinfo.restrictions;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class SereneSeasonHelper {
    public static final BooleanSupplier isSereneSeasonLoaded = () -> Loader.isModLoaded((String)"sereneseasons");
    private static final BiPredicate<Pair<Season, Season.SubSeason>, World> SEASON_SPAWN_RESTRICTION = (season, world) -> {
        ISeasonState worldSeason = SeasonHelper.getSeasonState((World)world);
        if (season.getRight() == null) {
            return worldSeason.getSeason() == season.getLeft();
        }
        return worldSeason.getSeason() == season.getLeft() && worldSeason.getSubSeason() == season.getRight();
    };
    public static Map<String, Pair<Season, Season.SubSeason>> seasonRestrictions = new HashMap<String, Pair<Season, Season.SubSeason>>();

    private static Pair<Season, Season.SubSeason> seasonFromStrings(String seasonStr, String subSeasonStr) throws IllegalArgumentException {
        Season season = Season.valueOf((String)seasonStr);
        Season.SubSeason subSeason = null;
        if (!subSeasonStr.equals("")) {
            subSeason = Season.SubSeason.valueOf((String)(subSeasonStr + '_' + seasonStr));
        }
        return Pair.of((Object)season, subSeason);
    }

    public static void addSeasonRestriction(String spawnKey, JsonObject seasonObj) throws JsonSyntaxException {
        String sString = JsonUtils.func_151200_h((JsonObject)seasonObj, (String)"season");
        String sSString = JsonUtils.func_151219_a((JsonObject)seasonObj, (String)"subSeason", (String)"");
        Pair<Season, Season.SubSeason> seasons = SereneSeasonHelper.seasonFromStrings(sString.toUpperCase(), sSString.toUpperCase());
        seasonRestrictions.put(spawnKey, seasons);
    }

    public static Pair<Boolean, String> testSeasonRestrictions(String spawnKey, World world) {
        if (!isSereneSeasonLoaded.getAsBoolean()) {
            return Pair.of((Object)true, null);
        }
        Pair<Season, Season.SubSeason> seasonPair = seasonRestrictions.get(spawnKey);
        if (seasonPair == null) {
            return Pair.of((Object)true, null);
        }
        String correctSeason = seasonPair.getRight() != null ? ((Season.SubSeason)seasonPair.getRight()).toString().replace('_', ' ').toLowerCase() : ((Season)seasonPair.getLeft()).toString().toLowerCase();
        boolean result = SEASON_SPAWN_RESTRICTION.test(seasonRestrictions.get(spawnKey), world);
        return Pair.of((Object)result, (Object)correctSeason);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addSeasonRestrictionToToolTip(List<String> toolTip, String spawnKey) {
        if (seasonRestrictions.containsKey(spawnKey)) {
            Pair<Season, Season.SubSeason> seasonPair = seasonRestrictions.get(spawnKey);
            String correctSeason = seasonPair.getRight() != null ? ((Season.SubSeason)seasonPair.getRight()).toString().replace('_', ' ').toLowerCase() : ((Season)seasonPair.getLeft()).toString().toLowerCase();
            toolTip.add(TextFormatting.BLUE + "Required Season" + TextFormatting.WHITE + ": " + correctSeason);
        }
    }
}

