/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.from_the_depths.entityinfo.restrictions;

import com.google.gson.annotations.SerializedName;
import com.wuest.from_the_depths.base.Weather;
import com.wuest.from_the_depths.entityinfo.restrictions.DataAndComparator;
import com.wuest.from_the_depths.entityinfo.restrictions.SereneSeasonHelper;
import com.wuest.from_the_depths.entityinfo.restrictions.SpawnRestrictions;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class RestrictionBundle {
    @SerializedName(value="dimensions", alternate={"Dimensions"})
    private Integer[] dimensions = null;
    @SerializedName(value="timeOfDay", alternate={"TimeOfDay", "Timeofday", "TimeofDay", "time_of_day", "Time_Of_Day", "Time_of_Day", "Time_of_day"})
    private DataAndComparator<Long> timeOfDay = null;
    @SerializedName(value="weather", alternate={"Weather"})
    private Weather weather = null;
    @SerializedName(value="biomes", alternate={"Biomes"})
    private ResourceLocation[] biomes = null;
    @SerializedName(value="yLevel", alternate={"ylevel", "YLevel", "y_level"})
    private DataAndComparator<Integer> yLevel = null;
    private int groundRadius = 0;

    public Pair<Boolean, TextComponentTranslation> testAll(String spawnKey, World world, BlockPos pos) {
        boolean canStart = true;
        TextComponentTranslation message = null;
        if (this.dimensions != null && !(canStart = SpawnRestrictions.DIMENSION.test(world, this.dimensions))) {
            message = new TextComponentTranslation("from_the_depths.restrictions.dimension", new Object[0]);
        }
        if (canStart && this.timeOfDay != null && !(canStart = SpawnRestrictions.TIME_OF_DAY.test(world, this.timeOfDay))) {
            message = new TextComponentTranslation("from_the_depths.restrictions.time_of_day", new Object[0]);
        }
        if (canStart && this.weather != null && !(canStart = SpawnRestrictions.WEATHER.test(world, this.weather))) {
            message = new TextComponentTranslation("from_the_depths.restrictions.weather", new Object[]{this.weather.name().toLowerCase()});
        }
        if (canStart && this.biomes != null && !(canStart = SpawnRestrictions.BIOME.test((Tuple<BlockPos, World>)new Tuple((Object)pos, (Object)world), this.biomes))) {
            String biomesString = Arrays.stream(this.biomes).map(resLoc -> resLoc.func_110623_a().replace("_", "")).reduce("", (s, s2) -> s + ", " + s2);
            message = new TextComponentTranslation("from_the_depths.restrictions.biomes", new Object[]{biomesString});
        }
        if (canStart && this.yLevel != null && !(canStart = SpawnRestrictions.Y_LEVEL.test(pos, this.yLevel))) {
            String key = "from_the_depths.restrictions.y_level_";
            key = this.yLevel.operator == DataAndComparator.Operator.MORE ? key + "higher" : (this.yLevel.operator == DataAndComparator.Operator.LESS ? key + "lower" : key + "equals");
            message = new TextComponentTranslation(key, new Object[]{this.yLevel.data});
        }
        if (canStart && this.groundRadius != 0 && !(canStart = SpawnRestrictions.GROUND_RADIUS.test((Tuple<BlockPos, World>)new Tuple((Object)pos, (Object)world), this.groundRadius))) {
            message = new TextComponentTranslation("from_the_depths.restrictions.ground_radius", new Object[]{this.groundRadius});
        }
        if (canStart) {
            Pair<Boolean, String> resultAndCorrectSeason = SereneSeasonHelper.testSeasonRestrictions(spawnKey, world);
            canStart = (Boolean)resultAndCorrectSeason.getLeft();
            String correctSeason = (String)resultAndCorrectSeason.getRight();
            if (!canStart) {
                message = new TextComponentTranslation("from_the_depths.restrictions.season", new Object[]{correctSeason});
            }
        }
        return Pair.of((Object)canStart, (Object)message);
    }

    @SideOnly(value=Side.CLIENT)
    public void addToolTipInfo(List<String> toolTip, String spawnKey) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (this.dimensions != null) {
            StringBuilder dimensionMessage = new StringBuilder(TextFormatting.BLUE + "Dimensions" + TextFormatting.WHITE + ": ");
            boolean addedOtherDimensions = false;
            Integer[] integerArray = this.dimensions;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = integerArray[i];
                if (!DimensionManager.isDimensionRegistered((int)n2)) continue;
                if (addedOtherDimensions) {
                    dimensionMessage.append(", ");
                }
                DimensionType dimensionType = DimensionManager.getProviderType((int)n2);
                dimensionMessage.append(I18n.func_135052_a((String)dimensionType.func_186065_b(), (Object[])new Object[0]));
                addedOtherDimensions = true;
            }
            toolTip.add(dimensionMessage.toString());
        }
        if (this.timeOfDay != null) {
            StringBuilder timeOfDayMessage = new StringBuilder(TextFormatting.BLUE + "Time of Day").append(TextFormatting.WHITE).append(": ");
            switch (this.timeOfDay.operator) {
                case EQUALS: {
                    timeOfDayMessage.append("At: ");
                    break;
                }
                case LESS: {
                    timeOfDayMessage.append("Before: ");
                    break;
                }
                case MORE: {
                    timeOfDayMessage.append("After: ");
                }
            }
            timeOfDayMessage.append(this.timeOfDay.data);
            toolTip.add(timeOfDayMessage.toString());
        }
        if (this.weather != null) {
            String weatherMessage = TextFormatting.BLUE + "Weather" + TextFormatting.WHITE + ": " + this.weather.getName();
            toolTip.add(weatherMessage);
        }
        if (this.biomes != null) {
            StringBuilder biomeMessage = new StringBuilder(TextFormatting.BLUE + "Biomes" + TextFormatting.WHITE + ": ");
            boolean addedOtherBiome = false;
            for (Integer n : this.biomes) {
                if (!ForgeRegistries.BIOMES.containsKey((ResourceLocation)n)) continue;
                if (addedOtherBiome) {
                    biomeMessage.append(", ");
                }
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue((ResourceLocation)n);
                biomeMessage.append(I18n.func_135052_a((String)biome.func_185359_l(), (Object[])new Object[0]));
                addedOtherBiome = true;
            }
            toolTip.add(biomeMessage.toString());
        }
        if (this.yLevel != null) {
            StringBuilder levelMessage = new StringBuilder(TextFormatting.BLUE + "Y-Level").append(TextFormatting.WHITE).append(": ");
            switch (this.yLevel.operator) {
                case EQUALS: {
                    levelMessage.append("At: ");
                    break;
                }
                case LESS: {
                    levelMessage.append("Below: ");
                    break;
                }
                case MORE: {
                    levelMessage.append("Above: ");
                }
            }
            levelMessage.append(this.yLevel.data);
            toolTip.add(levelMessage.toString());
        }
        if (this.groundRadius != 0) {
            StringBuilder radiusMessage = new StringBuilder(TextFormatting.BLUE.toString()).append("Solid Ground Around Altar").append(TextFormatting.WHITE).append(": ").append(this.groundRadius);
            toolTip.add(radiusMessage.toString());
        }
        if (SereneSeasonHelper.isSereneSeasonLoaded.getAsBoolean()) {
            SereneSeasonHelper.addSeasonRestrictionToToolTip(toolTip, spawnKey);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RestrictionBundle: ");
        if (this.dimensions != null) {
            builder.append("dimensions=").append(Arrays.toString((Object[])this.dimensions));
        }
        if (this.timeOfDay != null) {
            builder.append("| timeOfDay=").append(this.timeOfDay);
        }
        if (this.weather != null) {
            builder.append("| weather=").append((Object)this.weather);
        }
        if (this.biomes != null) {
            builder.append("| biomes=").append(Arrays.toString(this.biomes));
        }
        if (this.yLevel != null) {
            builder.append("| yLevel=").append(this.yLevel);
        }
        if (this.groundRadius != 0) {
            builder.append("| groundRadius=").append(this.groundRadius);
        }
        return builder.toString();
    }
}

