/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.from_the_depths.entityinfo;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.wuest.from_the_depths.FromTheDepths;
import com.wuest.from_the_depths.entityinfo.BaseMonster;
import com.wuest.from_the_depths.entityinfo.INBTSerializable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DropInfo
implements INBTSerializable<DropInfo> {
    public String item = "";
    public int minDrops = 0;
    public int maxDrops = 0;
    public int dropChance = 5;
    public int data = 0;
    public JsonObject nbt = null;

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("item", this.item);
        tag.func_74768_a("minDrops", this.minDrops);
        tag.func_74768_a("maxDrops", this.maxDrops);
        tag.func_74768_a("dropChance", this.dropChance);
        tag.func_74768_a("data", this.data);
        if (this.nbt != null) {
            tag.func_74778_a("nbt", this.nbt.toString());
        }
    }

    @Override
    public DropInfo loadFromNBTData(NBTTagCompound nbtData) {
        this.item = nbtData.func_74779_i("item");
        this.minDrops = nbtData.func_74762_e("minDrops");
        this.maxDrops = nbtData.func_74762_e("maxDrops");
        this.dropChance = nbtData.func_74762_e("dropChance");
        this.data = nbtData.func_74762_e("data");
        if (nbtData.func_74764_b("nbt")) {
            JsonParser parser = new JsonParser();
            this.nbt = (JsonObject)parser.parse(nbtData.func_74779_i("nbt"));
        }
        if (this.minDrops < 0) {
            this.minDrops = 0;
            FromTheDepths.logger.warn("Minimum Drops value is less than zero; please check your files. Setting to zero.");
        }
        if (this.maxDrops < 0) {
            this.maxDrops = 0;
            FromTheDepths.logger.warn("Maximum Drops value is less than zero; please check your files. Setting to zero.");
        }
        if (this.maxDrops < this.minDrops) {
            this.maxDrops = this.minDrops;
            FromTheDepths.logger.warn("Maximum Drops value is less than minimum drops; please check your files. Setting to minimum drops.");
        }
        if (this.dropChance < 0) {
            this.dropChance = 5;
            FromTheDepths.logger.warn("The drop chance is less than zero; please check yoru files. Setting to five.");
        }
        if (this.data < 0) {
            this.data = 0;
        }
        return this;
    }

    public DropInfo clone() {
        DropInfo newInstance = new DropInfo();
        newInstance.item = this.item;
        newInstance.minDrops = this.minDrops;
        newInstance.maxDrops = this.maxDrops;
        newInstance.dropChance = this.dropChance;
        newInstance.data = this.data;
        newInstance.nbt = this.nbt;
        return newInstance;
    }

    public EntityItem createEntityItem(World world, BlockPos pos) {
        block10: {
            ResourceLocation itemLocation = new ResourceLocation(this.item);
            int randomValue = BaseMonster.determineRandomInt(100, world);
            if (randomValue <= this.dropChance && this.maxDrops > 0) {
                int amountToDrop;
                if (this.minDrops == this.maxDrops) {
                    amountToDrop = this.maxDrops;
                } else {
                    amountToDrop = BaseMonster.determineRandomInt(this.maxDrops, world);
                    if (amountToDrop <= this.minDrops) {
                        amountToDrop = this.minDrops;
                    }
                }
                try {
                    Item registryItem = (Item)Item.field_150901_e.func_82594_a((Object)itemLocation);
                    if (registryItem == null) break block10;
                    ItemStack stack = new ItemStack(registryItem, amountToDrop, this.data);
                    if (this.nbt != null) {
                        NBTTagCompound compound = null;
                        try {
                            compound = JsonToNBT.func_180713_a((String)this.nbt.toString());
                        }
                        catch (NBTException exception) {
                            FromTheDepths.logger.error((Object)exception);
                        }
                        if (compound != null && !compound.func_82582_d()) {
                            stack.func_77982_d(compound);
                        }
                    }
                    return new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                }
                catch (Exception ex) {
                    FromTheDepths.logger.warn(String.format("An item with registration name [{}] wasn't found. Make sure the domain and item name are spelled correctly. Monster drops not created.", this.item));
                }
            }
        }
        return null;
    }
}

