/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.from_the_depths.entityinfo;

import com.wuest.from_the_depths.FromTheDepths;
import com.wuest.from_the_depths.entityinfo.BaseMonster;
import com.wuest.from_the_depths.entityinfo.DropInfo;
import com.wuest.from_the_depths.entityinfo.INBTSerializable;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BossAddInfo
extends BaseMonster
implements INBTSerializable<BossAddInfo> {
    public int minSpawns = 0;
    public int maxSpawns = 0;
    public int timeBetweenSpawns = 20;
    public boolean spawnBeforeBoss = false;
    public BossAddInfo nextWaveOfAdds = null;
    public boolean spawning = false;
    public int numberLeftToSpawn = 0;
    public int timeUntilNextSpawn = 0;

    public boolean hasAdditionalWaves() {
        return this.nextWaveOfAdds != null;
    }

    public void determineNumberToSpawn(World world) {
        this.timeUntilNextSpawn = this.timeToWaitBeforeSpawn;
        if (this.minSpawns != this.maxSpawns) {
            this.numberLeftToSpawn = BossAddInfo.determineRandomInt(this.maxSpawns, world);
            if (this.numberLeftToSpawn < this.minSpawns) {
                this.numberLeftToSpawn = this.minSpawns;
            }
        } else {
            this.numberLeftToSpawn = this.maxSpawns;
        }
        if (this.nextWaveOfAdds != null) {
            this.nextWaveOfAdds.determineNumberToSpawn(world);
        }
    }

    public boolean processMinionSpawning(World world, BlockPos pos, ICommandSender commandSender, List<UUID> entities) {
        this.spawning = true;
        if (this.numberLeftToSpawn == 0 && this.nextWaveOfAdds != null) {
            return this.nextWaveOfAdds.processMinionSpawning(world, pos, commandSender, entities);
        }
        if (this.numberLeftToSpawn == 0) {
            return true;
        }
        if (this.timeUntilNextSpawn <= 0) {
            Entity entity = this.createEntityForWorld(world, pos.func_177984_a(), null, commandSender);
            entities.add(entity.func_110124_au());
            --this.numberLeftToSpawn;
            this.timeUntilNextSpawn = this.timeBetweenSpawns;
            return this.numberLeftToSpawn == 0 && this.nextWaveOfAdds == null;
        }
        --this.timeUntilNextSpawn;
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("minSpawns", this.minSpawns);
        tag.func_74768_a("maxSpawns", this.maxSpawns);
        tag.func_74768_a("timeBetweenSpawns", this.timeBetweenSpawns);
        tag.func_74757_a("spawnBeforeBoss", this.spawnBeforeBoss);
        tag.func_74757_a("spawning", this.spawning);
        tag.func_74768_a("numberLeftToSpawn", this.numberLeftToSpawn);
        tag.func_74768_a("timeUntilNextSpawn", this.timeUntilNextSpawn);
        if (this.nextWaveOfAdds != null) {
            NBTTagCompound nextWaveTag = new NBTTagCompound();
            this.nextWaveOfAdds.writeToNBT(nextWaveTag);
            tag.func_74782_a("nextWaveOfAdds", (NBTBase)nextWaveTag);
        }
    }

    @Override
    public BossAddInfo loadFromNBTData(NBTTagCompound tag) {
        super.loadFromNBT(tag);
        this.minSpawns = tag.func_74762_e("minSpawns");
        this.maxSpawns = tag.func_74762_e("maxSpawns");
        this.timeBetweenSpawns = tag.func_74762_e("timeBetweenSpawns");
        this.spawnBeforeBoss = tag.func_74767_n("spawnBeforeBoss");
        this.spawning = tag.func_74767_n("spawning");
        this.numberLeftToSpawn = tag.func_74762_e("numberLeftToSpawn");
        this.timeUntilNextSpawn = tag.func_74762_e("timeUntilNextSpawn");
        if (this.minSpawns < 0) {
            FromTheDepths.logger.warn(String.format("The minimum number of spawns ({}) for monster {} is not valid, setting to default of zero", this.minSpawns, this.name));
        }
        if (this.maxSpawns < 0 || this.maxSpawns < this.minSpawns) {
            FromTheDepths.logger.warn(String.format("The maximum number of spawns ({}) for monster {} is not valid, setting to minimum number of spawns ({}", this.maxSpawns, this.maxHealth, this.minSpawns));
        }
        if (this.timeBetweenSpawns < 0) {
            FromTheDepths.logger.warn(String.format("The time between spawns ({}) for monster {} is not valid, setting to default of 100 ticks", this.timeBetweenSpawns, this.name));
            this.timeBetweenSpawns = 100;
        }
        if (tag.func_74764_b("nextWaveOfAdds")) {
            NBTTagCompound nextWaveTag = tag.func_74775_l("nextWaveOfAdds");
            BossAddInfo nextWaveAddInfo = new BossAddInfo();
            this.nextWaveOfAdds = nextWaveAddInfo.loadFromNBTData(nextWaveTag);
        }
        return this;
    }

    public BossAddInfo clone() {
        BossAddInfo newInstance = new BossAddInfo();
        newInstance.alwaysShowDisplayName = this.alwaysShowDisplayName;
        newInstance.attackDamage = this.attackDamage;
        newInstance.displayName = this.displayName;
        newInstance.domain = this.domain;
        newInstance.maxHealth = this.maxHealth;
        newInstance.name = this.name;
        newInstance.minSpawns = this.minSpawns;
        newInstance.maxSpawns = this.maxSpawns;
        newInstance.timeBetweenSpawns = this.timeBetweenSpawns;
        newInstance.spawnBeforeBoss = this.spawnBeforeBoss;
        newInstance.timeToWaitBeforeSpawn = this.timeToWaitBeforeSpawn;
        newInstance.spawning = this.spawning;
        newInstance.numberLeftToSpawn = this.numberLeftToSpawn;
        newInstance.timeUntilNextSpawn = this.timeUntilNextSpawn;
        newInstance.commandToRunAtSpawn = this.commandToRunAtSpawn;
        newInstance.nbt = this.nbt;
        newInstance.spawnEffect = this.spawnEffect;
        newInstance.shouldSpawnInAir = this.shouldSpawnInAir;
        if (this.nextWaveOfAdds != null) {
            newInstance.nextWaveOfAdds = this.nextWaveOfAdds.clone();
        }
        for (DropInfo info : this.additionalDrops) {
            newInstance.additionalDrops.add(info.clone());
        }
        return newInstance;
    }
}

