/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.from_the_depths.config;

import com.wuest.from_the_depths.FromTheDepths;
import com.wuest.from_the_depths.proxy.CommonProxy;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;

public class ModConfiguration {
    public static String OPTIONS = "general.options";
    public static String RecipeOptions = "general.options.recipes";
    public static String tagKey = "FromTheDepthsConfig";
    private static String allowAltarToBeDestroyedName = "Allow Altar to be Destroyed";
    private static String altarSpawningRadiusName = "Altar Spawning Radius";
    private static String altarSpawningHeightName = "Altar Spawning Height";
    private static String showAltarSpawningTextName = "Show Altar Spawning Text";
    private static String enableArenaStyleRestrictionsName = "Enable Arena Style Restrictions";
    private static String canSpawnMultipleBossesName = "Allow Spawning of multiple bosses";
    public boolean allowAltarToBeDestroyed;
    public int altarSpawningRadius;
    public int altarSpawningHeight;
    public boolean showAltarSpawningText;
    public boolean enableArenaStyleRestrictions;
    public boolean canSpawnMultipleBosses;
    public HashMap<String, Boolean> recipeConfiguration = new HashMap();
    public static String arenaStructureKey = "Arena";
    public static String[] recipeKeys = new String[]{arenaStructureKey};

    public static void syncConfig() {
        Configuration config = FromTheDepths.config;
        if (CommonProxy.proxyConfiguration == null) {
            CommonProxy.proxyConfiguration = new ModConfiguration();
        }
        CommonProxy.proxyConfiguration.allowAltarToBeDestroyed = config.getBoolean(allowAltarToBeDestroyedName, OPTIONS, false, "Determines if the Altar can be destroyed. server configuration overrides client.");
        CommonProxy.proxyConfiguration.altarSpawningRadius = config.getInt(altarSpawningRadiusName, OPTIONS, 6, 6, 32, "The number of blocks around an altar of spawning where monsters can spawn. server configuration overrides client.");
        CommonProxy.proxyConfiguration.altarSpawningHeight = config.getInt(altarSpawningHeightName, OPTIONS, 6, 6, 16, "The number of blocks above an altar of spawning where flying monsters can spawn. server configuration overrides client.");
        CommonProxy.proxyConfiguration.showAltarSpawningText = config.getBoolean(showAltarSpawningTextName, OPTIONS, true, "Determines if text is shown above the altar of spawning when the altar is processing a totem. server configuration overrides client.");
        CommonProxy.proxyConfiguration.enableArenaStyleRestrictions = config.getBoolean(enableArenaStyleRestrictionsName, OPTIONS, true, "Determines if the area around the altar needs to be solid and flat. server configuration overrides client.");
        CommonProxy.proxyConfiguration.canSpawnMultipleBosses = config.getBoolean(canSpawnMultipleBossesName, OPTIONS, true, "Specifies whether a player can summon multiple bosses at the same time");
        for (String key : recipeKeys) {
            boolean value = config.getBoolean(key, RecipeOptions, true, "Determines if the recipe(s) associated with the " + key + " are enabled.");
            CommonProxy.proxyConfiguration.recipeConfiguration.put(key, value);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public NBTTagCompound ToNBTTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a(allowAltarToBeDestroyedName, this.allowAltarToBeDestroyed);
        tag.func_74768_a(altarSpawningRadiusName, this.altarSpawningRadius);
        tag.func_74768_a(altarSpawningHeightName, this.altarSpawningHeight);
        tag.func_74757_a(showAltarSpawningTextName, this.showAltarSpawningText);
        tag.func_74757_a(canSpawnMultipleBossesName, this.canSpawnMultipleBosses);
        for (Map.Entry<String, Boolean> entry : this.recipeConfiguration.entrySet()) {
            tag.func_74757_a(entry.getKey(), entry.getValue().booleanValue());
        }
        return tag;
    }

    public static ModConfiguration getFromNBTTagCompound(NBTTagCompound tag) {
        ModConfiguration config = new ModConfiguration();
        config.allowAltarToBeDestroyed = tag.func_74767_n(allowAltarToBeDestroyedName);
        config.altarSpawningHeight = tag.func_74762_e(altarSpawningHeightName);
        config.altarSpawningRadius = tag.func_74762_e(altarSpawningRadiusName);
        config.showAltarSpawningText = tag.func_74767_n(showAltarSpawningTextName);
        config.canSpawnMultipleBosses = tag.func_74767_n(canSpawnMultipleBossesName);
        for (String key : recipeKeys) {
            config.recipeConfiguration.put(key, tag.func_74767_n(key));
        }
        return config;
    }
}

