/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.from_the_depths.config;

import com.google.common.base.Strings;
import com.wuest.from_the_depths.base.BaseConfig;
import com.wuest.from_the_depths.entityinfo.BossAddInfo;
import com.wuest.from_the_depths.entityinfo.SpawnInfo;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;

public class ConfigTileEntityAltarOfSpawning
extends BaseConfig {
    public BlockPos pos;
    public SpawnInfo currentSpawnInfo;
    public boolean bossSpawned;
    public int totalLightningBolts;
    public int ticksUntilNextLightningBolt;
    public ArrayList<BossAddInfo> preBossMinions;
    public ArrayList<UUID> aliveMonsterIds;
    public boolean idle;

    public ConfigTileEntityAltarOfSpawning() {
        this.Initialize();
    }

    @Override
    public void writeToNBTCompound(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.pos));
        if (this.currentSpawnInfo != null && this.currentSpawnInfo.bossInfo != null && !Strings.isNullOrEmpty((String)this.currentSpawnInfo.key)) {
            NBTTagCompound spawnInfo = new NBTTagCompound();
            this.currentSpawnInfo.writeToNBT(spawnInfo);
            tag.func_74782_a("spawnInfo", (NBTBase)spawnInfo);
            tag.func_74757_a("bossSpawned", this.bossSpawned);
            tag.func_74768_a("totalLightningBolts", this.totalLightningBolts);
            tag.func_74768_a("ticksUntilNextLightningBolt", this.ticksUntilNextLightningBolt);
            NBTTagList tagList = new NBTTagList();
            if (!this.preBossMinions.isEmpty()) {
                for (BossAddInfo bossAddInfo : this.preBossMinions) {
                    NBTTagCompound addTagCompound = new NBTTagCompound();
                    bossAddInfo.writeToNBT(addTagCompound);
                    tagList.func_74742_a((NBTBase)addTagCompound);
                }
            }
            tag.func_74782_a("preBossMinions", (NBTBase)tagList);
            NBTTagList idList = new NBTTagList();
            this.aliveMonsterIds.forEach(uuid -> idList.func_74742_a((NBTBase)NBTUtil.func_186862_a((UUID)uuid)));
            tag.func_74782_a("aliveMonsterIds", (NBTBase)idList);
            tag.func_74757_a("idle", this.idle);
        }
        compound.func_74782_a("configTag", (NBTBase)tag);
    }

    public ConfigTileEntityAltarOfSpawning readFromNBTTagCompound(NBTTagCompound compound) {
        ConfigTileEntityAltarOfSpawning config = new ConfigTileEntityAltarOfSpawning();
        if (compound.func_74764_b("configTag")) {
            NBTTagCompound tag = compound.func_74775_l("configTag");
            config.pos = NBTUtil.func_186861_c((NBTTagCompound)tag.func_74775_l("pos"));
            if (tag.func_74764_b("spawnInfo")) {
                SpawnInfo spawnInfo = new SpawnInfo();
                config.currentSpawnInfo = spawnInfo.loadFromNBTData(tag.func_74775_l("spawnInfo"));
                if (Strings.isNullOrEmpty((String)config.currentSpawnInfo.key)) {
                    config.currentSpawnInfo = null;
                }
                config.bossSpawned = tag.func_74767_n("bossSpawned");
                config.totalLightningBolts = tag.func_74762_e("totalLightningBolts");
                config.ticksUntilNextLightningBolt = tag.func_74762_e("ticksUntilNextLightningBolt");
                NBTTagList preBossMinionTagList = tag.func_150295_c("preBossMinions", 10);
                if (!preBossMinionTagList.func_82582_d()) {
                    for (int i = 0; i < preBossMinionTagList.func_74745_c(); ++i) {
                        NBTTagCompound bossAddInfoCompound = preBossMinionTagList.func_150305_b(i);
                        BossAddInfo bossAddInfo = new BossAddInfo();
                        config.preBossMinions.add(bossAddInfo.loadFromNBTData(bossAddInfoCompound));
                    }
                }
            }
            NBTTagList aliveIdList = tag.func_150295_c("aliveMonsterIds", 10);
            for (int i = 0; i < aliveIdList.func_74745_c(); ++i) {
                UUID id = NBTUtil.func_186860_b((NBTTagCompound)aliveIdList.func_150305_b(i));
                config.aliveMonsterIds.add(id);
            }
            config.idle = tag.func_74767_n("idle");
        }
        return config;
    }

    public void Initialize() {
        this.pos = new BlockPos(0, 0, 0);
        this.preBossMinions = new ArrayList();
        this.currentSpawnInfo = null;
        this.aliveMonsterIds = new ArrayList();
    }
}

