/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.spawners;

import com.google.gson.JsonObject;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.worldgen.spawners.Spawner;
import java.util.Random;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SpawnPotential {
    String name;
    int weight;
    boolean equip;
    NBTTagCompound nbt;

    public SpawnPotential(String name) {
        this(name, 1);
    }

    public SpawnPotential(String name, int weight) {
        this(name, true, weight, null);
    }

    public SpawnPotential(String name, boolean equip, int weight) {
        this(name, equip, weight, null);
    }

    public SpawnPotential(String name, boolean equip, int weight, NBTTagCompound nbt) {
        this.name = name;
        this.equip = equip;
        this.weight = weight;
        this.nbt = nbt;
    }

    public SpawnPotential(JsonObject entry) throws Exception {
        int n = this.weight = entry.has("weight") ? entry.get("weight").getAsInt() : 1;
        if (!entry.has("name")) {
            throw new Exception("Spawn potential missing name");
        }
        this.name = entry.get("name").getAsString();
        boolean bl = this.equip = entry.has("equip") ? entry.get("equip").getAsBoolean() : false;
        if (entry.has("nbt")) {
            String metadata = entry.get("nbt").getAsString();
            this.nbt = JsonToNBT.func_180713_a((String)metadata);
        }
    }

    public NBTTagCompound get(int level) {
        NBTTagCompound nbt = this.nbt == null ? new NBTTagCompound() : this.nbt.func_74737_b();
        return this.getPotential(this.getRoguelike(level, this.name, nbt));
    }

    public NBTTagList get(Random rand, int level) {
        NBTTagList potentials = new NBTTagList();
        if (this.name.equals(Spawner.getName(Spawner.ZOMBIE))) {
            for (int i = 0; i < 24; ++i) {
                Equipment tool;
                NBTTagCompound mob = new NBTTagCompound();
                mob = this.getRoguelike(level, this.name, mob);
                switch (rand.nextInt(3)) {
                    case 0: {
                        tool = Equipment.SHOVEL;
                        break;
                    }
                    case 1: {
                        tool = Equipment.AXE;
                        break;
                    }
                    case 2: {
                        tool = Equipment.PICK;
                        break;
                    }
                    default: {
                        tool = Equipment.PICK;
                    }
                }
                mob = this.equipHands(mob, Equipment.getName(tool, Quality.getToolQuality(rand, level)), "minecraft:shield");
                mob = this.equipArmour(mob, rand, level);
                potentials.func_74742_a((NBTBase)this.getPotential(mob));
            }
            return potentials;
        }
        if (this.name.equals(Spawner.getName(Spawner.SKELETON))) {
            for (int i = 0; i < 12; ++i) {
                NBTTagCompound mob = new NBTTagCompound();
                mob = this.getRoguelike(level, this.name, mob);
                mob = this.equipHands(mob, "minecraft:bow", null);
                mob = this.equipArmour(mob, rand, level);
                potentials.func_74742_a((NBTBase)this.getPotential(mob));
            }
            return potentials;
        }
        potentials.func_74742_a((NBTBase)this.getPotential(this.getRoguelike(level, this.name, new NBTTagCompound())));
        return potentials;
    }

    private NBTTagCompound getPotential(NBTTagCompound mob) {
        NBTTagCompound potential = new NBTTagCompound();
        potential.func_74782_a("Entity", (NBTBase)mob);
        potential.func_74768_a("Weight", this.weight);
        return potential;
    }

    private NBTTagCompound equipHands(NBTTagCompound mob, String weapon, String offhand) {
        NBTTagList hands = new NBTTagList();
        hands.func_74742_a((NBTBase)this.getItem(weapon));
        hands.func_74742_a((NBTBase)this.getItem(offhand));
        mob.func_74782_a("HandItems", (NBTBase)hands);
        return mob;
    }

    private NBTTagCompound equipArmour(NBTTagCompound mob, Random rand, int level) {
        NBTTagList armour = new NBTTagList();
        armour.func_74742_a((NBTBase)this.getItem(Equipment.getName(Equipment.FEET, Quality.getArmourQuality(rand, level))));
        armour.func_74742_a((NBTBase)this.getItem(Equipment.getName(Equipment.LEGS, Quality.getArmourQuality(rand, level))));
        armour.func_74742_a((NBTBase)this.getItem(Equipment.getName(Equipment.CHEST, Quality.getArmourQuality(rand, level))));
        armour.func_74742_a((NBTBase)this.getItem(Equipment.getName(Equipment.HELMET, Quality.getArmourQuality(rand, level))));
        mob.func_74782_a("ArmorItems", (NBTBase)armour);
        return mob;
    }

    private NBTTagCompound getItem(String itemName) {
        NBTTagCompound item = new NBTTagCompound();
        if (itemName == null) {
            return item;
        }
        item.func_74778_a("id", itemName);
        item.func_74768_a("Count", 1);
        return item;
    }

    private NBTTagCompound getRoguelike(int level, String type, NBTTagCompound tag) {
        tag.func_74778_a("id", type);
        if (!RogueConfig.getBoolean(RogueConfig.ROGUESPAWNERS) || !this.equip) {
            return tag;
        }
        NBTTagList activeEffects = new NBTTagList();
        tag.func_74782_a("ActiveEffects", (NBTBase)activeEffects);
        NBTTagCompound buff = new NBTTagCompound();
        activeEffects.func_74742_a((NBTBase)buff);
        buff.func_74774_a("Id", (byte)4);
        buff.func_74774_a("Amplifier", (byte)level);
        buff.func_74768_a("Duration", 10);
        buff.func_74774_a("Ambient", (byte)0);
        return tag;
    }
}

