/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.worldgen.BlockCheckers;
import greymerk.roguelike.worldgen.BlockColumns;
import greymerk.roguelike.worldgen.BlockJumble;
import greymerk.roguelike.worldgen.BlockLayers;
import greymerk.roguelike.worldgen.BlockStripes;
import greymerk.roguelike.worldgen.BlockWeightedRandom;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;

public enum BlockProvider {
    METABLOCK,
    WEIGHTED,
    CHECKERS,
    JUMBLE,
    STRIPES,
    LAYERS,
    COLUMNS;


    public static IBlockFactory create(JsonObject block) throws Exception {
        BlockProvider type;
        if (block.has("type")) {
            String t = block.get("type").getAsString();
            type = BlockProvider.valueOf(t);
        } else {
            type = METABLOCK;
        }
        Object data = block.has("data") ? block.get("data") : block;
        switch (type) {
            case METABLOCK: {
                return new MetaBlock((JsonElement)data);
            }
            case WEIGHTED: {
                return new BlockWeightedRandom((JsonElement)data);
            }
            case CHECKERS: {
                return new BlockCheckers((JsonElement)data);
            }
            case JUMBLE: {
                return new BlockJumble((JsonElement)data);
            }
            case STRIPES: {
                return new BlockStripes((JsonElement)data);
            }
            case LAYERS: {
                return new BlockLayers((JsonElement)data);
            }
            case COLUMNS: {
                return new BlockColumns((JsonElement)data);
            }
        }
        return null;
    }
}

