/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.util.InventoryIterator;
import betterwithmods.util.StackEjector;
import betterwithmods.util.StackIngredient;
import betterwithmods.util.VectorBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomUtils;

public class InvUtils {
    public static StackEjector EJECT_OFFSET = new StackEjector(new VectorBuilder().rand(0.5).offset(0.25), new VectorBuilder().setGaussian(0.05f));
    public static StackEjector EJECT_EXACT = new StackEjector(new VectorBuilder(), new VectorBuilder());

    public static boolean containsIngredient(List<Ingredient> collection, List<Ingredient> ingredient) {
        return InvUtils.matchesPredicate(collection, ingredient, (a, b) -> {
            if (a.func_193365_a().length > 0) {
                return Arrays.stream(a.func_193365_a()).allMatch(arg_0 -> ((Ingredient)b).apply(arg_0));
            }
            return false;
        });
    }

    public static boolean isIngredientValid(Ingredient ingredient) {
        return !ArrayUtils.isEmpty((Object[])ingredient.func_193365_a());
    }

    public static boolean containsIngredient(ItemStackHandler handler, Ingredient ingredient) {
        return InventoryIterator.stream(handler).anyMatch(arg_0 -> ((Ingredient)ingredient).apply(arg_0));
    }

    public static boolean isFluidContainer(ItemStack stack) {
        return !stack.func_190926_b() && (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) || stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null));
    }

    public static <T> NonNullList<T> asNonnullList(T ... array) {
        NonNullList nonNullList = NonNullList.func_191196_a();
        if (array != null) {
            nonNullList.addAll((Collection)Arrays.stream(array).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return nonNullList;
    }

    public static <T> NonNullList<T> asNonnullList(List<T> list) {
        NonNullList nonNullList = NonNullList.func_191196_a();
        if (list != null) {
            nonNullList.addAll((Collection)list.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return nonNullList;
    }

    public static IItemHandlerModifiable getPlayerInventory(EntityPlayer player, EnumFacing inv) {
        return (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inv);
    }

    public static void givePlayer(EntityPlayer player, EnumFacing inv, NonNullList<ItemStack> stacks) {
        IItemHandlerModifiable inventory = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inv);
        if (inventory != null) {
            InvUtils.insert(player.field_70170_p, player.func_180425_c(), (IItemHandler)inventory, stacks, false);
        }
    }

    public static boolean usePlayerItemStrict(EntityPlayer player, EnumFacing inv, Ingredient ingredient, int amount) {
        IItemHandlerModifiable inventory = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inv);
        return inventory != null && InvUtils.consumeItemsInInventoryStrict(inventory, ingredient, amount, false);
    }

    public static boolean usePlayerItem(EntityPlayer player, EnumFacing inv, ItemStack stack, int amount) {
        IItemHandlerModifiable inventory = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inv);
        return inventory != null && InvUtils.consumeItemsInInventory((IItemHandler)inventory, stack, amount, false);
    }

    public static boolean usePlayerItem(EntityPlayer player, EnumFacing inv, Ingredient ingredient) {
        IItemHandlerModifiable inventory = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inv);
        boolean result = false;
        if (inventory != null) {
            NonNullList containers = NonNullList.func_191196_a();
            result = InvUtils.consumeItemsInInventory((IItemHandler)inventory, ingredient, false, (NonNullList<ItemStack>)containers);
            InvUtils.givePlayer(player, inv, (NonNullList<ItemStack>)containers);
        }
        return result;
    }

    public static Optional<IItemHandler> getItemHandler(World world, BlockPos pos, EnumFacing facing) {
        return InvUtils.getItemHandler(world, pos, facing, te -> true);
    }

    public static Optional<IItemHandler> getItemHandler(World world, BlockPos pos, EnumFacing facing, Predicate<TileEntity> tePredicate) {
        if (!world.field_72995_K) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && tePredicate.test(tile)) {
                return Optional.ofNullable(tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing));
            }
            List entities = world.func_175647_a(Entity.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)), entity -> entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing));
            Optional entity2 = entities.stream().findFirst();
            if (entity2.isPresent()) {
                return Optional.ofNullable(((Entity)entity2.get()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing));
            }
        }
        return Optional.ofNullable(null);
    }

    public static void ejectInventoryContents(World world, BlockPos pos, IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            InvUtils.ejectStackWithOffset(world, pos, inv.getStackInSlot(i));
        }
    }

    public static void clearInventory(IItemHandlerModifiable inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            inv.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public static void copyTags(ItemStack destStack, ItemStack sourceStack) {
        if (sourceStack.func_77942_o()) {
            destStack.func_77982_d(sourceStack.func_77978_p().func_74737_b());
        }
    }

    public static ItemStack decrStackSize(IItemHandlerModifiable inv, int slot, int amount) {
        if (!inv.getStackInSlot(slot).func_190926_b()) {
            if (inv.getStackInSlot(slot).func_190916_E() <= amount) {
                ItemStack splitStack = inv.getStackInSlot(slot);
                inv.setStackInSlot(slot, ItemStack.field_190927_a);
                return splitStack;
            }
            ItemStack splitStack = inv.getStackInSlot(slot).func_77979_a(amount);
            if (inv.getStackInSlot(slot).func_190916_E() < 1) {
                inv.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            return splitStack;
        }
        return null;
    }

    public static ItemStack insertSingle(IItemHandler inv, ItemStack stack, boolean simulate) {
        return InvUtils.insert(inv, stack, 1, simulate);
    }

    public static ItemStack insert(IItemHandler inv, ItemStack stack, int count, boolean simulate) {
        ItemStack copy = stack.func_77946_l();
        if (copy.func_190916_E() > count) {
            copy.func_190920_e(count);
        }
        return InvUtils.insert(inv, copy, simulate);
    }

    public static boolean canInsert(IItemHandler inv, ItemStack stack, int count) {
        ItemStack inserted;
        ItemStack copy = stack.func_77946_l();
        if (copy.func_190916_E() > count) {
            copy.func_190920_e(count);
        }
        return !(inserted = InvUtils.insert(inv, copy, true)).equals(copy);
    }

    public static void insert(World world, BlockPos pos, IItemHandler inv, NonNullList<ItemStack> stacks, boolean simulate) {
        stacks.forEach(stack -> {
            ItemStack returned = InvUtils.insert(inv, stack, 0, inv.getSlots(), simulate);
            if (!returned.func_190926_b()) {
                EJECT_OFFSET.setStack(returned).ejectStack(world, new Vec3d((Vec3i)pos), Vec3d.field_186680_a);
            }
        });
    }

    public static ItemStack insert(IItemHandler inv, ItemStack stack, boolean simulate) {
        return InvUtils.insert(inv, stack, 0, inv.getSlots(), simulate);
    }

    public static ItemStack insert(IItemHandler inv, ItemStack stack, int minSlot, int maxSlot, boolean simulate) {
        return InvUtils.attemptInsert(inv, stack, minSlot, maxSlot, simulate);
    }

    public static ItemStack attemptInsert(IItemHandler inv, ItemStack stack, int minSlot, int maxSlot, boolean simulate) {
        if (InvUtils.isFull(inv)) {
            return stack;
        }
        for (int slot = minSlot; slot < maxSlot && !(stack = inv.insertItem(slot, stack, simulate)).func_190926_b(); ++slot) {
        }
        return stack;
    }

    public static boolean insertFromWorld(IItemHandler inv, EntityItem entity, int minSlot, int maxSlot, boolean simulate) {
        ItemStack stack = entity.func_92059_d().func_77946_l();
        ItemStack leftover = InvUtils.attemptInsert(inv, stack, minSlot, maxSlot, simulate);
        if (leftover.func_190926_b()) {
            entity.func_70106_y();
            return true;
        }
        entity.func_92058_a(leftover);
        return false;
    }

    public static boolean isFull(IItemHandler inv) {
        boolean full = true;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190916_E() == inv.getSlotLimit(slot)) continue;
            full = false;
            break;
        }
        return full;
    }

    public static ItemStack findItemInInventory(Ingredient ingredient, IItemHandler inventory) {
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (!ingredient.apply(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static int getRandomOccupiedStackInRange(IItemHandler inv, int minSlot, int maxSlot) {
        ArrayList list = Lists.newArrayList();
        for (int slot = minSlot; slot <= maxSlot; ++slot) {
            if (inv.getStackInSlot(slot).func_190926_b()) continue;
            list.add(slot);
        }
        if (list.isEmpty()) {
            return -1;
        }
        return (Integer)list.get(RandomUtils.nextInt((int)0, (int)list.size()));
    }

    public static int getFirstOccupiedStackInRange(IItemHandler inv, int minSlot, int maxSlot) {
        for (int slot = minSlot; slot <= maxSlot; ++slot) {
            if (inv.getStackInSlot(slot).func_190926_b()) continue;
            return slot;
        }
        return -1;
    }

    public static int getFirstEmptyStackInRange(IItemHandler inv, int minSlot, int maxSlot) {
        for (int slot = minSlot; slot <= maxSlot; ++slot) {
            if (!inv.getStackInSlot(slot).func_190926_b()) continue;
            return slot;
        }
        return -1;
    }

    public static int getOccupiedStacks(IItemHandler inv) {
        return InvUtils.getOccupiedStacks(inv, 0, inv.getSlots() - 1);
    }

    public static int getOccupiedStacks(IItemHandler inv, int min, int max) {
        int count = 0;
        for (int i = min; i <= max; ++i) {
            if (!inv.getStackInSlot(i).func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    public static int countItemStacksInInventory(IItemHandler inv, ItemStack toCheck) {
        int itemCount = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b() || !ItemStack.func_179545_c((ItemStack)toCheck, (ItemStack)stack) && (toCheck.func_77973_b() != stack.func_77973_b() || toCheck.func_77952_i() != Short.MAX_VALUE)) continue;
            if (toCheck.func_77942_o()) {
                if (!ItemStack.func_77970_a((ItemStack)toCheck, (ItemStack)stack)) continue;
                itemCount += stack.func_190916_E();
                continue;
            }
            itemCount += stack.func_190916_E();
        }
        return itemCount;
    }

    public static int countItemsInInventory(IItemHandler inv, Item item) {
        return InvUtils.countItemsInInventory(inv, item, Short.MAX_VALUE);
    }

    public static int countItemsInInventory(IItemHandler inv, Item item, int meta) {
        int itemCount = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item || meta != Short.MAX_VALUE && stack.func_77952_i() != meta) continue;
            itemCount += inv.getStackInSlot(i).func_190916_E();
        }
        return itemCount;
    }

    public static int countOresInInventory(IItemHandler inv, List<ItemStack> list) {
        int ret = 0;
        if (list != null && !list.isEmpty()) {
            for (ItemStack oreStack : list) {
                ret += InvUtils.countItemStacksInInventory(inv, oreStack);
            }
        }
        return ret;
    }

    public static boolean consumeItemsInInventoryStrict(IItemHandlerModifiable inv, Ingredient ingredient, int sizeOfStack, boolean simulate) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b() || !ingredient.apply(stack) || stack.func_190916_E() < sizeOfStack) continue;
            InvUtils.decrStackSize(inv, i, sizeOfStack);
            return true;
        }
        return false;
    }

    public static boolean consumeItemsInInventory(IItemHandler inv, ItemStack toCheck, int sizeOfStack, boolean simulate) {
        boolean extracted = false;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack inSlot = inv.getStackInSlot(i);
            if (!InvUtils.matches(toCheck, inSlot)) continue;
            ItemStack container = ForgeHooks.getContainerItem((ItemStack)inSlot);
            if (inv.extractItem(i, sizeOfStack, simulate).func_190916_E() < sizeOfStack) continue;
            extracted = true;
            InvUtils.insert(inv, container, false);
            break;
        }
        return extracted;
    }

    public static boolean consumeItemsInInventory(IItemHandler inv, Ingredient ingredient, boolean simulate, NonNullList<ItemStack> containers) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack inSlot = inv.getStackInSlot(i);
            if (!ingredient.apply(inSlot)) continue;
            ItemStack container = ForgeHooks.getContainerItem((ItemStack)inSlot);
            if (!container.func_190926_b()) {
                containers.add((Object)container);
            }
            int count = ingredient instanceof StackIngredient ? ((StackIngredient)ingredient).getCount(inSlot) : 1;
            return inv.extractItem(i, count, simulate).func_190916_E() >= count;
        }
        return false;
    }

    public static boolean consumeItemsInInventory(IItemHandler inv, StackIngredient ingredient, boolean simulate, NonNullList<ItemStack> containers) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack inSlot = inv.getStackInSlot(i);
            if (!ingredient.apply(inSlot)) continue;
            int sizeOfStack = ingredient.getCount(inSlot);
            ItemStack container = ForgeHooks.getContainerItem((ItemStack)inSlot);
            if (!container.func_190926_b()) {
                containers.add((Object)container);
            }
            return inv.extractItem(i, sizeOfStack, simulate).func_190916_E() >= sizeOfStack;
        }
        return false;
    }

    public static boolean consumeItemsInInventory(IItemHandlerModifiable inv, Item item, int meta, int stackSize) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item || meta != Short.MAX_VALUE && stack.func_77952_i() != meta) continue;
            if (stack.func_190916_E() >= stackSize) {
                InvUtils.decrStackSize(inv, i, stackSize);
                return false;
            }
            stackSize -= stack.func_190916_E();
            inv.setStackInSlot(i, ItemStack.field_190927_a);
        }
        return false;
    }

    public static boolean consumeOresInInventory(IItemHandlerModifiable inv, List<?> list, int stackSize) {
        if (list.size() > 0) {
            for (Object aList : list) {
                ItemStack tempStack = (ItemStack)aList;
                Item item = tempStack.func_77973_b();
                int meta = tempStack.func_77952_i();
                for (int j = 0; j < inv.getSlots(); ++j) {
                    ItemStack stack = inv.getStackInSlot(j);
                    if (stack.func_190926_b() || stack.func_77973_b() != item || stack.func_77952_i() != meta && meta != Short.MAX_VALUE) continue;
                    if (tempStack.func_77942_o()) {
                        if (!ItemStack.func_77970_a((ItemStack)tempStack, (ItemStack)stack)) continue;
                        if (stack.func_190916_E() >= stackSize) {
                            InvUtils.decrStackSize(inv, j, stackSize);
                            return false;
                        }
                        stackSize -= stack.func_190916_E();
                        inv.setStackInSlot(j, ItemStack.field_190927_a);
                        continue;
                    }
                    if (stack.func_190916_E() >= stackSize) {
                        InvUtils.decrStackSize(inv, j, stackSize);
                        return false;
                    }
                    stackSize -= stack.func_190916_E();
                    inv.setStackInSlot(j, ItemStack.field_190927_a);
                }
            }
        }
        return false;
    }

    public static int getFirstOccupiedStackNotOfItem(IItemHandler inv, Item item) {
        return InvUtils.getFirstOccupiedStackNotOfItem(inv, item, Short.MAX_VALUE);
    }

    public static int getFirstOccupiedStackNotOfItem(IItemHandler inv, Item item, int meta) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).func_190926_b()) continue;
            int tempMeta = inv.getStackInSlot(i).func_77952_i();
            if (inv.getStackInSlot(i).func_77973_b() == item || meta != Short.MAX_VALUE && tempMeta == meta) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstOccupiedStackOfItem(IItemHandler inv, Item item) {
        return InvUtils.getFirstOccupiedStackOfItem(inv, item);
    }

    public static int getFirstOccupiedStackOfItem(IItemHandler inv, ItemStack stack) {
        return InvUtils.getFirstOccupiedStackOfItem(inv, StackIngredient.fromStacks(stack));
    }

    public static int getFirstOccupiedStackOfItem(IItemHandler inv, Ingredient ingred) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).func_190926_b() || !ingred.apply(inv.getStackInSlot(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean spawnStack(World world, BlockPos pos, List<ItemStack> stacks) {
        boolean spawned = true;
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b() || InvUtils.spawnStack(world, pos, stack, 10)) continue;
            spawned = false;
        }
        return spawned;
    }

    public static boolean spawnStack(World world, BlockPos pos, ItemStack stack, int pickupDelay) {
        return InvUtils.spawnStack(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), stack, pickupDelay);
    }

    public static boolean spawnStack(World world, double x, double y, double z, ItemStack stack, int pickupDelay) {
        EntityItem item = new EntityItem(world, x, y, z, stack);
        item.field_70159_w = 0.0;
        item.field_70181_x = 0.0;
        item.field_70179_y = 0.0;
        item.func_174867_a(pickupDelay);
        return world.func_72838_d((Entity)item);
    }

    public static void spawnStack(World world, double x, double y, double z, int count, ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        if (copy.func_190916_E() > count) {
            copy.func_190920_e(count);
        }
        InvUtils.spawnStack(world, x, y, z, copy, 10);
    }

    public static void ejectStackWithOffset(World world, BlockPos pos, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            InvUtils.ejectStackWithOffset(world, pos, stack.func_77946_l());
        }
    }

    public static void ejectStackWithOffset(World world, BlockPos pos, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            InvUtils.ejectStackWithOffset(world, pos, stack.func_77946_l());
        }
    }

    public static void ejectStackWithOffset(World world, BlockPos pos, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        EJECT_OFFSET.setStack(stack).ejectStack(world, new Vec3d((Vec3i)pos), Vec3d.field_186680_a);
    }

    public static void ejectStack(@Nonnull World world, double x, double y, double z, ItemStack stack, int pickupDelay) {
        if (world.field_72995_K) {
            return;
        }
        EJECT_EXACT.setStack(stack).setPickupDelay(pickupDelay).ejectStack(world, new Vec3d(x, y, z), Vec3d.field_186680_a);
    }

    public static void ejectStack(@Nonnull World world, double x, double y, double z, ItemStack stack) {
        InvUtils.ejectStack(world, x, y, z, stack, 10);
    }

    public static void ejectBrokenItems(World world, BlockPos pos, ResourceLocation lootLocation) {
        if (!world.field_72995_K) {
            LootContext.Builder build = new LootContext.Builder((WorldServer)world);
            List stacks = world.func_184146_ak().func_186521_a(lootLocation).func_186462_a(world.field_73012_v, build.func_186471_a());
            if (!stacks.isEmpty()) {
                InvUtils.ejectStackWithOffset(world, pos, stacks);
            }
        }
    }

    public static void writeToStack(IItemHandler inv, ItemStack stack) {
        NonNullList list = NonNullList.func_191197_a((int)inv.getSlots(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).func_190926_b()) continue;
            list.set(i, (Object)inv.getStackInSlot(i).func_77946_l());
        }
        NBTTagCompound tag = ItemStackHelper.func_191282_a((NBTTagCompound)new NBTTagCompound(), (NonNullList)list);
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
    }

    public static void readFromStack(IItemHandler inv, ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77942_o()) {
            NonNullList list = NonNullList.func_191197_a((int)inv.getSlots(), (Object)ItemStack.field_190927_a);
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null) {
                ItemStackHelper.func_191283_b((NBTTagCompound)tag, (NonNullList)list);
                for (int i = 0; i < inv.getSlots(); ++i) {
                    inv.insertItem(i, (ItemStack)list.get(i), false);
                }
            }
        }
    }

    public static int calculateComparatorLevel(@Nonnull IItemHandler inventory) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inventory.getSlots(); ++j) {
            ItemStack itemstack = inventory.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)itemstack.func_77976_d();
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)inventory.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static ItemStack setCount(ItemStack input, int count) {
        if (input.func_190926_b()) {
            return input;
        }
        ItemStack stack = input.func_77946_l();
        stack.func_190920_e(count);
        return stack;
    }

    public static boolean matches(ItemStack one, ItemStack two) {
        if (one.func_77969_a(two)) {
            return true;
        }
        return one.func_77973_b() == two.func_77973_b() && (one.func_77960_j() == Short.MAX_VALUE || two.func_77960_j() == Short.MAX_VALUE);
    }

    public static boolean matchesSize(ItemStack one, ItemStack two) {
        return one.func_190916_E() == two.func_190916_E() && InvUtils.matches(one, two);
    }

    public static <T> boolean matchesPredicate(List<T> oneList, List<T> twoList, BiPredicate<T, T> matches) {
        if (oneList.size() != twoList.size()) {
            return false;
        }
        HashSet<Object> alreadyMatched = new HashSet<Object>();
        for (Object one : oneList) {
            Optional<Object> found = twoList.stream().filter(two -> !alreadyMatched.contains(two) && matches.test(one, two)).findFirst();
            if (found.isPresent()) {
                alreadyMatched.add(found.get());
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean matchesExact(List<ItemStack> oneList, List<ItemStack> twoList) {
        return InvUtils.matchesPredicate(oneList, twoList, InvUtils::matchesSize);
    }

    public static boolean matches(List<ItemStack> oneList, List<ItemStack> twoList) {
        return InvUtils.matchesPredicate(oneList, twoList, InvUtils::matches);
    }

    public static <T> List<List<T>> splitIntoBoxes(List<T> stacks, int boxes) {
        ArrayList<List<T>> splitStacks = new ArrayList<List<T>>();
        int i = 0;
        while (i < boxes) {
            int finalI = i++;
            splitStacks.add(IntStream.range(0, stacks.size()).filter(index -> index % boxes == finalI).mapToObj(stacks::get).collect(Collectors.toList()));
        }
        return splitStacks;
    }

    public static boolean isEmpty(IItemHandler inventory) {
        int inventorySize = inventory.getSlots();
        for (int i = 0; i < inventorySize; ++i) {
            if (inventory.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static EnumHand otherHand(EnumHand hand) {
        switch (hand) {
            default: {
                return EnumHand.OFF_HAND;
            }
            case OFF_HAND: 
        }
        return EnumHand.MAIN_HAND;
    }
}

