/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.needs;

import betterwithmods.common.BWMItems;
import betterwithmods.common.BWMRecipes;
import betterwithmods.module.ConfigHelper;
import betterwithmods.module.Feature;
import betterwithmods.util.ReflectionLib;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class HCTools
extends Feature {
    public static final HashMap<Item.ToolMaterial, ToolMaterialOverride> OVERRIDES = Maps.newHashMap();
    public static boolean removeLowTools;
    public static boolean perToolOverrides;
    public static int noHungerThreshold;
    public static int noDamageThreshold;
    private static Set<Item> TOOLS;

    private static void removeLowTierToolRecipes() {
        BWMRecipes.removeRecipe(new ItemStack(Items.field_151053_p, Short.MAX_VALUE));
        BWMRecipes.removeRecipe(new ItemStack(Items.field_151017_I, Short.MAX_VALUE));
        BWMRecipes.removeRecipe(new ItemStack(Items.field_151041_m, Short.MAX_VALUE));
        BWMRecipes.removeRecipe(new ItemStack(Items.field_151018_J, Short.MAX_VALUE));
        BWMRecipes.removeRecipe(new ItemStack(Items.field_151052_q, Short.MAX_VALUE));
    }

    @Override
    public String getFeatureDescription() {
        return "Overhaul the durability of tools to be more rewarding when reaching the next level. Completely disables wooden tools (other than pick) by default.";
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (removeLowTools) {
            HCTools.removeLowTierToolRecipes();
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        TOOLS = new HashSet<Item>(Sets.newHashSet((Object[])new Item[]{BWMItems.STEEL_AXE, BWMItems.STEEL_BATTLEAXE, BWMItems.STEEL_HOE, BWMItems.STEEL_SWORD, BWMItems.STEEL_PICKAXE, BWMItems.STEEL_SWORD, BWMItems.STEEL_MATTOCK, Items.field_151046_w, Items.field_151056_x, Items.field_151048_u, Items.field_151047_v, Items.field_151012_L, Items.field_151035_b, Items.field_151036_c, Items.field_151040_l, Items.field_151037_a, Items.field_151019_K, Items.field_151050_s, Items.field_151049_t, Items.field_151052_q, Items.field_151051_r, Items.field_151018_J, Items.field_151005_D, Items.field_151006_E, Items.field_151010_B, Items.field_151011_C, Items.field_151013_M, Items.field_151039_o, Items.field_151053_p, Items.field_151041_m, Items.field_151038_n, Items.field_151017_I}));
        OVERRIDES.put(Item.ToolMaterial.WOOD, new ToolMaterialOverride("wood", 1, 1.01f, 0).addClassOverride("shovel", 10));
        OVERRIDES.put(Item.ToolMaterial.STONE, new ToolMaterialOverride("stone", 6, 1.01f, 5).addClassOverride("shovel", 50).addClassOverride("axe", 50));
        OVERRIDES.put(Item.ToolMaterial.IRON, new ToolMaterialOverride("iron", 500, 6.0f, 14));
        OVERRIDES.put(Item.ToolMaterial.DIAMOND, new ToolMaterialOverride("diamond", 1561, 8.0f, 14));
        OVERRIDES.put(Item.ToolMaterial.GOLD, new ToolMaterialOverride("gold", 32, 12.0f, 22));
        OVERRIDES.put(BWMItems.SOULFORGED_STEEL, new ToolMaterialOverride(BWMItems.SOULFORGED_STEEL));
        TOOLS.forEach(this::loadToolMaterialOverride);
    }

    private Item.ToolMaterial getMaterial(Item tool) {
        if (tool instanceof ItemTool) {
            return (Item.ToolMaterial)ReflectionHelper.getPrivateValue(ItemTool.class, (Object)((ItemTool)tool), (String[])ReflectionLib.ITEMTOOL_TOOLMATERIAL);
        }
        if (tool instanceof ItemHoe) {
            return (Item.ToolMaterial)ReflectionHelper.getPrivateValue(ItemHoe.class, (Object)((ItemHoe)tool), (String[])ReflectionLib.ITEMHOE_TOOLMATERIAL);
        }
        if (tool instanceof ItemSword) {
            return (Item.ToolMaterial)ReflectionHelper.getPrivateValue(ItemSword.class, (Object)((ItemSword)tool), (String[])ReflectionLib.ITEMSWORD_TOOLMATERIAL);
        }
        return null;
    }

    private Set<String> getToolClass(ItemStack stack) {
        Item item = stack.func_77973_b();
        HashSet classes = Sets.newHashSet();
        classes.addAll(item.getToolClasses(stack));
        if (item instanceof ItemSword) {
            classes.add("sword");
        } else if (item instanceof ItemHoe) {
            classes.add("hoe");
        }
        return classes;
    }

    private void loadToolMaterialOverride(Item tool) {
        Item.ToolMaterial material = this.getMaterial(tool);
        if (material != null) {
            ItemStack stack;
            Set<String> classes;
            ToolMaterialOverride override = OVERRIDES.get(material);
            ReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)material, (Object)override.getMaxUses(), (String[])ReflectionLib.TOOLMATERIAL_MAXUSES);
            ReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)material, (Object)Float.valueOf(override.getEfficiency()), (String[])ReflectionLib.TOOLMATERIAL_EFFICIENCY);
            ReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)material, (Object)override.getEnchantability(), (String[])ReflectionLib.TOOLMATERIAL_ENCHANTABILITIY);
            if (tool instanceof ItemTool) {
                ReflectionHelper.setPrivateValue(ItemTool.class, (Object)((ItemTool)tool), (Object)Float.valueOf(material.func_77998_b()), (String[])ReflectionLib.ITEMTOOL_EFFICIENCY);
            }
            if (!(classes = this.getToolClass(stack = new ItemStack(tool))).isEmpty()) {
                classes.stream().findFirst().ifPresent(c -> tool.func_77656_e(override.getMaxUses((String)c)));
            } else {
                tool.func_77656_e(override.getMaxUses());
            }
        }
    }

    @Override
    public void setupConfig() {
        removeLowTools = this.loadPropBool("Remove cheapest tools", "The minimum level of the hoe and the sword is iron, and the axe needs at least stone.", true);
        noHungerThreshold = this.loadPropInt("No Exhaustion Harvest Level", "When destroying a 0 hardness block with a tool of this harvest level or higher, no exhaustion is applied", Item.ToolMaterial.IRON.func_77996_d());
        noDamageThreshold = this.loadPropInt("No Durability Damage Harvest Level", "When destroying a 0 hardness block with a tool of this harvest level or higher, no durability damage is applied", Item.ToolMaterial.DIAMOND.func_77996_d());
        perToolOverrides = this.loadPropBool("Change Durability per Tool", "Allow configuring tool durability for each class", true);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @SubscribeEvent
    public void onHitEntity(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack stack = player.func_184614_ca();
            this.breakTool(stack, player);
        }
    }

    @SubscribeEvent
    public void onUseHoe(UseHoeEvent event) {
        this.breakTool(event.getCurrent(), event.getEntityPlayer());
    }

    @SubscribeEvent
    public void onBreaking(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        this.breakTool(stack, player);
    }

    private void breakTool(ItemStack stack, EntityPlayer player) {
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77958_k() == 1) {
            this.destroyItem(stack, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void harvestGarbage(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (event.isCanceled() || player == null || player.func_184812_l_()) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = player.func_184614_ca();
        String tooltype = state.func_177230_c().getHarvestTool(state);
        if (tooltype != null && state.func_185887_b(world, pos) <= 0.0f && stack.func_77973_b().getHarvestLevel(stack, tooltype, player, state) < noDamageThreshold) {
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    private void destroyItem(ItemStack stack, EntityLivingBase entity) {
        int damage = stack.func_77958_k();
        stack.func_77972_a(damage, entity);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    public class ToolMaterialOverride {
        private final String name;
        public Map<String, Integer> toolClassOverrides = Maps.newHashMap();
        private int maxUses;
        private float efficiencyOnProperMaterial;
        private int enchantability;

        public ToolMaterialOverride(Item.ToolMaterial material) {
            this(material.name().toLowerCase(), material.func_77997_a(), material.func_77998_b(), material.func_77995_e());
        }

        ToolMaterialOverride(String name, int maxUses, float efficiencyOnProperMaterial, int enchantability) {
            this.name = name;
            this.maxUses = ConfigHelper.loadPropInt("Max Durability", HCTools.this.configCategory + "." + name, "", maxUses);
            this.efficiencyOnProperMaterial = efficiencyOnProperMaterial;
            this.enchantability = enchantability;
        }

        int getMaxUses(String toolClass) {
            int use = this.getMaxUses();
            if (perToolOverrides) {
                use = ConfigHelper.loadPropInt("Max Durability: " + toolClass, HCTools.this.configCategory + "." + this.name, "", this.toolClassOverrides.getOrDefault(toolClass, use));
            }
            return Math.max(1, use - 1);
        }

        int getMaxUses() {
            return this.maxUses;
        }

        float getEfficiency() {
            return this.efficiencyOnProperMaterial;
        }

        int getEnchantability() {
            return this.enchantability;
        }

        ToolMaterialOverride addClassOverride(String toolClass, int durability) {
            this.toolClassOverrides.put(toolClass, durability);
            return this;
        }
    }
}

