/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay.miniblocks.orientations;

import betterwithmods.module.gameplay.miniblocks.orientations.BaseOrientation;
import betterwithmods.module.gameplay.miniblocks.orientations.OrientationUtils;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum SidingOrientation implements BaseOrientation
{
    UP("up", EnumFacing.UP, 180, 0, new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0)),
    DOWN("down", EnumFacing.DOWN, 0, 0, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)),
    NORTH("north", EnumFacing.NORTH, 90, 0, new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0)),
    SOUTH("south", EnumFacing.SOUTH, 270, 0, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5)),
    WEST("west", EnumFacing.WEST, 270, 90, new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0)),
    EAST("east", EnumFacing.EAST, 270, 270, new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0));

    public static final SidingOrientation[] VALUES;
    private String name;
    private EnumFacing facing;
    private AxisAlignedBB bounds;
    private int x;
    private int y;

    private SidingOrientation(String name, EnumFacing facing, int x, int y, AxisAlignedBB bounds) {
        this.name = name;
        this.facing = facing;
        this.x = x;
        this.y = y;
        this.bounds = bounds;
    }

    public static BaseOrientation fromFace(EnumFacing facing) {
        if (facing != null) {
            return VALUES[facing.func_176745_a()];
        }
        return BaseOrientation.DEFAULT;
    }

    public static BaseOrientation getFromVec(Vec3d hit, EnumFacing facing) {
        float hitXFromCenter = (float)(hit.field_72450_a - 0.5);
        float hitYFromCenter = (float)(hit.field_72448_b - 0.5);
        float hitZFromCenter = (float)(hit.field_72449_c - 0.5);
        switch (facing.func_176740_k()) {
            case Y: {
                if (OrientationUtils.inCenter(hitXFromCenter, hitZFromCenter, 0.25f)) {
                    return SidingOrientation.fromFace(facing);
                }
                if (OrientationUtils.isMax(hitXFromCenter, hitZFromCenter)) {
                    return hitXFromCenter < 0.0f ? SidingOrientation.fromFace(EnumFacing.EAST) : SidingOrientation.fromFace(EnumFacing.WEST);
                }
                return hitZFromCenter < 0.0f ? SidingOrientation.fromFace(EnumFacing.SOUTH) : SidingOrientation.fromFace(EnumFacing.NORTH);
            }
            case X: {
                if (OrientationUtils.inCenter(hitYFromCenter, hitZFromCenter, 0.25f)) {
                    return SidingOrientation.fromFace(facing);
                }
                if (OrientationUtils.isMax(hitYFromCenter, hitZFromCenter)) {
                    return hitYFromCenter < 0.0f ? SidingOrientation.fromFace(EnumFacing.UP) : SidingOrientation.fromFace(EnumFacing.DOWN);
                }
                return hitZFromCenter < 0.0f ? SidingOrientation.fromFace(EnumFacing.SOUTH) : SidingOrientation.fromFace(EnumFacing.NORTH);
            }
            case Z: {
                if (OrientationUtils.inCenter(hitYFromCenter, hitXFromCenter, 0.25f)) {
                    return SidingOrientation.fromFace(facing);
                }
                if (OrientationUtils.isMax(hitYFromCenter, hitXFromCenter)) {
                    return hitYFromCenter < 0.0f ? SidingOrientation.fromFace(EnumFacing.UP) : SidingOrientation.fromFace(EnumFacing.DOWN);
                }
                return hitXFromCenter < 0.0f ? SidingOrientation.fromFace(EnumFacing.EAST) : SidingOrientation.fromFace(EnumFacing.WEST);
            }
        }
        return SidingOrientation.fromFace(facing);
    }

    public String func_176610_l() {
        return this.name;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public AxisAlignedBB getBounds() {
        return this.bounds;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TRSRTransformation toTransformation() {
        return new TRSRTransformation(ModelRotation.func_177524_a((int)this.x, (int)this.y));
    }

    @Override
    public BaseOrientation next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    static {
        VALUES = SidingOrientation.values();
    }
}

