/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.manual.custom;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockAesthetic;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import betterwithmods.common.registry.block.recipe.BlockDropIngredient;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.common.registry.block.recipe.StateIngredient;
import betterwithmods.manual.api.manual.PathProvider;
import betterwithmods.util.SetBlockIngredient;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StatePathProvider
implements PathProvider {
    private final Set<PathOverride> PATH_OVERRIDES = Sets.newHashSet();

    public StatePathProvider() {
        this.addBlock(new SetBlockIngredient(new StateIngredient(BWMBlocks.BAMBOO_CHIME), new StateIngredient(BWMBlocks.METAL_CHIME)), "wind_chime");
        this.addBlock(new StateIngredient(BWMBlocks.WOODEN_BROKEN_GEARBOX), "wooden_gearbox");
        this.addBlock(new BlockIngredient(BlockAesthetic.getStack(BlockAesthetic.EnumType.CHOPBLOCK), BlockAesthetic.getStack(BlockAesthetic.EnumType.CHOPBLOCKBLOOD)), "chopping_block");
        this.addBlock(new BlockIngredient(BlockAesthetic.getStack(BlockAesthetic.EnumType.WHITESTONE), BlockAesthetic.getStack(BlockAesthetic.EnumType.WHITECOBBLE)), "white_stone");
        this.addItem(new BlockIngredient(BlockAesthetic.getStack(BlockAesthetic.EnumType.NETHERCOAL)), "nether_coal");
        this.addBlock(new BlockDropIngredient(BlockMechMachines.getStack(BlockMechMachines.EnumType.TURNTABLE)), "turntable");
        this.addBlock(new BlockDropIngredient(BlockMechMachines.getStack(BlockMechMachines.EnumType.MILL)), "millstone");
        this.addBlock(new BlockDropIngredient(BlockMechMachines.getStack(BlockMechMachines.EnumType.HOPPER)), "hopper");
        this.addBlock(new BlockDropIngredient(BlockMechMachines.getStack(BlockMechMachines.EnumType.PULLEY)), "pulley");
        this.addItem(new StateIngredient(BWMBlocks.ROPE), "rope");
        this.addBlock(new SetBlockIngredient(new StateIngredient(BWMBlocks.GRATE), new StateIngredient(BWMBlocks.WICKER), new StateIngredient(BWMBlocks.SLATS)), "decoration");
    }

    private void addBlock(BlockIngredient ingredient, String name) {
        this.PATH_OVERRIDES.add(new PathOverride(ingredient, name));
    }

    private void addItem(BlockIngredient ingredient, String name) {
        this.PATH_OVERRIDES.add(new PathOverride(ingredient, "items", name));
    }

    @Override
    @Nullable
    public String pathFor(@Nonnull ItemStack stack) {
        return null;
    }

    @Override
    @Nullable
    public String pathFor(@Nonnull World world, @Nonnull BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        for (PathOverride override : this.PATH_OVERRIDES) {
            if (!override.apply(world, pos, state)) continue;
            return String.format("%%LANGUAGE%%/%s/%s.md", override.path, override.name);
        }
        return this.defaultPathFor(state);
    }

    private String defaultPathFor(IBlockState state) {
        Block block = state.func_177230_c();
        ResourceLocation loc = block.getRegistryName();
        if (loc != null && loc.func_110624_b().equalsIgnoreCase("betterwithmods")) {
            String name = loc.func_110623_a();
            return String.format("%%LANGUAGE%%/blocks/%s.md", name);
        }
        return null;
    }

    private class PathOverride {
        private BlockIngredient ingredient;
        private String name;
        private String path;

        public PathOverride(BlockIngredient ingredient, String name) {
            this(ingredient, "blocks", name);
        }

        public PathOverride(BlockIngredient ingredient, String path, String name) {
            this.ingredient = ingredient;
            this.name = name;
            this.path = path;
        }

        public boolean apply(World world, BlockPos pos, IBlockState state) {
            return this.ingredient.apply(world, pos, state);
        }
    }
}

