/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.module.hardcore.beacons.BeaconEffect;
import betterwithmods.module.hardcore.beacons.CapabilityBeacon;
import betterwithmods.module.hardcore.beacons.HCBeacons;
import betterwithmods.module.hardcore.beacons.SpawnBeaconEffect;
import betterwithmods.util.ColorUtils;
import betterwithmods.util.WorldUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBeacon
extends net.minecraft.tileentity.TileEntityBeacon
implements ITickable {
    private static final int DEFAULT_TICK_RATE = 120;
    private int currentLevel;
    private boolean active;
    private IBlockState type = Blocks.field_150350_a.func_176223_P();
    private BeaconEffect effect;
    private BeaconEffect prevEffect;
    private int tick;
    private List<BeamSegment> segments = Lists.newArrayList();
    @SideOnly(value=Side.CLIENT)
    private long beamRenderCounter;
    @SideOnly(value=Side.CLIENT)
    private float beamRenderScale;

    public void func_73660_a() {
        if (this.tick <= 0) {
            if (!this.canSeeSky() && this.active) {
                this.deactivate();
                return;
            }
            this.effect = HCBeacons.getEffect(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()));
            this.tick = 120;
            if (this.effect != null) {
                BlockIngredient structureBlock = this.effect.getStructureBlock();
                this.currentLevel = this.calcLevel(structureBlock);
                if (this.currentLevel > 0) {
                    if (!this.active) {
                        this.activate();
                    }
                    this.effect.apply(this.effect.getEntitiesInRange(this.field_145850_b, this.field_174879_c, this.currentLevel), this.field_145850_b, this.field_174879_c, this.currentLevel);
                    this.calcSegments();
                    this.tick = this.effect.getTickRate();
                } else if (this.active) {
                    this.deactivate();
                }
            }
        }
        --this.tick;
    }

    private void activate() {
        CapabilityBeacon storage = (CapabilityBeacon)this.field_145850_b.getCapability(CapabilityBeacon.BEACON_CAPABILITY, EnumFacing.UP);
        if (storage != null) {
            storage.addBeacon(this.field_174879_c, this.currentLevel);
        }
        this.effect.onBeaconCreate(this.field_145850_b, this.field_174879_c, this.currentLevel);
        WorldUtils.playBroadcast(this.field_145850_b, this.effect.getActivationSound());
        this.field_145850_b.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, -4, 1)).func_72314_b(10.0, 5.0, 10.0)).forEach(player -> CriteriaTriggers.field_192131_k.func_192180_a(player, (net.minecraft.tileentity.TileEntityBeacon)this));
        this.active = true;
    }

    private void deactivate() {
        CapabilityBeacon storage;
        this.segments.clear();
        if (this.effect != null) {
            this.effect.onBeaconBreak(this.field_145850_b, this.field_174879_c, this.currentLevel);
            WorldUtils.playBroadcast(this.field_145850_b, this.effect.getDeactivationSound());
            this.effect = null;
        }
        if ((storage = (CapabilityBeacon)this.field_145850_b.getCapability(CapabilityBeacon.BEACON_CAPABILITY, EnumFacing.UP)) != null) {
            storage.removeBeacon(this.field_174879_c);
        }
        this.active = false;
    }

    public boolean canSeeSky() {
        if (this.field_145850_b.field_73011_w.func_177495_o()) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.func_174877_v().func_177984_a());
            while (pos.func_177956_o() < 128) {
                IBlockState state = this.field_145850_b.func_180495_p((BlockPos)pos);
                if (state.func_177230_c() == Blocks.field_150357_h) {
                    return true;
                }
                if (state.func_177230_c().getLightOpacity(state, (IBlockAccess)this.field_145850_b, (BlockPos)pos) > 0) {
                    return false;
                }
                pos.func_185336_p(pos.func_177956_o() + 1);
            }
            return true;
        }
        return this.field_145850_b.func_175710_j(this.field_174879_c);
    }

    @SideOnly(value=Side.CLIENT)
    public float getBeamScale() {
        int i = (int)(this.field_145850_b.func_82737_E() - this.beamRenderCounter);
        this.beamRenderCounter = this.field_145850_b.func_82737_E();
        if (i > 1) {
            this.beamRenderScale -= (float)i / 40.0f;
            if (this.beamRenderScale < 0.0f) {
                this.beamRenderScale = 0.0f;
            }
        }
        this.beamRenderScale += 0.025f;
        if (this.beamRenderScale > 1.0f) {
            this.beamRenderScale = 1.0f;
        }
        return this.beamRenderScale;
    }

    private void calcSegments() {
        this.segments.clear();
        float[] color = ColorUtils.getColorFromBlock(this.field_145850_b, this.func_174877_v().func_177984_a(), this.func_174877_v());
        if (this.effect != null) {
            color = this.effect.getBaseBeaconBeamColor(this.field_174879_c);
        }
        BeamSegment segment = new BeamSegment(color);
        this.segments.add(segment);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.func_174877_v().func_177984_a());
        while (pos.func_177956_o() < 256) {
            color = ColorUtils.getColorFromBlock(this.field_145850_b, (BlockPos)pos, this.func_174877_v());
            if (!Arrays.equals(color, new float[]{1.0f, 1.0f, 1.0f})) {
                if (Arrays.equals(color = ColorUtils.average(color, segment.func_177263_b()), segment.func_177263_b())) {
                    segment.func_177262_a();
                } else {
                    segment = new BeamSegment(color);
                    this.segments.add(segment);
                }
            } else {
                segment.func_177262_a();
            }
            pos.func_189536_c(EnumFacing.UP);
        }
    }

    public List<BeamSegment> getSegments() {
        return this.segments;
    }

    public int calcLevel(BlockIngredient structureBlock) {
        int r;
        for (r = 1; r <= 4; ++r) {
            for (int x = -r; x <= r; ++x) {
                for (int z = -r; z <= r; ++z) {
                    IBlockState stateAtPos = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(x, -r, z));
                    if (structureBlock.apply(this.field_145850_b, this.field_174879_c, stateAtPos)) continue;
                    return r - 1;
                }
            }
        }
        return r - 1;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)tag, (IBlockState)this.type);
        compound.func_74782_a("type", (NBTBase)tag);
        if (SpawnBeaconEffect.SPAWN_LIST.containsKey(this.func_174877_v())) {
            NBTTagList list = new NBTTagList();
            for (SpawnBeaconEffect.BindingPoint point : SpawnBeaconEffect.SPAWN_LIST.get(this.func_174877_v())) {
                list.func_74742_a((NBTBase)point.serializeNBT());
            }
            compound.func_74782_a("spawns", (NBTBase)list);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        NBTTagCompound type = (NBTTagCompound)compound.func_74781_a("type");
        this.type = NBTUtil.func_190008_d((NBTTagCompound)type);
        if (compound.func_74764_b("spawns")) {
            NBTTagList list = compound.func_150295_c("spawns", 10);
            HashSet points = Sets.newHashSet();
            for (NBTTagCompound tag : list) {
                points.add(new SpawnBeaconEffect.BindingPoint(tag));
            }
            SpawnBeaconEffect.SPAWN_LIST.put(this.func_174877_v(), points);
        }
        super.func_145839_a(compound);
    }

    public boolean processInteraction(World world, EntityPlayer player, ItemStack stack) {
        Block block;
        IBlockState state;
        if (player.func_184812_l_() && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock && HCBeacons.isValidBeaconBase(state = (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()).func_176203_a(stack.func_77960_j()))) {
            for (int r = 1; r <= 4; ++r) {
                for (int x = -r; x <= r; ++x) {
                    for (int z = -r; z <= r; ++z) {
                        this.field_145850_b.func_175656_a(this.func_174877_v().func_177982_a(x, -r, z), state);
                    }
                }
            }
        }
        if (!world.field_72995_K && this.effect != null) {
            boolean interacted = this.effect.onPlayerInteracted(world, this.func_174877_v(), this.func_191979_s() - 1, player, player.func_184600_cs(), stack);
            if (interacted) {
                this.field_145850_b.func_175669_a(1023, this.func_174877_v(), 0);
            }
            return interacted;
        }
        return false;
    }

    public int func_191979_s() {
        return this.currentLevel;
    }

    public boolean isEnabled() {
        return this.active;
    }

    public void onRemoved() {
        if (this.effect != null) {
            this.effect.onBeaconBreak(this.field_145850_b, this.field_174879_c, this.currentLevel);
        }
        SpawnBeaconEffect.removeAll(this.func_174877_v());
        CapabilityBeacon storage = (CapabilityBeacon)this.field_145850_b.getCapability(CapabilityBeacon.BEACON_CAPABILITY, EnumFacing.UP);
        if (storage != null) {
            storage.removeBeacon(this.field_174879_c);
        }
    }

    public class BeamSegment
    extends TileEntityBeacon.BeamSegment {
        public BeamSegment(float[] colorsIn) {
            super(colorsIn);
        }

        protected void func_177262_a() {
            super.func_177262_a();
        }
    }
}

