/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.block.IOverpower;
import betterwithmods.api.capabilities.CapabilityAxle;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IAxle;
import betterwithmods.api.tile.IAxleTick;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.BlockAxle;
import betterwithmods.common.blocks.mechanical.tile.TileGearbox;
import betterwithmods.common.blocks.tile.TileBasic;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileAxle
extends TileBasic
implements IAxle,
ITickable {
    private byte maxSignal;
    private int maxPower;
    private int minPower;
    private byte signal;
    private int power;
    private boolean dirty;
    public static List<IAxleTick> tickHandlers = Lists.newArrayList();

    public TileAxle() {
    }

    public TileAxle(int maxPower, int minPower, byte maxSignal) {
        this.maxPower = maxPower;
        this.minPower = minPower;
        this.maxSignal = maxSignal;
    }

    public void onChanged() {
        byte findSignal = 0;
        int findPower = 0;
        int sources = 0;
        for (EnumFacing facing : this.getDirections()) {
            int power;
            byte next;
            BlockPos offset = this.field_174879_c.func_177972_a(facing);
            IMechanicalPower mech = BWMAPI.IMPLEMENTATION.getMechanicalPower(this.field_145850_b, offset, facing.func_176734_d());
            if (mech == null) continue;
            IAxle axle = BWMAPI.IMPLEMENTATION.getAxle((IBlockAccess)this.field_145850_b, offset, facing.func_176734_d());
            if (axle != null && this.isFacing(axle) && (next = axle.getSignal()) > findSignal) {
                findSignal = next;
            }
            if ((power = mech.getMechanicalOutput(facing.func_176734_d())) <= 0) continue;
            if (power > findPower) {
                ++sources;
                if (axle != null) {
                    if (axle.getSignal() >= findSignal) {
                        findPower = power;
                    }
                } else {
                    findPower = power;
                    if (this.getBlock() == BWMBlocks.STEEL_AXLE && mech.getClass() == TileGearbox.class) {
                        findPower = Math.max(1, findPower / 2);
                    }
                }
            }
            if (axle != null) continue;
            findSignal = this.getMaximumSignal();
        }
        this.setPower(findPower);
        if (sources >= 2) {
            ((IOverpower)this.func_145838_q()).overpower(this.field_145850_b, this.field_174879_c);
            return;
        }
        byte newSignal = 0;
        if (findSignal > this.signal) {
            if (findSignal == 1) {
                ((IOverpower)this.func_145838_q()).overpower(this.field_145850_b, this.field_174879_c);
            }
            if (this.power > 0) {
                newSignal = (byte)(findSignal - 1);
            }
        } else {
            newSignal = 0;
            this.setPower(0);
        }
        if (newSignal != this.signal) {
            this.setSignal(newSignal);
        }
        ((BlockAxle)this.func_145838_q()).setActive(this.field_145850_b, this.field_174879_c, this.getPower() > 0);
        this.dirty = true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74774_a("signal", this.signal);
        compound.func_74768_a("power", this.power);
        compound.func_74774_a("maxSignal", this.maxSignal);
        compound.func_74768_a("maxPower", this.maxPower);
        compound.func_74768_a("minPower", this.minPower);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.signal = compound.func_74771_c("signal");
        this.maxSignal = compound.func_74771_c("maxSignal");
        this.power = compound.func_74762_e("power");
        this.maxPower = compound.func_74762_e("maxPower");
        this.minPower = compound.func_74762_e("minPower");
        super.func_145839_a(compound);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityMechanicalPower.MECHANICAL_POWER || capability == CapabilityAxle.AXLE;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        if (capability == CapabilityAxle.AXLE) {
            return (T)CapabilityAxle.AXLE.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        if (facing.func_176740_k() == this.getAxis()) {
            IAxle axle = BWMAPI.IMPLEMENTATION.getAxle((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(facing), facing.func_176734_d());
            if (axle != null && axle.getSignal() > this.getSignal()) {
                return 0;
            }
            return this.power;
        }
        return 0;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        return this.maxPower;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return this.getMaximumInput();
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public byte getSignal() {
        return this.signal;
    }

    @Override
    public byte getMaximumSignal() {
        return this.maxSignal;
    }

    @Override
    public int getMaximumInput() {
        return this.maxPower;
    }

    @Override
    public int getMinimumInput() {
        return this.minPower;
    }

    @Override
    public EnumFacing[] getDirections() {
        return ((BlockAxle)this.func_145838_q()).getAxisDirections(this.field_145850_b.func_180495_p(this.field_174879_c));
    }

    @Override
    public EnumFacing.Axis getAxis() {
        if (this.getBlock() instanceof BlockAxle) {
            return ((BlockAxle)this.getBlock()).getAxis(this.field_145850_b.func_180495_p(this.field_174879_c));
        }
        return EnumFacing.Axis.Y;
    }

    public void setSignal(byte signal) {
        this.signal = signal;
    }

    public void setPower(int power) {
        this.power = Math.min(power, this.maxPower + 1);
    }

    public void func_70296_d() {
        super.func_70296_d();
        for (EnumFacing facing : this.getDirections()) {
            if (BWMAPI.IMPLEMENTATION.isAxle((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(facing), facing.func_176734_d())) continue;
            this.field_145850_b.func_190524_a(this.field_174879_c.func_177972_a(facing), this.func_145838_q(), this.field_174879_c);
        }
        this.dirty = false;
    }

    public int getPower() {
        return this.power;
    }

    public String toString() {
        return String.format("%s,%s,%s", this.signal, this.power, this.field_174879_c);
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.func_174877_v();
    }

    @Override
    public Block getBlock() {
        return this.func_145838_q();
    }

    public void func_73660_a() {
        if (!tickHandlers.isEmpty()) {
            tickHandlers.forEach(t -> t.tick(this.field_145850_b, this.field_174879_c, this));
        }
        if (this.dirty) {
            this.func_70296_d();
        }
    }
}

