/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.blocks.BWMBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockStickBase
extends BWMBlock {
    public static final PropertyEnum<Connection> CONNECTION = PropertyEnum.func_177709_a((String)"connection", Connection.class);
    public static final PropertyBool GROUND = PropertyBool.func_177716_a((String)"ground");

    public BlockStickBase(Material material) {
        super(material);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECTION, GROUND});
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        boolean ground = (meta & 1) == 1;
        int connection = meta >> 1;
        return this.func_176223_P().func_177226_a((IProperty)GROUND, (Comparable)Boolean.valueOf(ground)).func_177226_a(CONNECTION, (Comparable)((Object)Connection.VALUES[connection]));
    }

    public int func_176201_c(IBlockState state) {
        int connection = ((Connection)((Object)state.func_177229_b(CONNECTION))).ordinal() << 1;
        int ground = (Boolean)state.func_177229_b((IProperty)GROUND) != false ? 1 : 0;
        return ground | connection;
    }

    public abstract IBlockState getConnections(IBlockState var1, IBlockAccess var2, BlockPos var3);

    public abstract double getHeight(IBlockState var1);

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState newState = state;
        if (worldIn.func_180495_p(pos.func_177977_b()).func_185898_k()) {
            newState = newState.func_177226_a((IProperty)GROUND, (Comparable)Boolean.valueOf(true));
        }
        IBlockState above = worldIn.func_180495_p(pos.func_177984_a());
        Block block = above.func_177230_c();
        return this.getConnections(newState, worldIn, pos);
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing face) {
        return face.func_176740_k() == EnumFacing.Axis.Y ? BlockFaceShape.CENTER_SMALL : BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        double y = this.getHeight(state);
        return new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, y, 0.5625);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    private void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_176196_c(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public static enum Connection implements IStringSerializable
    {
        DISCONNECTED,
        CONNECTED,
        CANDLE,
        SKULL;

        public static Connection[] VALUES;

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            VALUES = Connection.values();
        }
    }
}

