/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common;

import betterwithmods.BWMod;
import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityAxle;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IAxle;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.api.tile.dispenser.IBehaviorEntity;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.advancements.BWAdvancements;
import betterwithmods.common.blocks.BlockBDispenser;
import betterwithmods.common.blocks.BlockUnfiredPottery;
import betterwithmods.common.blocks.behaviors.BehaviorDiodeDispense;
import betterwithmods.common.blocks.behaviors.BehaviorSilkTouch;
import betterwithmods.common.entity.EntityBroadheadArrow;
import betterwithmods.common.entity.EntityDynamite;
import betterwithmods.common.entity.EntityExtendingRope;
import betterwithmods.common.entity.EntityFallingGourd;
import betterwithmods.common.entity.EntityHCFishHook;
import betterwithmods.common.entity.EntityJungleSpider;
import betterwithmods.common.entity.EntityMiningCharge;
import betterwithmods.common.entity.EntityShearedCreeper;
import betterwithmods.common.entity.EntitySpiderWeb;
import betterwithmods.common.entity.EntityUrn;
import betterwithmods.common.entity.item.EntityFallingBlockCustom;
import betterwithmods.common.items.ItemDynamite;
import betterwithmods.common.penalties.PenaltyHandlerRegistry;
import betterwithmods.common.potion.BWPotion;
import betterwithmods.common.potion.PotionSlowfall;
import betterwithmods.common.potion.PotionTruesight;
import betterwithmods.common.registry.BellowsManager;
import betterwithmods.common.registry.HopperFilters;
import betterwithmods.common.registry.KilnStructureManager;
import betterwithmods.common.registry.block.managers.KilnManagerBlock;
import betterwithmods.common.registry.block.managers.SawManagerBlock;
import betterwithmods.common.registry.block.managers.TurntableManagerBlock;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.common.registry.block.recipe.StateIngredient;
import betterwithmods.common.registry.bulk.manager.CookingPotManager;
import betterwithmods.common.registry.bulk.manager.MillManager;
import betterwithmods.common.registry.heat.BWMHeatRegistry;
import betterwithmods.manual.api.API;
import betterwithmods.manual.common.api.ManualDefinitionImpl;
import betterwithmods.module.Feature;
import betterwithmods.module.compat.Quark;
import betterwithmods.module.compat.bop.BiomesOPlenty;
import betterwithmods.module.gameplay.CraftingRecipes;
import betterwithmods.module.gameplay.miniblocks.MiniBlocks;
import betterwithmods.module.hardcore.crafting.HCDiamond;
import betterwithmods.module.hardcore.crafting.HCFishing;
import betterwithmods.module.hardcore.crafting.HCLumber;
import betterwithmods.module.hardcore.crafting.HCOres;
import betterwithmods.module.hardcore.crafting.HCRedstone;
import betterwithmods.module.hardcore.creatures.EntityTentacle;
import betterwithmods.module.hardcore.needs.HCTools;
import betterwithmods.module.hardcore.world.HCTorches;
import betterwithmods.network.BWNetwork;
import betterwithmods.util.DispenserBehaviorDynamite;
import betterwithmods.util.DispenserBlockOverride;
import betterwithmods.util.InvUtils;
import betterwithmods.util.MechanicalUtil;
import betterwithmods.util.ReflectionLib;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="betterwithmods")
public class BWRegistry {
    public static final PenaltyHandlerRegistry PENALTY_HANDLERS = new PenaltyHandlerRegistry();
    public static final CookingPotManager CAULDRON = new CookingPotManager();
    public static final CookingPotManager CRUCIBLE = new CookingPotManager();
    public static final MillManager MILLSTONE = new MillManager();
    public static final SawManagerBlock WOOD_SAW = new SawManagerBlock();
    public static final KilnManagerBlock KILN = new KilnManagerBlock();
    public static final TurntableManagerBlock TURNTABLE = new TurntableManagerBlock();
    public static final HopperFilters HOPPER_FILTERS = new HopperFilters();
    @GameRegistry.ObjectHolder(value="betterwithmods:true_sight")
    public static final Potion POTION_TRUESIGHT = null;
    @GameRegistry.ObjectHolder(value="betterwithmods:fortune")
    public static final Potion POTION_FORTUNE = null;
    @GameRegistry.ObjectHolder(value="betterwithmods:looting")
    public static final Potion POTION_LOOTING = null;
    @GameRegistry.ObjectHolder(value="betterwithmods:slow_fall")
    public static final Potion POTION_SLOWFALL = null;
    private static int availableEntityId = 0;

    public static void preInit() {
        API.manualAPI = ManualDefinitionImpl.INSTANCE;
        BWAdvancements.registerAdvancements();
        BWNetwork.registerNetworking();
        BWMBlocks.registerBlocks();
        BWMItems.registerItems();
        BWMBlocks.registerTileEntities();
        BWRegistry.registerEntities();
        BWRegistry.registerBlockDispenserBehavior();
        CapabilityManager.INSTANCE.register(IMechanicalPower.class, (Capability.IStorage)new CapabilityMechanicalPower.Impl(), CapabilityMechanicalPower.Default::new);
        CapabilityManager.INSTANCE.register(IAxle.class, (Capability.IStorage)new CapabilityAxle.Impl(), CapabilityAxle.Default::new);
        KilnStructureManager.registerKilnBlock(Blocks.field_150336_V.func_176223_P());
        KilnStructureManager.registerKilnBlock(Blocks.field_150385_bj.func_176223_P());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        BWMBlocks.getBlocks().forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        BWMItems.getItems().forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ForgeRegistry reg = (ForgeRegistry)event.getRegistry();
        for (IRecipe recipe : BWMRecipes.getRecipes()) {
            event.getRegistry().register((IForgeRegistryEntry)recipe);
        }
        for (IRecipe recipe : reg) {
            for (Pattern pattern : BWMRecipes.REMOVE_BY_REGEX) {
                Matcher matcher = pattern.matcher(recipe.getRegistryName().toString());
                if (!matcher.matches()) continue;
                reg.remove(recipe.getRegistryName());
            }
            for (ResourceLocation resourceLocation : BWMRecipes.REMOVE_RECIPE_BY_RL) {
                if (!resourceLocation.equals((Object)recipe.getRegistryName())) continue;
                reg.remove(recipe.getRegistryName());
            }
            for (ItemStack itemStack : BWMRecipes.REMOVE_RECIPE_BY_OUTPUT) {
                if (!InvUtils.matches(recipe.func_77571_b(), itemStack)) continue;
                reg.remove(recipe.getRegistryName());
            }
            for (List list : BWMRecipes.REMOVE_RECIPE_BY_INPUT) {
                if (!InvUtils.containsIngredient((List<Ingredient>)recipe.func_192400_c(), list)) continue;
                reg.remove(recipe.getRegistryName());
            }
        }
    }

    public static void init() {
        BWRegistry.registerHeatSources();
        BWOreDictionary.registerOres();
    }

    public static void postInit() {
        BWOreDictionary.postInitOreDictGathering();
        BellowsManager.postInit();
    }

    public static void postPostInit() {
        BWRegistry.registerRecipes();
    }

    private static void registerEntities() {
        BWRegistry.registerEntity(EntityExtendingRope.class, "extending_rope", 64, 20, true);
        BWRegistry.registerEntity(EntityDynamite.class, "bwm_dynamite", 10, 50, true);
        BWRegistry.registerEntity(EntityUrn.class, "bwm_urn", 10, 50, true);
        BWRegistry.registerEntity(EntityMiningCharge.class, "bwm_mining_charge", 10, 50, true);
        BWRegistry.registerEntity(EntityShearedCreeper.class, "entity_sheared_creeper", 64, 1, true);
        BWRegistry.registerEntity(EntityBroadheadArrow.class, "entity_broadhead_arrow", 64, 1, true);
        BWRegistry.registerEntity(EntityFallingGourd.class, "entity_falling_gourd", 64, 1, true);
        BWRegistry.registerEntity(EntityFallingBlockCustom.class, "falling_block_custom", 64, 20, true);
        BWRegistry.registerEntity(EntitySpiderWeb.class, "bwm_spider_web", 64, 20, true);
        BWRegistry.registerEntity(EntityHCFishHook.class, "bwm_fishing_hook", 64, 20, true);
        BWRegistry.registerEntity(EntityTentacle.class, "bwm_tentacle", 64, 1, true);
        BWRegistry.registerEntity(EntityJungleSpider.class, "bwm_jungle_spider", 64, 1, true, 3957810, 6589520);
    }

    public static void registerBlockDispenserBehavior() {
        BlockDispenser.field_149943_a.func_82595_a((Object)BWMItems.DYNAMITE, (Object)new DispenserBehaviorDynamite(ItemDynamite.dispenseLit));
        BlockDispenser.field_149943_a.func_82595_a((Object)BWMItems.DYNAMITE_BUNDLE, (Object)new DispenserBehaviorDynamite(ItemDynamite.dispenseLit));
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a((Object)BWMItems.DYNAMITE, (Object)new DispenserBehaviorDynamite(ItemDynamite.dispenseLit));
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a((Object)BWMItems.DYNAMITE_BUNDLE, (Object)new DispenserBehaviorDynamite(ItemDynamite.dispenseLit));
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a((Object)Items.field_151107_aW, (Object)new BehaviorDiodeDispense());
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a((Object)Items.field_151132_bS, (Object)new BehaviorDiodeDispense());
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a((Object)Items.field_151119_aD, (Object)new DispenserBlockOverride(BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.BRICK)));
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a((Object)Items.field_151119_aD, (Object)new DispenserBlockOverride(BlockUnfiredPottery.getStack(BlockUnfiredPottery.EnumType.BRICK)));
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a((Object)Item.func_150898_a((Block)BWMBlocks.MINING_CHARGE), (source, stack) -> {
            World worldIn = source.func_82618_k();
            EnumFacing facing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            BlockPos pos = source.func_180699_d().func_177972_a(facing);
            EntityMiningCharge miningCharge = new EntityMiningCharge(worldIn, (float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, null, facing);
            miningCharge.func_189654_d(false);
            worldIn.func_72838_d((Entity)miningCharge);
            worldIn.func_184148_a(null, miningCharge.field_70165_t, miningCharge.field_70163_u, miningCharge.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return stack;
        });
        BlockBDispenser.BLOCK_COLLECT_REGISTRY.func_82595_a((Object)Blocks.field_150348_b, (Object)new BehaviorSilkTouch());
        BlockBDispenser.BLOCK_COLLECT_REGISTRY.func_82595_a((Object)Blocks.field_150364_r, (Object)new BehaviorSilkTouch());
        BlockBDispenser.BLOCK_COLLECT_REGISTRY.func_82595_a((Object)Blocks.field_150363_s, (Object)new BehaviorSilkTouch());
        IBehaviorDispenseItem MINECART_DISPENSER_BEHAVIOR = (IBehaviorDispenseItem)ReflectionHelper.getPrivateValue(ItemMinecart.class, null, (String[])ReflectionLib.MINECART_DISPENSER_BEHAVIOR);
        for (Item minecart : Sets.newHashSet((Object[])new Item[]{Items.field_151143_au, Items.field_151108_aI, Items.field_151109_aJ, Items.field_151140_bW, Items.field_151142_bV, Items.field_151095_cc})) {
            BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a((Object)minecart, (Object)MINECART_DISPENSER_BEHAVIOR);
        }
        IBehaviorEntity MINECART_COLLECT_BEHAVIOR = (world, pos, entity, stack) -> {
            IBlockState state;
            EntityMinecart minecart = (EntityMinecart)entity;
            if (minecart instanceof IInventory) {
                InventoryHelper.func_180176_a((World)world, (Entity)minecart, (IInventory)((IInventory)minecart));
            }
            if ((state = minecart.func_174897_t()) == Blocks.field_150470_am.func_176223_P()) {
                state = Blocks.field_150460_al.func_176223_P();
            }
            ItemStack tile = BWMRecipes.getStackFromState(state);
            minecart.func_70106_y();
            return InvUtils.asNonnullList(new ItemStack(Items.field_151143_au), tile);
        };
        for (String name : Sets.newHashSet((Object[])new String[]{"commandblock_minecart", "minecart", "chest_minecart", "furnace_minecart", "tnt_minecart", "hopper_minecart", "spawner_minecart"})) {
            ResourceLocation loc = new ResourceLocation(name);
            BlockBDispenser.ENTITY_COLLECT_REGISTRY.func_82595_a((Object)loc, (Object)MINECART_COLLECT_BEHAVIOR);
        }
        BlockBDispenser.ENTITY_COLLECT_REGISTRY.func_82595_a((Object)new ResourceLocation("minecraft:sheep"), (world, pos, entity, stack) -> {
            EntitySheep sheep = (EntitySheep)entity;
            if (sheep.isShearable(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, pos)) {
                return InvUtils.asNonnullList(sheep.onSheared(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, pos, 0));
            }
            return NonNullList.func_191196_a();
        });
        BlockBDispenser.ENTITY_COLLECT_REGISTRY.func_82595_a((Object)new ResourceLocation("minecraft:chicken"), (world, pos, entity, stack) -> {
            if (((EntityAgeable)entity).func_70631_g_()) {
                return NonNullList.func_191196_a();
            }
            InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.field_151008_G, 1 + world.field_73012_v.nextInt(2)));
            world.func_184133_a(null, pos, SoundEvents.field_187666_Z, SoundCategory.NEUTRAL, 0.75f, 1.0f);
            entity.func_70106_y();
            return InvUtils.asNonnullList(new ItemStack(Items.field_151110_aK));
        });
        BlockBDispenser.ENTITY_COLLECT_REGISTRY.func_82595_a((Object)new ResourceLocation("minecraft:cow"), (world, pos, entity, stack) -> {
            if (((EntityAgeable)entity).func_70631_g_()) {
                return NonNullList.func_191196_a();
            }
            if (stack.func_77969_a(new ItemStack(Items.field_151133_ar))) {
                stack.func_190918_g(1);
                world.func_184133_a(null, pos, SoundEvents.field_187564_an, SoundCategory.BLOCKS, 1.0f, 1.0f);
                InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.field_151117_aB));
            }
            return NonNullList.func_191196_a();
        });
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("betterwithmods", entityName), entityClass, (String)entityName, (int)availableEntityId, (Object)BWMod.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        ++availableEntityId;
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int primaryColor, int secondaryColor) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("betterwithmods", entityName), entityClass, (String)entityName, (int)availableEntityId, (Object)BWMod.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)primaryColor, (int)secondaryColor);
        ++availableEntityId;
    }

    public static void registerHeatSources() {
        BWMHeatRegistry.addHeatSource(new StateIngredient((Block)Blocks.field_150480_ab, Items.field_190931_a), 1);
        BWMHeatRegistry.addHeatSource(new StateIngredient(BWMBlocks.STOKED_FLAME, Items.field_190931_a), 2);
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().register((IForgeRegistryEntry)BWRegistry.registerPotion(new PotionTruesight("true_sight", true, 14270531).func_76399_b(4, 1)));
        event.getRegistry().register((IForgeRegistryEntry)BWRegistry.registerPotion(new BWPotion("fortune", true, 14270531).func_76399_b(5, 2)));
        event.getRegistry().register((IForgeRegistryEntry)BWRegistry.registerPotion(new BWPotion("looting", true, 14270531).func_76399_b(6, 2)));
        event.getRegistry().register((IForgeRegistryEntry)BWRegistry.registerPotion(new PotionSlowfall("slow_fall", true, 16019232).func_76399_b(4, 1)));
    }

    private static Potion registerPotion(Potion potion) {
        String potionName = potion.getRegistryName().func_110623_a();
        potion.func_76390_b("bwm.effect." + potionName);
        return potion;
    }

    private static void registerFireInfo() {
        Blocks.field_150480_ab.func_180686_a(BWMBlocks.WOODEN_AXLE, 5, 20);
        Blocks.field_150480_ab.func_180686_a(BWMBlocks.WOODEN_BROKEN_GEARBOX, 5, 20);
        Blocks.field_150480_ab.func_180686_a(BWMBlocks.WOODEN_GEARBOX, 5, 20);
        Blocks.field_150480_ab.func_180686_a(BWMBlocks.WINDMILL, 5, 20);
        Blocks.field_150480_ab.func_180686_a(BWMBlocks.WATERWHEEL, 5, 20);
        Blocks.field_150480_ab.func_180686_a(BWMBlocks.VINE_TRAP, 5, 20);
        BWRegistry.registerFireInfo(new BlockIngredient("blockCandle"), 5, 20);
        BWRegistry.registerFireInfo(new BlockIngredient("slats"), 5, 20);
        BWRegistry.registerFireInfo(new BlockIngredient("grates"), 5, 20);
    }

    public static void registerFireInfo(BlockIngredient ingredient, int encouragement, int flammability) {
        for (IBlockState state : ingredient.getStates()) {
            Blocks.field_150480_ab.func_180686_a(state.func_177230_c(), encouragement, flammability);
        }
    }

    public static void registerRecipes() {
        ForgeRegistry reg = (ForgeRegistry)ForgeRegistries.RECIPES;
        BWRegistry.replaceIRecipe(CraftingRecipes.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(HCTools.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(HCDiamond.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(HCLumber.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(HCOres.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(HCRedstone.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(HCTorches.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(HCFishing.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(MiniBlocks.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(BiomesOPlenty.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(Quark.class, (IForgeRegistry<IRecipe>)reg);
    }

    private static void retrieveRecipes(String category, ForgeRegistry<IRecipe> reg) {
        List<IRecipe> recipes = BWMRecipes.getHardcoreRecipes(category);
        if (recipes != null) {
            for (IRecipe recipe : recipes) {
                ResourceLocation location = recipe.getRegistryName();
                if (reg.containsKey(location)) {
                    BWRegistry.registerReplacements((IRecipe)reg.getValue(location), recipe);
                    continue;
                }
                reg.register((IForgeRegistryEntry)recipe);
            }
        }
    }

    private static void replaceIRecipe(Class<? extends Feature> clazz, IForgeRegistry<IRecipe> reg) {
        List<IRecipe> recipes = BWMRecipes.getHardcoreRecipes(clazz.getSimpleName());
        if (recipes != null) {
            recipes.forEach(arg_0 -> reg.register(arg_0));
        }
    }

    private static void registerReplacements(IRecipe original, IRecipe from) {
        NonNullList ing = original.func_192400_c();
        for (int i = 0; i < ing.size(); ++i) {
            ing.set(i, from.func_192400_c().get(i));
        }
    }

    static {
        BWMAPI.IMPLEMENTATION = new MechanicalUtil();
    }
}

