/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.api.recipe.impl;

import betterwithmods.api.recipe.IOutput;
import betterwithmods.api.recipe.IRecipeOutputs;
import betterwithmods.api.recipe.impl.RandomOutput;
import betterwithmods.api.recipe.impl.StackOutput;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class RandomCountOutputs
implements IRecipeOutputs {
    private List<RandomOutput> outputs;
    private List<ItemStack> itemStackList;

    public RandomCountOutputs(RandomOutput ... outputs) {
        this(Lists.newArrayList((Object[])outputs));
    }

    public RandomCountOutputs(List<RandomOutput> outputs) {
        this.outputs = outputs;
        this.itemStackList = outputs.stream().map(StackOutput::getOutput).collect(Collectors.toList());
    }

    @Override
    public List<IOutput> getDisplayOutputs() {
        return this.cast(this.outputs);
    }

    @Override
    public NonNullList<ItemStack> getOutputs() {
        return this.findResult();
    }

    @Override
    public boolean matches(List<ItemStack> outputs) {
        return InvUtils.matchesExact(outputs, this.itemStackList);
    }

    @Override
    public boolean matchesFuzzy(List<ItemStack> outputs) {
        return InvUtils.matches(outputs, this.itemStackList);
    }

    @Override
    public boolean isInvalid() {
        return this.outputs.isEmpty();
    }

    private NonNullList<ItemStack> findResult() {
        return InvUtils.asNonnullList(this.outputs.stream().map(RandomOutput::getRandomStack).collect(Collectors.toList()));
    }
}

