/*
 * Decompiled with CFR 0.152.
 */
package lykrast.defiledlands.common.init;

import java.util.ArrayList;
import java.util.List;
import lykrast.defiledlands.client.render.entity.RenderBlastemFruit;
import lykrast.defiledlands.client.render.entity.RenderBlastemFruitBlazing;
import lykrast.defiledlands.client.render.entity.RenderBookWyrm;
import lykrast.defiledlands.client.render.entity.RenderDestroyer;
import lykrast.defiledlands.client.render.entity.RenderHost;
import lykrast.defiledlands.client.render.entity.RenderMourner;
import lykrast.defiledlands.client.render.entity.RenderRavagerProjectile;
import lykrast.defiledlands.client.render.entity.RenderScuttler;
import lykrast.defiledlands.client.render.entity.RenderShambler;
import lykrast.defiledlands.client.render.entity.RenderShamblerTwisted;
import lykrast.defiledlands.client.render.entity.RenderSlimeDefiled;
import lykrast.defiledlands.common.entity.boss.EntityDestroyer;
import lykrast.defiledlands.common.entity.boss.EntityMourner;
import lykrast.defiledlands.common.entity.monster.EntityHost;
import lykrast.defiledlands.common.entity.monster.EntityScuttler;
import lykrast.defiledlands.common.entity.monster.EntityShambler;
import lykrast.defiledlands.common.entity.monster.EntityShamblerTwisted;
import lykrast.defiledlands.common.entity.monster.EntitySlimeDefiled;
import lykrast.defiledlands.common.entity.passive.EntityBookWyrm;
import lykrast.defiledlands.common.entity.projectile.EntityBlastemFruit;
import lykrast.defiledlands.common.entity.projectile.EntityBlastemFruitBlazing;
import lykrast.defiledlands.common.entity.projectile.EntityRavagerProjectile;
import lykrast.defiledlands.common.init.ModItems;
import lykrast.defiledlands.common.util.DungeonDefiledList;
import lykrast.defiledlands.common.world.feature.WorldGenDungeonsDefiled;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ModEntities {
    private static int id = 1;
    private static List<EntityEntry> entityList = new ArrayList<EntityEntry>();

    public static void init() {
        ModEntities.registerEntity(EntityShambler.class, "shambler", 0x171717, 0xEBEBEB);
        LootTableList.func_186375_a((ResourceLocation)EntityShambler.LOOT);
        ModEntities.registerEntity(EntityShamblerTwisted.class, "shambler_twisted", 0x171717, 16133678);
        LootTableList.func_186375_a((ResourceLocation)EntityShamblerTwisted.LOOT);
        ModEntities.registerEntity(EntityScuttler.class, "scuttler", 2168867, 13503487);
        LootTableList.func_186375_a((ResourceLocation)EntityScuttler.LOOT);
        ModEntities.registerEntity(EntityHost.class, "host", 0x3A3A3A, 13136800);
        LootTableList.func_186375_a((ResourceLocation)EntityHost.LOOT);
        ModEntities.registerEntity(EntitySlimeDefiled.class, "slime_defiled", 12479889, 13136800);
        LootTableList.func_186375_a((ResourceLocation)EntitySlimeDefiled.LOOT);
        ModEntities.registerEntity(EntityBookWyrm.class, "book_wyrm", 4271169, 16710116);
        LootTableList.func_186375_a((ResourceLocation)EntityBookWyrm.LOOT);
        ModEntities.registerEntity(EntityDestroyer.class, "the_destroyer", 0xA9A9A9, 0xF9F9F9);
        LootTableList.func_186375_a((ResourceLocation)EntityDestroyer.LOOT);
        ModEntities.registerEntity(EntityMourner.class, "the_mourner", 0x262626, 0xF9F9F9);
        LootTableList.func_186375_a((ResourceLocation)EntityMourner.LOOT);
        ModEntities.registerProjectile(EntityBlastemFruit.class, "blastem_fruit");
        ModEntities.registerProjectile(EntityBlastemFruitBlazing.class, "blastem_fruit_blazing");
        ModEntities.registerProjectile(EntityRavagerProjectile.class, "ravager_projectile", 3);
        DungeonDefiledList.addDungeonMob("scuttler", 160);
        DungeonDefiledList.addDungeonMob("host", 120);
        DungeonDefiledList.addDungeonMob("shambler_twisted", 20);
        LootTableList.func_186375_a((ResourceLocation)WorldGenDungeonsDefiled.LOOT);
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        for (EntityEntry e : entityList) {
            event.getRegistry().register((IForgeRegistryEntry)e);
        }
        entityList = null;
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String name, int colorBack, int colorFront) {
        EntityEntryBuilder builder = EntityEntryBuilder.create().entity(entityClass).name("defiledlands." + name).id(new ResourceLocation("defiledlands", name), id++).tracker(64, 3, true).egg(colorBack, colorFront);
        entityList.add(builder.build());
    }

    public static void registerProjectile(Class<? extends Entity> entityClass, String name) {
        ModEntities.registerProjectile(entityClass, name, 10);
    }

    public static void registerProjectile(Class<? extends Entity> entityClass, String name, int updateRate) {
        EntityEntryBuilder builder = EntityEntryBuilder.create().entity(entityClass).name("defiledlands." + name).id(new ResourceLocation("defiledlands", name), id++).tracker(64, updateRate, true);
        entityList.add(builder.build());
    }

    @SideOnly(value=Side.CLIENT)
    public static void initModels() {
        RenderingRegistry.registerEntityRenderingHandler(EntityShambler.class, RenderShambler::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityShamblerTwisted.class, RenderShamblerTwisted::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityScuttler.class, RenderScuttler::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityDestroyer.class, RenderDestroyer::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityMourner.class, RenderMourner::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHost.class, RenderHost::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySlimeDefiled.class, RenderSlimeDefiled::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBookWyrm.class, RenderBookWyrm::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBlastemFruit.class, m -> new RenderBlastemFruit(m, ModItems.blastemFruit, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityBlastemFruitBlazing.class, m -> new RenderBlastemFruitBlazing(m, ModItems.blastemFruitBlazing, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityRavagerProjectile.class, m -> new RenderRavagerProjectile(m, ModItems.pelletUmbrium, Minecraft.func_71410_x().func_175599_af()));
    }
}

