/*
 * Decompiled with CFR 0.152.
 */
package lykrast.defiledlands.common.entity.projectile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityBlastemFruit
extends EntityThrowable {
    protected float damage = 7.0f;
    protected float explosion = 1.0f;
    protected boolean destructive = true;

    public EntityBlastemFruit(World worldIn) {
        super(worldIn);
    }

    public EntityBlastemFruit(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
    }

    public EntityBlastemFruit(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.field_72308_g != null) {
            result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.damage);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.explosion(false);
            this.func_70106_y();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void explosion(boolean isFlaming) {
        final ExplosionBlastem explosion = new ExplosionBlastem(this.field_70170_p, this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosion, isFlaming, this.destructive);
        if (!ForgeEventFactory.onExplosionStart((World)this.field_70170_p, (Explosion)explosion)) {
            Object listener = new Object(){

                @SubscribeEvent
                public void onDetonate(ExplosionEvent.Detonate event) {
                    if (event.getExplosion() == explosion) {
                        event.getAffectedEntities().removeIf(ent -> ent instanceof EntityItem);
                    }
                }
            };
            try {
                MinecraftForge.EVENT_BUS.register(listener);
                explosion.func_77278_a();
            }
            finally {
                MinecraftForge.EVENT_BUS.unregister(listener);
            }
            explosion.func_77279_a(false);
        }
        if (!this.destructive) {
            explosion.func_180342_d();
        }
        for (EntityPlayer entityplayer : this.field_70170_p.field_73010_i) {
            if (!(entityplayer.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v) < 4096.0)) continue;
            ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)new SPacketExplosion(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosion, explosion.func_180343_e(), (Vec3d)explosion.func_77277_b().get(entityplayer)));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("damage", this.damage);
        compound.func_74776_a("explosion", this.explosion);
        compound.func_74757_a("destructive", this.destructive);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74760_g("damage");
        }
        if (compound.func_150297_b("explosion", 99)) {
            this.explosion = compound.func_74760_g("explosion");
        }
        if (compound.func_150297_b("destructive", 99)) {
            this.destructive = compound.func_74767_n("destructive");
        }
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setExplosionStrength(float explosion) {
        this.explosion = explosion;
    }

    public float getExplosionStrength() {
        return this.explosion;
    }

    public void setDestructive(boolean destructive) {
        this.destructive = destructive;
    }

    public boolean isDestructive() {
        return this.destructive;
    }

    public static class ExplosionBlastem
    extends Explosion {
        private EntityBlastemFruit projectile;

        public ExplosionBlastem(World worldIn, EntityBlastemFruit entityIn, double x, double y, double z, float size, boolean flaming, boolean damagesTerrain) {
            super(worldIn, (Entity)entityIn, x, y, z, size, flaming, damagesTerrain);
            this.projectile = entityIn;
        }

        public EntityLivingBase func_94613_c() {
            return this.projectile.func_85052_h();
        }

        public void func_77279_a(boolean spawnParticles) {
            super.func_77279_a(spawnParticles);
        }
    }
}

