/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.pyrotech_compat.world;

import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.block.BlockRock;
import exterminatorjeff.undergroundbiomes.api.UBBiome;
import exterminatorjeff.undergroundbiomes.api.UBStrataColumn;
import exterminatorjeff.undergroundbiomes.api.UBStrataColumnProvider;
import exterminatorjeff.undergroundbiomes.api.UndergroundBiomeSet;
import exterminatorjeff.undergroundbiomes.api.enums.UBStoneType;
import exterminatorjeff.undergroundbiomes.common.block.UBStone;
import exterminatorjeff.undergroundbiomes.world.noise.NoiseGenerator;
import exterminatorjeff.undergroundbiomes.world.noise.SimplexNoiseGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.layer.GenLayer;
import trinsdar.pyrotech_compat.block.rocks.BlockRockBase;
import trinsdar.pyrotech_compat.block.rocks.BlockRockIgneous;
import trinsdar.pyrotech_compat.block.rocks.BlockRockMetamorphic;
import trinsdar.pyrotech_compat.init.BlockInitializer;

public class UBRockReplacer
implements UBStrataColumnProvider {
    private GenLayer undergroundBiomeIndexLayer;
    final UBBiome[] biomeList;
    final NoiseGenerator noiseGenerator;

    public UBRockReplacer(long seed, int size, UndergroundBiomeSet biomeSet) {
        this.biomeList = biomeSet.allowedBiomes();
        this.noiseGenerator = new SimplexNoiseGenerator(seed);
    }

    public void replaceStoneInChunk(Chunk chunk) {
        int[] biomeValues = this.getBiomeValues(chunk);
        int xPos = chunk.func_76632_l().field_77276_a * 16;
        int zPos = chunk.func_76632_l().field_77275_b * 16;
        for (ExtendedBlockStorage storage : chunk.func_76587_i()) {
            if (storage == null || storage.func_76663_a()) continue;
            int yPos = storage.func_76662_d();
            if (yPos < chunk.func_177412_p().func_181545_F()) {
                return;
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    UBBiome currentBiome = this.biomeList[biomeValues[x * 16 + z]];
                    if (currentBiome == null) {
                        throw new RuntimeException("" + biomeValues[x * 16 + z]);
                    }
                    int variation = (int)(this.noiseGenerator.noise((double)(xPos + x) / 55.533, (double)(zPos + z) / 55.533, 3, 1.0, 0.5) * 10.0 - 5.0);
                    for (int y = 0; y < 16; ++y) {
                        UBStone block;
                        IBlockState replaceBlock;
                        IBlockState strata;
                        IBlockState currentBlockState = storage.func_177485_a(x, y, z);
                        Block currentBlock = currentBlockState.func_177230_c();
                        BlockPos currentBlockPos = new BlockPos(x, y, z);
                        if (Block.func_149680_a((Block)Blocks.field_150350_a, (Block)currentBlock) || Block.func_149680_a((Block)Blocks.field_150355_j, (Block)currentBlock) || currentBlock instanceof BlockRockBase || currentBlock != ModuleCore.Blocks.ROCK || !((strata = currentBiome.getStrataBlockAtLayer(yPos + y)).func_177230_c() instanceof UBStone) || (replaceBlock = this.stoneFor((block = (UBStone)strata.func_177230_c()).getStoneType(), block.func_176201_c(strata))) == null) continue;
                        storage.func_177484_a(x, y, z, replaceBlock);
                    }
                }
            }
        }
    }

    private IBlockState stoneFor(UBStoneType type, int meta) {
        switch (type) {
            case IGNEOUS: {
                return BlockInitializer.blockRockIgneous.func_176223_P().func_177226_a(BlockRockIgneous.VARIANT, (Comparable)((Object)BlockRockIgneous.EnumType.fromMeta(meta)));
            }
            case METAMORPHIC: {
                return BlockInitializer.blockRockMetamorphic.func_176223_P().func_177226_a(BlockRockMetamorphic.VARIANT, (Comparable)((Object)BlockRockMetamorphic.EnumType.fromMeta(meta)));
            }
            case SEDIMENTARY: {
                if (meta == 0) {
                    return ModuleCore.Blocks.ROCK.func_176223_P().func_177226_a(BlockRock.VARIANT, (Comparable)BlockRock.EnumType.LIMESTONE);
                }
                if (meta < 4) {
                    return BlockInitializer.blockRockIgneous.func_176223_P().func_177226_a(BlockRockIgneous.VARIANT, (Comparable)((Object)BlockRockIgneous.EnumType.fromMeta(meta - 1)));
                }
                if (meta == 4) {
                    return null;
                }
                return BlockInitializer.blockRockIgneous.func_176223_P().func_177226_a(BlockRockIgneous.VARIANT, (Comparable)((Object)BlockRockIgneous.EnumType.fromMeta(meta - 2)));
            }
        }
        return null;
    }

    public int[] getBiomeValues(Chunk chunk) {
        int[] var7 = this.undergroundBiomeIndexLayer.func_75904_a(chunk.func_76632_l().field_77276_a * 16, chunk.func_76632_l().field_77275_b * 16, 16, 16);
        return var7;
    }

    public UBStrataColumn strataColumn(int i, int i1) {
        return null;
    }
}

