/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.pyrotech_compat.world;

import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.pyrotech.modules.worldgen.ModuleWorldGenConfig;
import exterminatorjeff.undergroundbiomes.config.ConfigManager;
import exterminatorjeff.undergroundbiomes.config.UBConfig;
import java.io.File;
import java.util.HashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import trinsdar.pyrotech_compat.PyrotechCompat;
import trinsdar.pyrotech_compat.world.WorldGenManager;

public class DimensionManager {
    public HashMap<Integer, WorldGenManager> managers = new HashMap();
    private boolean villageRegistered = false;
    private boolean oreRegistered = false;
    private ConfigManager configManager;

    public DimensionManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void refreshManagers() {
        this.managers = new HashMap();
        ((UBConfig)UBConfig.SPECIFIC).getUBifiedDimensions().forEach(dimensionID -> {
            if (this.isAllowedDimension((int)dimensionID, ModuleWorldGenConfig.ROCKS.DIMENSION_WHITELIST, ModuleWorldGenConfig.ROCKS.DIMENSION_BLACKLIST)) {
                WorldGenManager manager = new WorldGenManager((int)dimensionID);
                MinecraftForge.EVENT_BUS.register((Object)manager);
                this.managers.put((Integer)dimensionID, manager);
            }
        });
    }

    private boolean isAllowedDimension(int dimensionId, int[] whitelist, int[] blacklist) {
        if (whitelist.length > 0) {
            return ArrayHelper.containsInt((int[])whitelist, (int)dimensionId);
        }
        if (blacklist.length > 0) {
            return !ArrayHelper.containsInt((int[])blacklist, (int)dimensionId);
        }
        return true;
    }

    public void serverLoad(MinecraftServer server) {
        if (server == null) {
            return;
        }
        PyrotechCompat.logger.info("server starting via server");
        File worldSaveDirectory = null;
        String worldName = server.func_71270_I();
        if (server.func_71264_H()) {
            File saveDirectory = server.func_71209_f("saves");
            worldSaveDirectory = new File(saveDirectory, worldName);
        } else {
            PropertyManager settings = new PropertyManager(server.func_71209_f("server.properties"));
            worldName = settings.func_73671_a("level-name", worldName);
            worldSaveDirectory = server.func_71209_f(worldName);
        }
        WorldServer worldServer = server.func_71218_a(0);
        File worldLocation = worldServer.getChunkSaveLocation();
        this.configManager.setWorldFile(worldLocation);
        this.refreshManagers();
    }

    public void clearWorldManagers() {
        this.managers.clear();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        int dimension;
        WorldGenManager target;
        if (this.managers.size() == 0) {
            this.serverLoad(event.getWorld().func_73046_m());
        }
        if ((target = this.managers.get(dimension = event.getWorld().field_73011_w.getDimension())) != null) {
            target.onWorldLoad(event);
        }
    }

    @SubscribeEvent
    public void onPopulateChunkPost(PopulateChunkEvent.Post event) {
        int dimension = event.getWorld().field_73011_w.getDimension();
        WorldGenManager target = this.managers.get(dimension);
        if (target != null) {
            target.onPopulateChunkPost(event);
        }
    }
}

