/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.pyrotech_compat.init;

import exterminatorjeff.undergroundbiomes.config.ConfigManager;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import trinsdar.pyrotech_compat.PyrotechCompat;
import trinsdar.pyrotech_compat.world.DimensionManager;

public class UBCWorldgenInit {
    private ConfigManager configManager;
    private DimensionManager dimensionManager;
    private ArrayList<Runnable> oneShotServerCloseActions = new ArrayList();
    private ArrayList<Runnable> serverCloseActions = new ArrayList();

    public void preInit(FMLPreInitializationEvent event) {
        this.configManager = new ConfigManager(event);
        this.dimensionManager = new DimensionManager(this.configManager);
    }

    public void postInit(FMLPostInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this.dimensionManager);
    }

    public void serverLoad(FMLServerAboutToStartEvent event) {
        PyrotechCompat.logger.info("server starting via event");
        File worldSaveDirectory = null;
        String worldName = event.getServer().func_71270_I();
        if (event.getServer().func_71264_H()) {
            File saveDirectory = event.getServer().func_71209_f("saves");
            worldSaveDirectory = new File(saveDirectory, worldName);
        } else {
            PropertyManager settings = new PropertyManager(event.getServer().func_71209_f("server.properties"));
            worldName = settings.func_73671_a("level-name", worldName);
            worldSaveDirectory = event.getServer().func_71209_f(worldName);
        }
        WorldServer server = event.getServer().func_71218_a(0);
        File worldLocation = server.getChunkSaveLocation();
        this.configManager.setWorldFile(worldLocation);
        this.dimensionManager.refreshManagers();
    }

    public void onServerStopped(FMLServerStoppedEvent event) {
        this.dimensionManager.clearWorldManagers();
    }

    public void runOnServerClose(Runnable action) {
        this.serverCloseActions.add(action);
    }

    public void runOnNextServerCloseOnly(Runnable action) {
        this.serverCloseActions.add(action);
    }
}

