/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.pyrotech_compat.init;

import com.codetaylor.mc.pyrotech.ModPyrotech;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.block.BlockRock;
import com.codetaylor.mc.pyrotech.modules.core.item.ItemMaterial;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.CompactingBinRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.KilnPitRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.BrickKilnRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.MechanicalCompactingBinRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.StoneKilnRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import trinsdar.pyrotech_compat.block.rocks.BlockRockIgneous;
import trinsdar.pyrotech_compat.block.rocks.BlockRockMetamorphic;
import trinsdar.pyrotech_compat.block.rocks.BlockRockSedimentary;
import trinsdar.pyrotech_compat.init.BlockInitializer;

public class RecipeInitializer {
    static List<AnvilRecipe> anvilRecipes = new ArrayList<AnvilRecipe>();
    static List<KilnPitRecipe> kilnPitRecipes = new ArrayList<KilnPitRecipe>();
    static List<StoneKilnRecipe> stoneKilnRecipes = new ArrayList<StoneKilnRecipe>();
    static List<CompactingBinRecipe> compactingBinRecipes = new ArrayList<CompactingBinRecipe>();

    public static void init() {
        RecipeInitializer.initCompactor((IForgeRegistryModifiable<CompactingBinRecipe>)ModuleTechBasic.Registries.COMPACTING_BIN_RECIPE);
        RecipeInitializer.initKilnPit((IForgeRegistryModifiable<KilnPitRecipe>)ModuleTechBasic.Registries.KILN_PIT_RECIPE);
        RecipeInitializer.initAnvil((IForgeRegistryModifiable<AnvilRecipe>)ModuleTechBasic.Registries.ANVIL_RECIPE);
        RecipeInitializer.registerInheritedRecipes();
    }

    public static void initAnvil(IForgeRegistryModifiable<AnvilRecipe> registry) {
        for (int i = 0; i < 8; ++i) {
            registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(RecipeInitializer.getUBC("igneous", "cobble", i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("igneous", "stone", i)}), 8, AnvilRecipe.EnumType.HAMMER, AnvilRecipe.EnumTier.GRANITE, BlockRockIgneous.EnumType.fromMeta(i).func_176610_l().replace("rock_", "") + "_stone_to_cobbled"));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(new ItemStack((Item)BlockInitializer.itemRockIgneous, 8, i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("igneous", "cobble", i)}), 8, AnvilRecipe.EnumType.HAMMER, AnvilRecipe.EnumTier.GRANITE, BlockRockIgneous.EnumType.fromMeta(i).func_176610_l().replace("rock_", "") + "_cobblestone_to_rocks"));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(RecipeInitializer.getUBC("igneous", "brick_halfslab", 2, i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("igneous", "brick", i)}), 8, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.GRANITE, BlockRockIgneous.EnumType.fromMeta(i).func_176610_l().replace("rock_", "") + "_brick_slab"));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(RecipeInitializer.getUBC("igneous", "stone_halfslab", 2, i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("igneous", "stone", i)}), 8, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.GRANITE, BlockRockIgneous.EnumType.fromMeta(i).func_176610_l().replace("rock_", "") + "_stone_slab"));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(RecipeInitializer.getUBC("igneous", "cobble_halfslab", 2, i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("igneous", "cobble", i)}), 8, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.GRANITE, BlockRockIgneous.EnumType.fromMeta(i).func_176610_l().replace("rock_", "") + "_cobble_slab"));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(ItemMaterial.EnumType.BRICK_STONE.asStack(2), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("igneous", "brick_halfslab", 2, i)}), 4, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.GRANITE, "brick_stone_from_" + BlockRockIgneous.EnumType.fromMeta(i).func_176610_l().replace("rock_", "") + "_brick_slab"));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(RecipeInitializer.getUBC("metamorphic", "cobble", i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("metamorphic", "stone", i)}), 8, AnvilRecipe.EnumType.HAMMER, AnvilRecipe.EnumTier.GRANITE, BlockRockMetamorphic.EnumType.fromMeta(i).func_176610_l().replace("rock_", "") + "_stone_to_cobbled"));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(new ItemStack((Item)BlockInitializer.itemRockMetamorphic, 8, i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("metamorphic", "cobble", i)}), 8, AnvilRecipe.EnumType.HAMMER, AnvilRecipe.EnumTier.GRANITE, BlockRockMetamorphic.EnumType.fromMeta(i).func_176610_l().replace("rock_", "") + "_cobblestone_to_rocks"));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(RecipeInitializer.getUBC("metamorphic", "brick_halfslab", 2, i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("metamorphic", "brick", i)}), 8, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.GRANITE, BlockRockMetamorphic.EnumType.fromMeta(i).func_176610_l().replace("rock_", "") + "_brick_slab"));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(RecipeInitializer.getUBC("metamorphic", "stone_halfslab", 2, i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("metamorphic", "stone", i)}), 8, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.GRANITE, BlockRockMetamorphic.EnumType.fromMeta(i).func_176610_l().replace("rock_", "") + "_stone_slab"));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(RecipeInitializer.getUBC("metamorphic", "cobble_halfslab", 2, i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("metamorphic", "cobble", i)}), 8, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.GRANITE, BlockRockMetamorphic.EnumType.fromMeta(i).func_176610_l().replace("rock_", "") + "_cobble_slab"));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(ItemMaterial.EnumType.BRICK_STONE.asStack(2), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("metamorphic", "brick_halfslab", i)}), 4, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.GRANITE, "brick_stone_from_" + BlockRockMetamorphic.EnumType.fromMeta(i).func_176610_l().replace("rock_", "") + "_brick_slab"));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(RecipeInitializer.getUBC("sedimentary", "stone_halfslab", 2, i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("sedimentary", "stone", i)}), 8, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.GRANITE, RecipeInitializer.getSedimentaryName(i) + "_stone_slab"));
            if (i == 4) continue;
            if (i == 0) {
                registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(new ItemStack((Block)ModuleCore.Blocks.ROCK, 8, BlockRock.EnumType.LIMESTONE.getMeta()), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("sedimentary", "stone", i)}), 8, AnvilRecipe.EnumType.HAMMER, AnvilRecipe.EnumTier.GRANITE, RecipeInitializer.getSedimentaryName(i) + "_stone_to_rocks"));
                continue;
            }
            if (i < 4) {
                registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(new ItemStack((Item)BlockInitializer.itemRockSedimentary, 8, i - 1), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("sedimentary", "stone", i)}), 8, AnvilRecipe.EnumType.HAMMER, AnvilRecipe.EnumTier.GRANITE, RecipeInitializer.getSedimentaryName(i) + "_stone_to_rocks"));
                continue;
            }
            registry.register((IForgeRegistryEntry)RecipeInitializer.createAnvilRecipe(new ItemStack((Item)BlockInitializer.itemRockSedimentary, 8, i - 2), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("sedimentary", "stone", i)}), 8, AnvilRecipe.EnumType.HAMMER, AnvilRecipe.EnumTier.GRANITE, RecipeInitializer.getSedimentaryName(i) + "_stone_to_rocks"));
        }
    }

    public static void initKilnPit(IForgeRegistryModifiable<KilnPitRecipe> registry) {
        for (int i = 0; i < 8; ++i) {
            registry.register((IForgeRegistryEntry)RecipeInitializer.createKilnPitRecipe(RecipeInitializer.getUBC("igneous", "stone_halfslab", i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("igneous", "cobble_halfslab", i)}), new ItemStack[]{ItemMaterial.EnumType.PIT_ASH.asStack(), new ItemStack((Block)BlockInitializer.blockRockIgneous, 5, i)}, "stone_slab" + BlockRockIgneous.EnumType.fromMeta(i).func_176610_l().replace("rock", "")));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createKilnPitRecipe(RecipeInitializer.getUBC("igneous", "stone", i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("igneous", "cobble", i)}), new ItemStack[]{ItemMaterial.EnumType.PIT_ASH.asStack(), new ItemStack((Block)BlockInitializer.blockRockIgneous, 5, i)}, "stone" + BlockRockIgneous.EnumType.fromMeta(i).func_176610_l().replace("rock", "")));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createKilnPitRecipe(RecipeInitializer.getUBC("metamorphic", "stone_halfslab", i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("metamorphic", "cobble_halfslab", i)}), new ItemStack[]{ItemMaterial.EnumType.PIT_ASH.asStack(), new ItemStack((Block)BlockInitializer.blockRockMetamorphic, 5, i)}, "stone_slab" + BlockRockMetamorphic.EnumType.fromMeta(i).func_176610_l().replace("rock", "")));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createKilnPitRecipe(RecipeInitializer.getUBC("metamorphic", "stone", i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeInitializer.getUBC("metamorphic", "cobble", i)}), new ItemStack[]{ItemMaterial.EnumType.PIT_ASH.asStack(), new ItemStack((Block)BlockInitializer.blockRockMetamorphic, 5, i)}, "stone" + BlockRockMetamorphic.EnumType.fromMeta(i).func_176610_l().replace("rock", "")));
        }
    }

    public static void initCompactor(IForgeRegistryModifiable<CompactingBinRecipe> registry) {
        for (int i = 0; i < 8; ++i) {
            registry.register((IForgeRegistryEntry)RecipeInitializer.createCompactingBinRecipe(RecipeInitializer.getUBCGravel("igneous", i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)BlockInitializer.itemRockIgneous, 1, i)}), 8, "igneous_gravel_" + BlockRockIgneous.EnumType.fromMeta(i).func_176610_l().replace("rock_", "")));
            registry.register((IForgeRegistryEntry)RecipeInitializer.createCompactingBinRecipe(RecipeInitializer.getUBCGravel("metamorphic", i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)BlockInitializer.itemRockMetamorphic, 1, i)}), 8, "metamorphic_gravel_" + BlockRockMetamorphic.EnumType.fromMeta(i).func_176610_l().replace("rock_", "")));
            if (i == 0) {
                registry.register((IForgeRegistryEntry)RecipeInitializer.createCompactingBinRecipe(RecipeInitializer.getUBCGravel("sedimentary", i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)ModuleCore.Blocks.ROCK, 1, BlockRock.EnumType.LIMESTONE.getMeta())}), 8, "sedimentary_gravel_limestone"));
                continue;
            }
            if (i < 4) {
                registry.register((IForgeRegistryEntry)RecipeInitializer.createCompactingBinRecipe(RecipeInitializer.getUBCGravel("sedimentary", i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)BlockInitializer.itemRockSedimentary, 1, i - 1)}), 8, "sedimentary_gravel_" + BlockRockSedimentary.EnumType.fromMeta(i - 1).func_176610_l().replace("rock_", "")));
                continue;
            }
            if (i == 4) continue;
            registry.register((IForgeRegistryEntry)RecipeInitializer.createCompactingBinRecipe(RecipeInitializer.getUBCGravel("sedimentary", i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)BlockInitializer.itemRockSedimentary, 1, i - 2)}), 8, "sedimentary_gravel_" + BlockRockSedimentary.EnumType.fromMeta(i - 2).func_176610_l().replace("rock_", "")));
        }
    }

    public static String getSedimentaryName(int meta) {
        if (meta == 0) {
            return "limestone";
        }
        if (meta < 4) {
            return BlockRockSedimentary.EnumType.fromMeta(meta - 1).func_176610_l().replace("rock_", "");
        }
        if (meta == 4) {
            return "lignite";
        }
        return BlockRockSedimentary.EnumType.fromMeta(meta - 2).func_176610_l().replace("rock_", "");
    }

    private static AnvilRecipe createAnvilRecipe(ItemStack output, Ingredient input, int hits, AnvilRecipe.EnumType type, AnvilRecipe.EnumTier tier, String id) {
        AnvilRecipe recipe = new AnvilRecipe(output, input, hits, type, tier);
        recipe.setRegistryName("pyrotech_compat", id);
        anvilRecipes.add(recipe);
        return recipe;
    }

    private static KilnPitRecipe createKilnPitRecipe(ItemStack output, Ingredient input, ItemStack[] failureItems, String id) {
        KilnPitRecipe recipe = new KilnPitRecipe(output, input, 16800, 0.33f, failureItems);
        recipe.setRegistryName("pyrotech_compat", id);
        kilnPitRecipes.add(recipe);
        return recipe;
    }

    private static StoneKilnRecipe createStoneKilnRecipe(ItemStack output, Ingredient input, int burnTime, float failureChance, ItemStack[] falureItems, String id) {
        StoneKilnRecipe recipe = new StoneKilnRecipe(output, input, burnTime, failureChance, falureItems);
        recipe.setRegistryName("pyrotech_compat", id);
        stoneKilnRecipes.add(recipe);
        return recipe;
    }

    private static CompactingBinRecipe createCompactingBinRecipe(ItemStack output, Ingredient input, int amount, String id) {
        CompactingBinRecipe recipe = new CompactingBinRecipe(output, input, amount);
        recipe.setRegistryName("pyrotech_compat", id);
        compactingBinRecipes.add(recipe);
        return recipe;
    }

    private static void registerInheritedRecipes() {
        float failureChance;
        int timeTicks;
        if (ModuleTechBasicConfig.IRONCLAD_ANVIL.INHERIT_GRANITE_ANVIL_RECIPES) {
            for (AnvilRecipe anvilRecipe : anvilRecipes) {
                ModuleTechBasic.Registries.ANVIL_RECIPE.register(new AnvilRecipe(anvilRecipe.getOutput(), anvilRecipe.getInput(), Math.max(1, (int)((double)anvilRecipe.getHits() * Math.max(0.0, ModuleTechBasicConfig.IRONCLAD_ANVIL.INHERITED_GRANITE_ANVIL_RECIPE_HIT_MODIFIER))), anvilRecipe.getType(), AnvilRecipe.EnumTier.IRONCLAD).setRegistryName("pyrotech_compat", "granite_anvil/" + anvilRecipe.getRegistryName().func_110623_a()));
            }
        }
        if (ModPyrotech.INSTANCE.isModuleEnabled(ModuleTechBasic.class) && ModuleTechMachineConfig.MECHANICAL_COMPACTING_BIN.INHERIT_COMPACTING_BIN_RECIPES) {
            for (CompactingBinRecipe compactingBinRecipe : compactingBinRecipes) {
                ModuleTechMachine.Registries.MECHANICAL_COMPACTING_BIN_RECIPES.register(new MechanicalCompactingBinRecipe(compactingBinRecipe.getOutput(), compactingBinRecipe.getInput(), compactingBinRecipe.getAmount(), compactingBinRecipe.getRequiredToolUses()).setRegistryName("pyrotech_compat", "compacting_bin/" + compactingBinRecipe.getRegistryName().func_110623_a()));
            }
        }
        if (ModPyrotech.INSTANCE.isModuleEnabled(ModuleTechBasic.class) && ModuleTechMachineConfig.STONE_KILN.INHERIT_PIT_KILN_RECIPES) {
            for (KilnPitRecipe kilnPitRecipe : kilnPitRecipes) {
                timeTicks = (int)((double)kilnPitRecipe.getTimeTicks() * ModuleTechMachineConfig.STONE_KILN.INHERITED_PIT_KILN_RECIPE_DURATION_MODIFIER);
                failureChance = (float)((double)kilnPitRecipe.getFailureChance() * ModuleTechMachineConfig.STONE_KILN.INHERITED_PIT_KILN_RECIPE_FAILURE_CHANCE_MODIFIER);
                ModuleTechMachine.Registries.STONE_KILN_RECIPES.register((IForgeRegistryEntry)RecipeInitializer.createStoneKilnRecipe(kilnPitRecipe.getOutput(), kilnPitRecipe.getInput(), timeTicks, failureChance, kilnPitRecipe.getFailureItems(), "pit_kiln/" + kilnPitRecipe.getRegistryName().func_110623_a()));
            }
        }
        if (ModuleTechMachineConfig.BRICK_KILN.INHERIT_STONE_TIER_RECIPES) {
            for (StoneKilnRecipe stoneKilnRecipe : stoneKilnRecipes) {
                timeTicks = (int)((double)stoneKilnRecipe.getTimeTicks() * ModuleTechMachineConfig.BRICK_KILN.INHERITED_STONE_TIER_RECIPE_DURATION_MODIFIER);
                failureChance = (float)((double)stoneKilnRecipe.getFailureChance() * ModuleTechMachineConfig.BRICK_KILN.INHERITED_STONE_TIER_RECIPE_FAILURE_CHANCE_MODIFIER);
                ModuleTechMachine.Registries.BRICK_KILN_RECIPES.register(new BrickKilnRecipe(stoneKilnRecipe.getOutput(), stoneKilnRecipe.getInput(), timeTicks, failureChance, stoneKilnRecipe.getFailureItems()).setRegistryName("pyrotech_compat", "stone_kiln/" + stoneKilnRecipe.getRegistryName().func_110623_a()));
            }
        }
    }

    public static ItemStack getUBCGravel(String prefix, int meta) {
        return RecipeInitializer.getUBC(prefix, "gravel", meta);
    }

    public static ItemStack getUBC(String prefix, String suffix, int meta) {
        return RecipeInitializer.getUBC(prefix, suffix, 1, meta);
    }

    public static ItemStack getUBC(String prefix, String suffix, int amount, int meta) {
        return GameRegistry.makeItemStack((String)("undergroundbiomes:" + prefix + "_" + suffix), (int)meta, (int)amount, null);
    }
}

