/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.pyrotech_compat.block.rocks;

import com.codetaylor.mc.athenaeum.spi.IBlockVariant;
import com.codetaylor.mc.athenaeum.spi.IVariant;
import java.util.Comparator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import trinsdar.pyrotech_compat.block.rocks.BlockRockBase;
import trinsdar.pyrotech_compat.init.BlockInitializer;

public class BlockRockSedimentary
extends BlockRockBase
implements IBlockVariant<EnumType> {
    public static final String NAME = "rock_sedimentary";
    public static final IProperty<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockRockSedimentary() {
        super(NAME, SoundType.field_185851_d);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> list) {
        for (EnumType type : EnumType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Nonnull
    public String getModelName(ItemStack itemStack) {
        return EnumType.fromMeta(itemStack.func_77960_j()).func_176610_l();
    }

    @Nonnull
    public IProperty<EnumType> getVariant() {
        return VARIANT;
    }

    public static enum EnumType implements IVariant
    {
        CHALK(0, "rock_chalk"),
        SHALE(1, "rock_shale"),
        SILTSTONE(2, "rock_siltstone"),
        DOLOMITE(3, "rock_dolomite"),
        GREYWACKE(4, "rock_greywacke"),
        CHERT(5, "rock_chert");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public ItemStack asStack() {
            return this.asStack(1);
        }

        public ItemStack asStack(int amount) {
            return new ItemStack((Block)BlockInitializer.blockRockSedimentary, amount, this.meta);
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

