/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.toughnessbar.client;

import com.tfar.toughnessbar.ToughnessBarConfig;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class EventHandlerClient {
    private final ResourceLocation EMPTY = new ResourceLocation("toughnessbar", "textures/gui/empty.png");
    private final ResourceLocation HALF = new ResourceLocation("toughnessbar", "textures/gui/half.png");
    private final ResourceLocation FULL = new ResourceLocation("toughnessbar", "textures/gui/full.png");
    private final ResourceLocation HALF_CAPPED = new ResourceLocation("toughnessbar", "textures/gui/half_capped.png");
    private final ResourceLocation CAPPED = new ResourceLocation("toughnessbar", "textures/gui/capped.png");
    private final List<Color> colors = new ArrayList<Color>();

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("toughnessbar")) {
            ConfigManager.sync((String)"toughnessbar", (Config.Type)Config.Type.INSTANCE);
            this.colors.clear();
        }
    }

    @SubscribeEvent
    public void onRenderArmorToughnessEvent(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD && Minecraft.func_71410_x().func_175606_aa() instanceof EntityLivingBase) {
            EntityLivingBase viewEntity = (EntityLivingBase)Minecraft.func_71410_x().func_175606_aa();
            int armorToughness = MathHelper.func_76128_c((double)viewEntity.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e());
            if (armorToughness <= 0 && !ToughnessBarConfig.forceToughnessbar) {
                return;
            }
            if (this.colors.isEmpty()) {
                for (String hexColor : ToughnessBarConfig.colorValues) {
                    if (!hexColor.startsWith("#")) continue;
                    try {
                        this.colors.add(new Color(Integer.parseInt(hexColor.substring(1), 16)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.colors.isEmpty()) {
                    this.colors.add(Color.WHITE);
                }
            }
            int index = --armorToughness / 20;
            armorToughness %= 20;
            ++armorToughness;
            ToughnessColor color = this.getColor(index);
            ToughnessColor previous = this.getColor(index - 1);
            ResourceLocation lastTexture = null;
            GlStateManager.func_179147_l();
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            int top = event.getResolution().func_78328_b() - GuiIngameForge.right_height;
            int right = event.getResolution().func_78326_a() / 2 + 82;
            for (int i = 1; i < 20; i += 2) {
                if (previous.isCapped()) {
                    lastTexture = this.fullIcon(this.CAPPED, previous, lastTexture, right, top, 9);
                } else if (i < armorToughness) {
                    lastTexture = this.fullIcon(color.isCapped() ? this.CAPPED : this.FULL, color, lastTexture, right, top, 9);
                } else if (i == armorToughness) {
                    lastTexture = this.halfIcon(color.isCapped() ? this.HALF_CAPPED : this.HALF, color, previous, lastTexture, right, top);
                } else if (ToughnessBarConfig.forceToughnessbar || ToughnessBarConfig.showEmptyArmorToughnessIcons || index > 0) {
                    lastTexture = this.fullIcon(previous.isEmpty() ? this.EMPTY : this.FULL, previous, lastTexture, right, top, 9);
                }
                right -= 8;
            }
            GuiIngameForge.right_height += 10;
            GL11.glPopMatrix();
            GL11.glPopAttrib();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
            GlStateManager.func_179084_k();
        }
    }

    private ToughnessColor getColor(int index) {
        if (index < 0) {
            return new ToughnessColor(true);
        }
        if (index >= this.colors.size()) {
            return new ToughnessColor(false);
        }
        return new ToughnessColor(this.colors.get(index));
    }

    private ResourceLocation fullIcon(ResourceLocation icon, ToughnessColor color, ResourceLocation lastIcon, int right, int top, int width) {
        if (!icon.equals((Object)lastIcon)) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(icon);
        }
        GL11.glColor4f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
        Gui.func_146110_a((int)right, (int)top, (float)0.0f, (float)0.0f, (int)width, (int)9, (float)9.0f, (float)9.0f);
        return icon;
    }

    private ResourceLocation halfIcon(ResourceLocation icon, ToughnessColor color, ToughnessColor previous, ResourceLocation lastIcon, int right, int top) {
        this.fullIcon(previous.isEmpty() ? this.EMPTY : this.FULL, previous, lastIcon, right, top, 4);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(icon);
        GL11.glColor4f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
        Gui.func_146110_a((int)(right + 4), (int)top, (float)0.0f, (float)0.0f, (int)5, (int)9, (float)5.0f, (float)9.0f);
        return icon;
    }

    private class ToughnessColor {
        private Color color;
        private boolean empty = true;

        private ToughnessColor(Color color) {
            this.color = color;
        }

        private ToughnessColor(boolean empty) {
            this.empty = empty;
        }

        private boolean isEmpty() {
            return this.color == null && this.empty;
        }

        private boolean isCapped() {
            return this.color == null && !this.empty;
        }

        private float getRed() {
            return this.color == null ? (float)(Integer.decode(ToughnessBarConfig.colorValues[0]) >> 16 & 0xFF) / 256.0f : (float)this.color.getRed() / 256.0f;
        }

        private float getBlue() {
            return this.color == null ? (float)(Integer.decode(ToughnessBarConfig.colorValues[0]) & 0xFF) / 256.0f : (float)this.color.getBlue() / 256.0f;
        }

        private float getGreen() {
            return this.color == null ? (float)(Integer.decode(ToughnessBarConfig.colorValues[0]) >> 8 & 0xFF) / 256.0f : (float)this.color.getGreen() / 256.0f;
        }

        private float getAlpha() {
            return this.color == null ? 1.0f : (float)this.color.getAlpha() / 256.0f;
        }
    }
}

