/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldprimer.util;

import fi.dy.masa.worldprimer.WorldPrimer;
import fi.dy.masa.worldprimer.command.WorldPrimerCommandSender;
import fi.dy.masa.worldprimer.util.CommandUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.StringUtils;

public class TimedCommands {
    private static final Map<Integer, List<TimedCommand>> TIMED_COMMANDS = new HashMap<Integer, List<TimedCommand>>();
    private static long delayUntilNextCommand;

    public static void setTimedCommands(String[] rawCommands) {
        TIMED_COMMANDS.clear();
        for (String cmd : rawCommands) {
            if (StringUtils.isBlank((CharSequence)cmd) || cmd.length() > 0 && cmd.charAt(0) == '#') continue;
            String[] parts = cmd.split("\\s+", 4);
            if (parts.length >= 4 && parts[0].equals("worldprimer-timed-command")) {
                boolean isPeriodic = false;
                String timeStr = parts[1];
                long offset = 0L;
                try {
                    int index;
                    if (timeStr.length() > 1 && timeStr.charAt(0) == '%') {
                        isPeriodic = true;
                        timeStr = timeStr.substring(1, timeStr.length());
                    }
                    if ((index = timeStr.indexOf(45)) == -1) {
                        index = timeStr.indexOf(43);
                    }
                    if (index != -1) {
                        offset = Long.parseLong(timeStr.substring(index, timeStr.length()));
                        timeStr = timeStr.substring(0, index);
                    }
                    long time = Long.parseLong(timeStr);
                    int dimension = Integer.parseInt(parts[2]);
                    List<TimedCommand> list = TIMED_COMMANDS.get(dimension);
                    if (list == null) {
                        list = new ArrayList<TimedCommand>();
                        TIMED_COMMANDS.put(dimension, list);
                    }
                    String command = String.join((CharSequence)" ", CommandUtils.dropFirstStrings(parts, 3));
                    list.add(new TimedCommand(command, dimension, time, offset, isPeriodic));
                }
                catch (NumberFormatException e) {
                    WorldPrimer.logger.warn("Invalid time or dimension value in timed command '{}'", (Object)cmd);
                }
                continue;
            }
            WorldPrimer.logger.warn("Invalid timed command '{}', ignoring it!", (Object)cmd);
        }
        TimedCommands.updateAllTimedCommands(false);
    }

    public static void updateAllTimedCommands(boolean removeFromCurrentTick) {
        delayUntilNextCommand = -1L;
        if (TIMED_COMMANDS.size() > 0) {
            Iterator<Map.Entry<Integer, List<TimedCommand>>> mapIter = TIMED_COMMANDS.entrySet().iterator();
            while (mapIter.hasNext()) {
                Map.Entry<Integer, List<TimedCommand>> entry = mapIter.next();
                if (!TimedCommands.updateTimedCommandsForDimension(entry.getKey(), removeFromCurrentTick)) continue;
                mapIter.remove();
            }
        }
    }

    public static void updateTimedCommandsForDimension(int dimension) {
        if (TimedCommands.updateTimedCommandsForDimension(dimension, false)) {
            TIMED_COMMANDS.remove(dimension);
        }
    }

    private static boolean updateTimedCommandsForDimension(int dimension, boolean removeFromCurrentTick) {
        WorldServer world = DimensionManager.getWorld((int)dimension);
        List<TimedCommand> list = TIMED_COMMANDS.get(dimension);
        if (world != null && list != null) {
            long currentTime = world.func_82737_E();
            Iterator<TimedCommand> listIter = list.iterator();
            while (listIter.hasNext()) {
                TimedCommand command = listIter.next();
                command.update(currentTime);
                if (command.getNextExecution() >= currentTime && (!removeFromCurrentTick || command.getNextExecution() != currentTime)) continue;
                listIter.remove();
            }
            if (list.size() > 0) {
                Collections.sort(list);
                long delay = list.get(0).getNextExecution() - currentTime;
                if (delayUntilNextCommand < 0L || delay < delayUntilNextCommand) {
                    delayUntilNextCommand = delay;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static void runTimedCommands() {
        if (delayUntilNextCommand > 0L && --delayUntilNextCommand == 0L) {
            block0: for (Map.Entry<Integer, List<TimedCommand>> entry : TIMED_COMMANDS.entrySet()) {
                WorldServer world = DimensionManager.getWorld((int)entry.getKey());
                if (world == null) continue;
                long currentTime = world.func_82737_E();
                List<TimedCommand> list = entry.getValue();
                for (TimedCommand command : list) {
                    if (command.getNextExecution() == currentTime) {
                        WorldPrimer.logInfo("Executing a timed command '{}' @ tick {} in dim {}", command.getCommand(), currentTime, entry.getKey());
                        WorldPrimerCommandSender.instance().runCommands(null, (World)world, command.getCommand());
                        continue;
                    }
                    if (command.getNextExecution() <= currentTime) continue;
                    continue block0;
                }
            }
            TimedCommands.updateAllTimedCommands(true);
        }
    }

    public static class TimedCommand
    implements Comparable<TimedCommand> {
        private final String command;
        private final int dimension;
        private final boolean isPeriodic;
        private final long time;
        private final long offset;
        private long nextExecution;

        public TimedCommand(String command, int dimension, long time, long offset, boolean isPeriodic) {
            this.command = command;
            this.dimension = dimension;
            this.time = time;
            this.offset = offset;
            this.isPeriodic = isPeriodic;
        }

        public String getCommand() {
            return this.command;
        }

        public int getDimension() {
            return this.dimension;
        }

        public boolean getIsPeriodic() {
            return this.isPeriodic;
        }

        public long getNextExecution() {
            return this.nextExecution;
        }

        public void update(long currentTime) {
            if (this.isPeriodic) {
                if (this.nextExecution <= currentTime) {
                    this.nextExecution = ((currentTime - this.offset) / this.time + 1L) * this.time + this.offset;
                }
            } else {
                this.nextExecution = this.time + this.offset;
            }
        }

        @Override
        public int compareTo(TimedCommand other) {
            if (this.nextExecution < other.nextExecution) {
                return -1;
            }
            if (this.nextExecution > other.nextExecution) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return String.format("TimedCommand{dimension=%d,time=%d,periodic=%s,nextExecution=%d,command=%s}", this.dimension, this.time, this.isPeriodic, this.nextExecution, this.command);
        }
    }
}

