/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldprimer.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import fi.dy.masa.worldprimer.WorldPrimer;
import fi.dy.masa.worldprimer.util.Schematic;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class TemplateWorldPrimer
extends Template {
    private List<Template.BlockInfo> blocks = new ArrayList<Template.BlockInfo>();
    private List<Template.EntityInfo> entities = new ArrayList<Template.EntityInfo>();

    public TemplateWorldPrimer() {
        try {
            this.blocks = (List)ObfuscationReflectionHelper.findField(Template.class, (String)"field_186270_a").get((Object)this);
            this.entities = (List)ObfuscationReflectionHelper.findField(Template.class, (String)"field_186271_b").get((Object)this);
        }
        catch (Exception e) {
            WorldPrimer.logger.error("Failed to reflect the Template class fields", (Throwable)e);
        }
    }

    public void func_186254_a(World worldIn, BlockPos startPos, BlockPos size, boolean takeEntities, Block toIgnore) {
        if (size.func_177958_n() >= 1 && size.func_177956_o() >= 1 && size.func_177952_p() >= 1) {
            BlockPos posEnd = startPos.func_177971_a((Vec3i)size).func_177982_a(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos posMin = new BlockPos(Math.min(startPos.func_177958_n(), posEnd.func_177958_n()), Math.min(startPos.func_177956_o(), posEnd.func_177956_o()), Math.min(startPos.func_177952_p(), posEnd.func_177952_p()));
            BlockPos posMax = new BlockPos(Math.max(startPos.func_177958_n(), posEnd.func_177958_n()), Math.max(startPos.func_177956_o(), posEnd.func_177956_o()), Math.max(startPos.func_177952_p(), posEnd.func_177952_p()));
            ObfuscationReflectionHelper.setPrivateValue(Template.class, (Object)((Object)this), (Object)size, (String)"field_186272_c");
            for (BlockPos.MutableBlockPos posMutable : BlockPos.func_177975_b((BlockPos)posMin, (BlockPos)posMax)) {
                BlockPos posRel = posMutable.func_177973_b((Vec3i)posMin);
                IBlockState state = worldIn.func_180495_p((BlockPos)posMutable);
                if (toIgnore != null && toIgnore == state.func_177230_c()) continue;
                TileEntity te = worldIn.func_175625_s((BlockPos)posMutable);
                if (te != null) {
                    NBTTagCompound tag = new NBTTagCompound();
                    tag = Schematic.chiselsAndBitsHandler.writeChiselsAndBitsTileToNBT(new NBTTagCompound(), te);
                    tag.func_82580_o("x");
                    tag.func_82580_o("y");
                    tag.func_82580_o("z");
                    list1.add(new Template.BlockInfo(posRel, state, tag));
                    continue;
                }
                if (!state.func_185913_b() && !state.func_185917_h()) {
                    list2.add(new Template.BlockInfo(posRel, state, null));
                    continue;
                }
                list.add(new Template.BlockInfo(posRel, state, null));
            }
            this.blocks.clear();
            this.blocks.addAll(list);
            this.blocks.addAll(list1);
            this.blocks.addAll(list2);
            if (takeEntities) {
                this.takeEntitiesFromWorld(worldIn, posMin, posMax.func_177982_a(1, 1, 1));
            } else {
                this.entities.clear();
            }
        }
    }

    private void takeEntitiesFromWorld(World worldIn, BlockPos startPos, BlockPos endPos) {
        List list = worldIn.func_175647_a(Entity.class, new AxisAlignedBB(startPos, endPos), (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return !(entity instanceof EntityPlayer);
            }
        });
        this.entities.clear();
        for (Entity entity : list) {
            Vec3d entityPos = new Vec3d(entity.field_70165_t - (double)startPos.func_177958_n(), entity.field_70163_u - (double)startPos.func_177956_o(), entity.field_70161_v - (double)startPos.func_177952_p());
            NBTTagCompound tag = new NBTTagCompound();
            entity.func_70039_c(tag);
            BlockPos blockPos = entity instanceof EntityPainting ? ((EntityPainting)entity).func_174857_n().func_177973_b((Vec3i)startPos) : new BlockPos(entityPos);
            this.entities.add(new Template.EntityInfo(entityPos, blockPos, tag));
        }
    }
}

