/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldprimer.util;

import fi.dy.masa.worldprimer.WorldPrimer;
import fi.dy.masa.worldprimer.command.WorldPrimerCommandSender;
import fi.dy.masa.worldprimer.config.Configs;
import fi.dy.masa.worldprimer.util.DataTracker;
import fi.dy.masa.worldprimer.util.TimedCommands;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class CommandUtils {
    private static boolean runCreationCommands;

    public static int getDimension(EntityPlayer player) {
        return CommandUtils.getDimension(player.func_130014_f_());
    }

    public static int getDimension(World world) {
        return world.field_73011_w.getDimension();
    }

    public static void onCreateSpawn(World world) {
        int dimension = CommandUtils.getDimension(world);
        WorldPrimer.logInfo("WorldEvent.CreateSpawnPosition, DIM: {}", dimension);
        if (!Configs.enableDataTracking && !world.field_72995_K && dimension == 0) {
            if (Configs.enableEarlyWorldCreationCommands) {
                WorldPrimer.logInfo("WorldEvent.CreateSpawnPosition: Running earlyWorldCreationCommands for DIM: {}", dimension);
                WorldPrimerCommandSender.instance().runCommands(world, Configs.earlyWorldCreationCommands);
            }
            runCreationCommands = Configs.enablePostWorldCreationCommands;
        }
    }

    public static void onWorldLoad(World world) {
        if (!world.field_72995_K) {
            int dimension = CommandUtils.getDimension(world);
            WorldPrimer.logInfo("WorldEvent.Load, DIM: {}", dimension);
            if (Configs.enableTimedCommands) {
                TimedCommands.updateTimedCommandsForDimension(dimension);
            }
            if (runCreationCommands && dimension == 0) {
                WorldPrimer.logInfo("WorldEvent.Load: Running postWorldCreationCommands for DIM: {}", dimension);
                WorldPrimerCommandSender.instance().runCommands(world, Configs.postWorldCreationCommands);
                runCreationCommands = false;
            }
            if (Configs.enableDataTracking) {
                DataTracker.instance().dimensionLoaded(dimension);
            }
            if (Configs.enableDimensionLoadingCommands) {
                WorldPrimer.logInfo("WorldEvent.Load: Running dimensionLoadingCommands", new Object[0]);
                int currentCount = DataTracker.instance().getDimensionLoadCount(dimension);
                CommandUtils.runDimensionCommands(null, world, CommandUtils.getDimension(world), currentCount, Configs.dimensionLoadingCommands);
            }
        }
    }

    public static void onPlayerJoin(EntityPlayer player) {
        WorldPrimer.logInfo("PlayerLoggedInEvent: running join commands for player {}", player);
        CommandUtils.handlePlayerEvent(player, DataTracker.PlayerDataType.JOIN, Configs.enablePlayerJoinCommands, Configs.playerJoinCommands);
        if (Configs.runDimensionChangeCommandsOnJoinQuit && Configs.enablePlayerChangedDimensionEnterCommands) {
            int dimension = CommandUtils.getDimension(player);
            DataTracker.instance().incrementPlayerDimensionEventCount(player, dimension, DataTracker.PlayerDimensionDataType.ENTER);
            int currentCount = DataTracker.instance().getPlayerDimensionEventCount(player, dimension, DataTracker.PlayerDimensionDataType.ENTER);
            CommandUtils.runDimensionCommands(player, player.func_130014_f_(), dimension, currentCount, Configs.playerChangedDimensionEnterCommands);
        }
    }

    public static void onPlayerQuit(EntityPlayer player) {
        WorldPrimer.logInfo("PlayerLoggedOutEvent: running quit commands for player {}", player);
        CommandUtils.handlePlayerEvent(player, DataTracker.PlayerDataType.QUIT, Configs.enablePlayerQuitCommands, Configs.playerQuitCommands);
        if (Configs.runDimensionChangeCommandsOnJoinQuit && Configs.enablePlayerChangedDimensionLeaveCommands) {
            int dimension = CommandUtils.getDimension(player);
            DataTracker.instance().incrementPlayerDimensionEventCount(player, dimension, DataTracker.PlayerDimensionDataType.LEAVE);
            int currentCount = DataTracker.instance().getPlayerDimensionEventCount(player, dimension, DataTracker.PlayerDimensionDataType.LEAVE);
            CommandUtils.runDimensionCommands(player, player.func_130014_f_(), dimension, currentCount, Configs.playerChangedDimensionLeaveCommands);
        }
    }

    public static void onPlayerDeath(EntityPlayer player) {
        WorldPrimer.logInfo("LivingDeathEvent: running death commands for player: {}", player);
        CommandUtils.handlePlayerEvent(player, DataTracker.PlayerDataType.DEATH, Configs.enablePlayerDeathCommands, Configs.playerDeathCommands);
    }

    public static void onPlayerRespawn(EntityPlayer player, boolean isEndConquered) {
        WorldPrimer.logInfo("PlayerRespawnEvent player: {}, leaving the End: {}", player, isEndConquered);
        if (!isEndConquered) {
            CommandUtils.handlePlayerEvent(player, DataTracker.PlayerDataType.RESPAWN, Configs.enablePlayerRespawnCommands, Configs.playerRespawnCommands);
        } else {
            int currentCount;
            int dimension;
            if (Configs.enablePlayerChangedDimensionLeaveCommands) {
                dimension = 1;
                WorldPrimer.logInfo("PlayerRespawnEvent (leaving the End): running dimension leave commands for player {}", player);
                DataTracker.instance().incrementPlayerDimensionEventCount(player, 1, DataTracker.PlayerDimensionDataType.LEAVE);
                currentCount = DataTracker.instance().getPlayerDimensionEventCount(player, 1, DataTracker.PlayerDimensionDataType.LEAVE);
                CommandUtils.runDimensionCommands(player, player.func_130014_f_(), 1, currentCount, Configs.playerChangedDimensionLeaveCommands);
            }
            if (Configs.enablePlayerChangedDimensionEnterCommands) {
                dimension = CommandUtils.getDimension(player);
                DataTracker.instance().incrementPlayerDimensionEventCount(player, dimension, DataTracker.PlayerDimensionDataType.ENTER);
                currentCount = DataTracker.instance().getPlayerDimensionEventCount(player, dimension, DataTracker.PlayerDimensionDataType.ENTER);
                CommandUtils.runDimensionCommands(player, player.func_130014_f_(), dimension, currentCount, Configs.playerChangedDimensionEnterCommands);
            }
        }
    }

    public static void onPlayerChangedDimension(EntityPlayer player, int fromDim, int toDim) {
        int currentCount;
        WorldPrimer.logInfo("PlayerChangedDimensionEvent player: {} from dim {}, to dim {}", player, fromDim, toDim);
        if (Configs.enablePlayerChangedDimensionLeaveCommands) {
            WorldPrimer.logInfo("PlayerChangedDimensionEvent: running dimension leave commands for player {}", player);
            DataTracker.instance().incrementPlayerDimensionEventCount(player, fromDim, DataTracker.PlayerDimensionDataType.LEAVE);
            currentCount = DataTracker.instance().getPlayerDimensionEventCount(player, fromDim, DataTracker.PlayerDimensionDataType.LEAVE);
            CommandUtils.runDimensionCommands(player, player.func_130014_f_(), fromDim, currentCount, Configs.playerChangedDimensionLeaveCommands);
        }
        if (Configs.enablePlayerChangedDimensionEnterCommands) {
            WorldPrimer.logInfo("PlayerChangedDimensionEvent: running dimension enter commands for player {}", player);
            DataTracker.instance().incrementPlayerDimensionEventCount(player, toDim, DataTracker.PlayerDimensionDataType.ENTER);
            currentCount = DataTracker.instance().getPlayerDimensionEventCount(player, toDim, DataTracker.PlayerDimensionDataType.ENTER);
            CommandUtils.runDimensionCommands(player, player.func_130014_f_(), toDim, currentCount, Configs.playerChangedDimensionEnterCommands);
        }
    }

    private static void runDimensionCommands(@Nullable EntityPlayer player, World world, int dimension, int currentCount, String[] commands) {
        for (String command : commands) {
            if (StringUtils.isBlank((CharSequence)command) || command.length() > 0 && command.charAt(0) == '#') continue;
            String[] parts = command.split("\\s+", 4);
            if (parts.length >= 3 && parts[0].equals("worldprimer-dim-command")) {
                CommandUtils.runDimensionCommandsRegular(player, world, dimension, command, parts);
                continue;
            }
            if (Configs.enableDataTracking && parts.length >= 4 && parts[0].equals("worldprimer-dim-command-nth")) {
                CommandUtils.runDimensionCommandsNth(player, world, dimension, command, parts, currentCount);
                continue;
            }
            WorldPrimerCommandSender.instance().runCommands(player, world, command);
        }
    }

    private static void runDimensionCommandsRegular(@Nullable EntityPlayer player, World world, int dimension, String fullCommand, String[] cmdParts) {
        try {
            if (cmdParts[1].equals("*") || dimension == Integer.parseInt(cmdParts[1])) {
                cmdParts = CommandUtils.dropFirstStrings(cmdParts, 2);
                WorldPrimerCommandSender.instance().runCommands(player, world, String.join((CharSequence)" ", cmdParts));
            }
        }
        catch (NumberFormatException e) {
            WorldPrimer.logger.warn("Invalid dimension id '{}' in dimension-specific command '{}'", (Object)cmdParts[1], (Object)fullCommand);
        }
    }

    private static void runDimensionCommandsNth(@Nullable EntityPlayer player, World world, int dimension, String fullCommand, String[] cmdParts, int currentCount) {
        try {
            if (cmdParts[2].equals("*") || dimension == Integer.parseInt(cmdParts[2])) {
                String countStr = cmdParts[1];
                boolean modulo = false;
                if (countStr.charAt(0) == '%') {
                    countStr = countStr.substring(1, countStr.length());
                    modulo = true;
                }
                int count = Integer.parseInt(countStr);
                if (modulo && count != 0 && currentCount % count == 0 || !modulo && currentCount == count) {
                    cmdParts = CommandUtils.dropFirstStrings(cmdParts, 3);
                    WorldPrimerCommandSender.instance().runCommands(player, world, String.join((CharSequence)" ", cmdParts));
                }
            }
        }
        catch (NumberFormatException e) {
            WorldPrimer.logger.warn("Invalid syntax in dimension-specific command '{}'", (Object)fullCommand);
        }
    }

    private static void handlePlayerEvent(EntityPlayer player, DataTracker.PlayerDataType type, boolean enabled, String[] commands) {
        if (enabled) {
            DataTracker.instance().incrementPlayerDataCount(player, type);
            int currentCount = DataTracker.instance().getPlayerDataCount(player, type);
            CommandUtils.runTrackedCommands(player, commands, currentCount);
        }
    }

    private static void runTrackedCommands(EntityPlayer player, String[] commands, int currentCount) {
        for (String command : commands) {
            if (StringUtils.isBlank((CharSequence)command) || command.length() > 0 && command.charAt(0) == '#') continue;
            String[] parts = command.split("\\s+", 3);
            if (Configs.enableDataTracking && parts.length >= 3 && parts[0].equals("worldprimer-tracked-command-nth")) {
                CommandUtils.runTrackedCommandsNth(player, command, parts, currentCount);
                continue;
            }
            WorldPrimerCommandSender.instance().runCommands(player, player.func_130014_f_(), command);
        }
    }

    private static void runTrackedCommandsNth(EntityPlayer player, String fullCommand, String[] cmdParts, int currentCount) {
        try {
            String countStr = cmdParts[1];
            boolean modulo = false;
            if (countStr.charAt(0) == '%') {
                countStr = countStr.substring(1, countStr.length());
                modulo = true;
            }
            int count = Integer.parseInt(countStr);
            if (modulo && count != 0 && currentCount % count == 0 || !modulo && currentCount == count) {
                cmdParts = CommandUtils.dropFirstStrings(cmdParts, 2);
                WorldPrimerCommandSender.instance().runCommands(player, player.func_130014_f_(), String.join((CharSequence)" ", cmdParts));
            }
        }
        catch (NumberFormatException e) {
            WorldPrimer.logger.warn("Invalid syntax in tracked command '{}'", (Object)fullCommand);
        }
    }

    public static String[] dropFirstStrings(String[] input, int toDrop) {
        if (toDrop >= input.length) {
            return new String[0];
        }
        String[] arr = new String[input.length - toDrop];
        System.arraycopy(input, toDrop, arr, 0, input.length - toDrop);
        return arr;
    }
}

