/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldprimer.command;

import fi.dy.masa.worldprimer.WorldPrimer;
import fi.dy.masa.worldprimer.config.Configs;
import fi.dy.masa.worldprimer.util.CommandSubstitutions;
import fi.dy.masa.worldprimer.util.WorldUtils;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.StringUtils;

public class WorldPrimerCommandSender
implements ICommandSender {
    private static final WorldPrimerCommandSender INSTANCE = new WorldPrimerCommandSender();
    private World executionWorld;
    @Nullable
    private String senderName = null;

    public static WorldPrimerCommandSender instance() {
        return INSTANCE;
    }

    public void runCommands(@Nullable World world, String ... commands) {
        this.runCommands(null, world, commands);
    }

    public void runCommands(@Nullable EntityPlayer player, @Nullable World world, String ... commands) {
        ICommandManager manager = this.func_184102_h().func_71187_D();
        this.executionWorld = world;
        for (String command : commands) {
            String dim;
            if (StringUtils.isBlank((CharSequence)command)) continue;
            command = this.handleCommandSenderNamePrefix(command);
            String newCommand = CommandSubstitutions.doCommandSubstitutions(player, world, command);
            World worldTmp = this.func_130014_f_();
            String string = dim = worldTmp != null ? String.valueOf(worldTmp.field_73011_w.getDimension()) : "<none>";
            if (this.isChunkLoadingCommand(newCommand)) {
                WorldPrimer.logInfo("Attempting to load chunks in dimension {}", dim);
                WorldUtils.executeChunkLoadingCommand(newCommand, worldTmp);
            } else if (this.isWorldPrimerCommand(newCommand)) {
                WorldPrimer.logInfo("Attempting to directly execute a (possibly substituted) worldprimer command '{}' in dimension {}", newCommand, dim);
                try {
                    newCommand = newCommand.substring(12, newCommand.length());
                    WorldPrimer.commandWorldPrimer.func_184881_a(worldTmp.func_73046_m(), this, newCommand.trim().split(" "));
                }
                catch (CommandException e) {
                    WorldPrimer.logger.warn("Failed to execute the command '{}'", (Object)newCommand, (Object)e);
                }
            } else {
                WorldPrimer.logInfo("Running a (possibly substituted) command: '{}' in dimension {}", newCommand, dim);
                manager.func_71556_a((ICommandSender)this, newCommand);
            }
            this.senderName = null;
        }
        WorldUtils.unloadLoadedChunks(world);
        this.executionWorld = null;
    }

    private String handleCommandSenderNamePrefix(String originalCommand) {
        String namePrefix = "worldprimer-command-sender ";
        int namePrefixLength = namePrefix.length();
        if (originalCommand.startsWith(namePrefix)) {
            String command = originalCommand.substring(namePrefixLength);
            if (command.charAt(0) == '\"') {
                int endQuotePos = command.indexOf(34, 1);
                if (endQuotePos > 0 && endQuotePos < command.length() - 3) {
                    this.senderName = command.substring(1, endQuotePos);
                    return command.substring(endQuotePos + 2);
                }
                WorldPrimer.logger.warn("Malformed command sender name prefix for command '{}'", (Object)originalCommand);
            } else {
                int nameEndPos = command.indexOf(32, 1);
                if (nameEndPos > 0 && nameEndPos < command.length() - 2) {
                    this.senderName = command.substring(0, nameEndPos);
                    return command.substring(nameEndPos + 1);
                }
                WorldPrimer.logger.warn("Malformed command sender name prefix for command '{}'", (Object)originalCommand);
            }
        }
        return originalCommand;
    }

    private boolean isChunkLoadingCommand(String command) {
        String[] parts = command.split(" ");
        return parts.length > 0 && (parts[0].equals("worldprimer-load-chunks") || parts[0].equals("worldprimer-load-blocks"));
    }

    private boolean isWorldPrimerCommand(String command) {
        String[] parts = command.split(" ");
        return parts.length > 0 && parts[0].equals("worldprimer");
    }

    public String func_70005_c_() {
        return this.senderName != null ? this.senderName : Configs.commandSenderName;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public void func_145747_a(ITextComponent component) {
        WorldPrimer.logInfo(component.func_150260_c(), new Object[0]);
    }

    public boolean func_70003_b(int permLevel, String commandName) {
        return true;
    }

    public BlockPos func_180425_c() {
        return BlockPos.field_177992_a;
    }

    public Vec3d func_174791_d() {
        return Vec3d.field_186680_a;
    }

    public World func_130014_f_() {
        return this.executionWorld != null ? this.executionWorld : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0];
    }

    @Nullable
    public Entity func_174793_f() {
        return null;
    }

    public boolean func_174792_t_() {
        return false;
    }

    public void func_174794_a(CommandResultStats.Type type, int amount) {
    }

    public MinecraftServer func_184102_h() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }
}

