/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldprimer.command;

import fi.dy.masa.worldprimer.WorldPrimer;
import fi.dy.masa.worldprimer.command.CommandWorldPrimer;
import fi.dy.masa.worldprimer.command.SubCommand;
import fi.dy.masa.worldprimer.util.Schematic;
import fi.dy.masa.worldprimer.util.WorldUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSenderWrapper;
import net.minecraft.command.FunctionObject;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SubCommandPlaceStructure
extends SubCommand {
    private TemplateManager templateManager;

    public SubCommandPlaceStructure(CommandWorldPrimer baseCommand) {
        super(baseCommand);
    }

    @Override
    public String getName() {
        return "place-structure";
    }

    @Override
    public void printHelpGeneric(ICommandSender sender) {
        this.sendMessage(sender, this.getUsage(), new Object[0]);
    }

    private String getUsage() {
        return super.getUsageStringCommon() + " <x> <y> <z> <structurename> [rotation: cw_90 | cw_180 | ccw_90 | none] [mirror: left_right | front_back | none] [centered] [data-functions]";
    }

    @Override
    protected List<String> getTabCompletionsSub(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 4) {
            return CommandBase.func_175762_a((String[])args, this.getExistingStructureFileNames());
        }
        if (args.length == 5) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"cw_90", "cw_180", "ccw_90", "none"});
        }
        if (args.length == 6) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"front_back", "left_right", "none"});
        }
        if (args.length == 7) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"centered"});
        }
        if (args.length == 8) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"data-functions"});
        }
        if (args.length <= 3) {
            return CommandBase.func_175771_a((String[])args, (int)0, (BlockPos)targetPos);
        }
        return Collections.emptyList();
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 4 && args.length <= 8) {
            try {
                BlockPos pos = CommandBase.func_175757_a((ICommandSender)sender, (String[])args, (int)0, (boolean)false);
                Rotation rotation = args.length >= 5 ? this.getRotation(args[4]) : Rotation.NONE;
                Mirror mirror = args.length >= 6 ? this.getMirror(args[5]) : Mirror.NONE;
                boolean centered = args.length == 7 && args[6].equals("centered");
                boolean dataFunctions = args.length == 8 && args[7].equals("data-functions");
                this.tryPlaceStructureWrapper(server, sender.func_130014_f_(), pos, rotation, mirror, centered, args[3], sender, dataFunctions);
            }
            catch (NumberFormatException e) {
                SubCommandPlaceStructure.throwUsage(this.getUsage(), new Object[0]);
            }
        } else {
            SubCommandPlaceStructure.throwUsage(this.getUsage(), new Object[0]);
        }
    }

    private boolean tryPlaceStructureWrapper(MinecraftServer server, World world, BlockPos pos, Rotation rotation, Mirror mirror, boolean centered, String structureName, ICommandSender sender, boolean dataFunctions) throws CommandException {
        StructureType type = this.getExistingStructureTypeForName(structureName);
        if (type == StructureType.STRUCTURE) {
            return this.tryPlaceVanillaStructure(server, world, pos, rotation, mirror, centered, structureName, sender, dataFunctions);
        }
        if (type == StructureType.SCHEMATIC) {
            return this.tryPlaceSchematic(server, world, pos, rotation, mirror, centered, structureName, sender, dataFunctions);
        }
        SubCommandPlaceStructure.throwCommand("worldprimer.commands.error.placestructure.unknown_format", structureName);
        return false;
    }

    private boolean tryPlaceVanillaStructure(MinecraftServer server, World world, BlockPos pos, Rotation rotation, Mirror mirror, boolean centered, String structureName, ICommandSender sender, boolean dataFunctions) throws CommandException {
        Template template = this.getTemplateManager().func_186237_a(server, new ResourceLocation(structureName));
        if (template != null) {
            PlacementSettings placement = new PlacementSettings();
            placement.func_186220_a(rotation);
            placement.func_186214_a(mirror);
            placement.func_186225_a(Blocks.field_189881_dj);
            if (centered) {
                BlockPos size = Template.func_186266_a((PlacementSettings)placement, (BlockPos)template.func_186259_a());
                pos = pos.func_177982_a(-(size.func_177958_n() / 2), 0, -(size.func_177952_p() / 2));
            }
            this.loadChunks(world, pos, template.func_186259_a());
            template.func_186253_b(world, pos, placement);
            WorldUtils.unloadLoadedChunks(world);
            if (dataFunctions) {
                this.executeDataFunctions(world, template.func_186258_a(pos, placement), server, sender);
            }
            return true;
        }
        return false;
    }

    private boolean tryPlaceSchematic(MinecraftServer server, World world, BlockPos pos, Rotation rotation, Mirror mirror, boolean centered, String structureName, ICommandSender sender, boolean dataFunctions) throws CommandException {
        File file = new File(this.getStructureDirectory(), structureName + StructureType.SCHEMATIC.getExtension());
        Schematic schematic = Schematic.createFromFile(file);
        if (schematic != null) {
            PlacementSettings placement = new PlacementSettings();
            placement.func_186220_a(rotation);
            placement.func_186214_a(mirror);
            placement.func_186225_a(Blocks.field_189881_dj);
            placement.func_186222_a(false);
            if (centered) {
                BlockPos size = Template.func_186266_a((PlacementSettings)placement, (BlockPos)schematic.getSize());
                pos = pos.func_177982_a(-(size.func_177958_n() / 2), 0, -(size.func_177952_p() / 2));
            }
            this.loadChunks(world, pos, schematic.getSize());
            schematic.placeSchematicToWorld(world, pos, placement, 2);
            WorldUtils.unloadLoadedChunks(world);
            if (dataFunctions) {
                this.executeDataFunctions(world, schematic.getDataStructureBlocks(pos, placement), server, sender);
            }
            return true;
        }
        return false;
    }

    private void executeDataFunctions(World world, Map<BlockPos, String> dataStructureBlocks, MinecraftServer server, ICommandSender sender) throws CommandException {
        for (Map.Entry<BlockPos, String> entry : dataStructureBlocks.entrySet()) {
            BlockPos posDataBlock = entry.getKey();
            world.func_175656_a(posDataBlock, Blocks.field_150350_a.func_176223_P());
            ResourceLocation functionName = new ResourceLocation(entry.getValue());
            FunctionObject function = server.func_193030_aL().func_193058_a(functionName);
            if (function == null) {
                throw new CommandException("worldprimer.commands.error.placestructure.function.unknown", new Object[]{functionName});
            }
            server.func_193030_aL().func_194019_a(function, (ICommandSender)CommandSenderWrapper.func_193998_a((ICommandSender)sender).func_194000_i().func_194001_a(false));
        }
    }

    @Nullable
    private StructureType getExistingStructureTypeForName(String structureName) {
        File dir = this.getStructureDirectory();
        File file = new File(dir, structureName + StructureType.STRUCTURE.getExtension());
        if (file.exists() && file.isFile() && file.canRead()) {
            return StructureType.STRUCTURE;
        }
        file = new File(dir, structureName + StructureType.SCHEMATIC.getExtension());
        if (file.exists() && file.isFile() && file.canRead()) {
            return StructureType.SCHEMATIC;
        }
        return null;
    }

    protected TemplateManager getTemplateManager() {
        if (this.templateManager == null) {
            this.templateManager = new TemplateManager(this.getStructureDirectory().toString(), (DataFixer)FMLCommonHandler.instance().getDataFixer());
        }
        return this.templateManager;
    }

    protected File getStructureDirectory() {
        return new File(new File(WorldPrimer.configDirPath), "structures");
    }

    protected List<String> getExistingStructureFileNames() {
        File dir = this.getStructureDirectory();
        if (dir.isDirectory()) {
            String[] names = dir.list();
            ArrayList<String> list = new ArrayList<String>();
            String extensionVanilla = StructureType.STRUCTURE.getExtension();
            String extensionSchematic = StructureType.SCHEMATIC.getExtension();
            for (String name : names) {
                if (name.endsWith(extensionVanilla)) {
                    list.add(name.substring(0, name.length() - extensionVanilla.length()));
                    continue;
                }
                if (name.endsWith(extensionSchematic)) {
                    list.add(name.substring(0, name.length() - extensionSchematic.length()));
                    continue;
                }
                list.add(name);
            }
            return list;
        }
        return Collections.emptyList();
    }

    private Rotation getRotation(String arg) throws CommandException {
        if (arg.equals("cw_90")) {
            return Rotation.CLOCKWISE_90;
        }
        if (arg.equals("cw_180")) {
            return Rotation.CLOCKWISE_180;
        }
        if (arg.equals("ccw_90")) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        if (arg.equals("none")) {
            return Rotation.NONE;
        }
        SubCommandPlaceStructure.throwCommand("worldprimer.commands.error.invalid.argument.rotation", arg);
        return Rotation.NONE;
    }

    private Mirror getMirror(String arg) throws CommandException {
        if (arg.equals("front_back")) {
            return Mirror.FRONT_BACK;
        }
        if (arg.equals("left_right")) {
            return Mirror.LEFT_RIGHT;
        }
        if (arg.equals("none")) {
            return Mirror.NONE;
        }
        SubCommandPlaceStructure.throwCommand("worldprimer.commands.error.invalid.argument.mirror", arg);
        return Mirror.NONE;
    }

    protected void loadChunks(World world, BlockPos pos, BlockPos size) {
        WorldUtils.loadChunks(world, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, pos.func_177958_n() + size.func_177958_n() >> 4, pos.func_177952_p() + size.func_177952_p() >> 4);
    }

    public static enum StructureType {
        STRUCTURE(".nbt"),
        SCHEMATIC(".schematic");

        private final String extension;

        private StructureType(String extension) {
            this.extension = extension;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

