/*
 * Decompiled with CFR 0.152.
 */
package ru.socol.advancedliftingmethods.registry;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ru.socol.advancedliftingmethods.AdvancedLiftingMethods;
import ru.socol.advancedliftingmethods.block.BlockBlowingElevator;
import ru.socol.advancedliftingmethods.block.BlockDoubleStairs;
import ru.socol.advancedliftingmethods.block.BlockDoubleStairsTop;
import ru.socol.advancedliftingmethods.block.BlockEnderElevator;
import ru.socol.advancedliftingmethods.block.BlockPoweredLadder;

public class ModBlocks {
    public static ArrayList<BlockDoubleStairs> DOUBLE_STAIRS = new ArrayList();
    public static BlockPoweredLadder POWERED_LADDER_NORTH = new BlockPoweredLadder(EnumFacing.NORTH);
    public static BlockPoweredLadder POWERED_LADDER_SOUTH = new BlockPoweredLadder(EnumFacing.SOUTH);
    public static BlockPoweredLadder POWERED_LADDER_EAST = new BlockPoweredLadder(EnumFacing.EAST);
    public static BlockPoweredLadder POWERED_LADDER_WEST = new BlockPoweredLadder(EnumFacing.WEST);
    public static BlockBlowingElevator BLOWING_ELEVATOR = new BlockBlowingElevator(8);
    public static BlockBlowingElevator ADVANCED_BLOWING_ELEVATOR = new BlockBlowingElevator(16);
    public static BlockBlowingElevator ULTIMATE_BLOWING_ELEVATOR = new BlockBlowingElevator(32);
    public static BlockEnderElevator ENDER_ELEVATOR = new BlockEnderElevator(16);
    public static BlockEnderElevator ADVANCED_ENDER_ELEVATOR = new BlockEnderElevator(64);
    public static BlockEnderElevator ULTIMATE_ENDER_ELEVATOR = new BlockEnderElevator(256);

    public static void register() {
        ModBlocks.registerDoubleStairs("oak", Blocks.field_150476_ad);
        ModBlocks.registerDoubleStairs("cobblestone", Blocks.field_150446_ar);
        ModBlocks.registerDoubleStairs("brick", Blocks.field_150389_bf);
        ModBlocks.registerDoubleStairs("stone_brick", Blocks.field_150390_bg);
        ModBlocks.registerDoubleStairs("nether_brick", Blocks.field_150387_bl);
        ModBlocks.registerDoubleStairs("sandstone", Blocks.field_150372_bz);
        ModBlocks.registerDoubleStairs("spruce", Blocks.field_150485_bF);
        ModBlocks.registerDoubleStairs("birch", Blocks.field_150487_bG);
        ModBlocks.registerDoubleStairs("jungle", Blocks.field_150481_bH);
        ModBlocks.registerDoubleStairs("quartz", Blocks.field_150370_cb);
        ModBlocks.registerDoubleStairs("acacia", Blocks.field_150400_ck);
        ModBlocks.registerDoubleStairs("dark_oak", Blocks.field_150401_cl);
        ModBlocks.registerDoubleStairs("red_sandstone", Blocks.field_180396_cN);
        ModBlocks.registerDoubleStairs("purpur", Blocks.field_185769_cV);
        ModBlocks.registerBlock(POWERED_LADDER_NORTH, "powered_ladder_north");
        ModBlocks.registerBlock(POWERED_LADDER_SOUTH, "powered_ladder_south");
        ModBlocks.registerBlock(POWERED_LADDER_EAST, "powered_ladder_east");
        ModBlocks.registerBlock(POWERED_LADDER_WEST, "powered_ladder_west");
        ModBlocks.registerBlock(BLOWING_ELEVATOR, "blowing_elevator", new ItemBlock((Block)BLOWING_ELEVATOR));
        ModBlocks.registerBlock(ADVANCED_BLOWING_ELEVATOR, "advanced_blowing_elevator", new ItemBlock((Block)ADVANCED_BLOWING_ELEVATOR));
        ModBlocks.registerBlock(ULTIMATE_BLOWING_ELEVATOR, "ultimate_blowing_elevator", new ItemBlock((Block)ULTIMATE_BLOWING_ELEVATOR));
        ModBlocks.registerBlock(ENDER_ELEVATOR, "ender_elevator", new ItemBlock((Block)ENDER_ELEVATOR));
        ModBlocks.registerBlock(ADVANCED_ENDER_ELEVATOR, "advanced_ender_elevator", new ItemBlock((Block)ADVANCED_ENDER_ELEVATOR));
        ModBlocks.registerBlock(ULTIMATE_ENDER_ELEVATOR, "ultimate_ender_elevator", new ItemBlock((Block)ULTIMATE_ENDER_ELEVATOR));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenders() {
        for (BlockDoubleStairs stairs : DOUBLE_STAIRS) {
            ModBlocks.registerBlockRender(stairs);
        }
        ModBlocks.registerBlockRender(BLOWING_ELEVATOR);
        ModBlocks.registerBlockRender(ADVANCED_BLOWING_ELEVATOR);
        ModBlocks.registerBlockRender(ULTIMATE_BLOWING_ELEVATOR);
        ModBlocks.registerBlockRender(ENDER_ELEVATOR);
        ModBlocks.registerBlockRender(ADVANCED_ENDER_ELEVATOR);
        ModBlocks.registerBlockRender(ULTIMATE_ENDER_ELEVATOR);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockColors() {
    }

    public static void registerDoubleStairs(String material, Block originalStairs) {
        BlockDoubleStairsTop stairsTop = new BlockDoubleStairsTop(originalStairs);
        BlockDoubleStairs stairs = new BlockDoubleStairs(stairsTop, originalStairs);
        ModBlocks.registerBlock(stairs, "double_" + material + "_stairs", new ItemBlock((Block)stairs));
        ModBlocks.registerBlock(stairsTop, "double_" + material + "_stairs_top");
        DOUBLE_STAIRS.add(stairs);
    }

    private static void registerBlock(Block block, String name, ItemBlock itemBlock) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)((Block)block.func_149663_c(name).setRegistryName("advancedliftingmethods", name)).func_149647_a((CreativeTabs)AdvancedLiftingMethods.creativeTab));
        ForgeRegistries.ITEMS.register(itemBlock.setRegistryName("advancedliftingmethods", name));
    }

    private static void registerBlock(Block block, String name) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)((Block)block.func_149663_c(name).setRegistryName("advancedliftingmethods", name)).func_149647_a((CreativeTabs)AdvancedLiftingMethods.creativeTab));
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerBlockRender(Block block) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("advancedliftingmethods", block.func_149739_a().substring(5)), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerBlockRender(Block block, int meta, String fileName) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation(fileName, "inventory"));
    }
}

