/*
 * Decompiled with CFR 0.152.
 */
package ru.socol.advancedliftingmethods.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.socol.advancedliftingmethods.block.BlockDoubleStairsTop;

public class BlockDoubleStairs
extends Block {
    protected static final AxisAlignedBB AABB_SLAB_TOP = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_WEST = new AxisAlignedBB(0.0, 0.5, 0.0, 0.75, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_EAST = new AxisAlignedBB(0.25, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_NORTH = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.75);
    protected static final AxisAlignedBB AABB_QTR_TOP_SOUTH = new AxisAlignedBB(0.0, 0.5, 0.25, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_TOP_NW = new AxisAlignedBB(0.0, 0.5, 0.0, 0.75, 1.0, 0.75);
    protected static final AxisAlignedBB AABB_OCT_TOP_NE = new AxisAlignedBB(0.25, 0.5, 0.0, 1.0, 1.0, 0.75);
    protected static final AxisAlignedBB AABB_OCT_TOP_SW = new AxisAlignedBB(0.0, 0.5, 0.25, 0.75, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_TOP_SE = new AxisAlignedBB(0.25, 0.5, 0.25, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_SLAB_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_EAST = new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.75);
    protected static final AxisAlignedBB AABB_QTR_BOT_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_OCT_BOT_NW = new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 0.5, 0.75);
    protected static final AxisAlignedBB AABB_OCT_BOT_NE = new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 0.5, 0.75);
    protected static final AxisAlignedBB AABB_OCT_BOT_SW = new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_OCT_BOT_SE = new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 0.5, 1.0);
    private final IBlockState modelState;
    private final BlockDoubleStairsTop top;
    public final Block originalStairs;

    public BlockDoubleStairs(BlockDoubleStairsTop top, Block originalStairs) {
        super(originalStairs.func_149688_o(originalStairs.func_176223_P()));
        this.originalStairs = originalStairs;
        this.modelState = originalStairs.func_176223_P();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT));
        this.top = top;
        this.func_149711_c(this.originalStairs.func_176195_g(this.modelState, null, null));
        this.func_149752_b(this.originalStairs.func_149638_a(null));
        this.func_149672_a(this.originalStairs.func_185467_w());
        this.func_149713_g(255);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.field_149783_u = true;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        for (AxisAlignedBB axisalignedbb : BlockDoubleStairs.getCollisionBoxList(state)) {
            BlockDoubleStairs.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState bstate) {
        ArrayList list = Lists.newArrayList();
        boolean flag = bstate.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP;
        list.add(flag ? AABB_SLAB_TOP : AABB_SLAB_BOTTOM);
        BlockStairs.EnumShape shape = (BlockStairs.EnumShape)bstate.func_177229_b((IProperty)BlockStairs.field_176310_M);
        if (shape == BlockStairs.EnumShape.STRAIGHT || shape == BlockStairs.EnumShape.INNER_LEFT || shape == BlockStairs.EnumShape.INNER_RIGHT) {
            list.add(BlockDoubleStairs.getCollQuarterBlock(bstate));
        }
        if (shape != BlockStairs.EnumShape.STRAIGHT) {
            list.add(BlockDoubleStairs.getCollEighthBlock(bstate));
        }
        return list;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        state = this.func_176221_a(state, worldIn, pos);
        if (face.func_176740_k() == EnumFacing.Axis.Y) {
            return face == EnumFacing.UP == (state.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
        }
        BlockStairs.EnumShape blockstairs$enumshape = (BlockStairs.EnumShape)state.func_177229_b((IProperty)BlockStairs.field_176310_M);
        if (blockstairs$enumshape != BlockStairs.EnumShape.OUTER_LEFT && blockstairs$enumshape != BlockStairs.EnumShape.OUTER_RIGHT) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockStairs.field_176309_a);
            switch (blockstairs$enumshape) {
                case INNER_RIGHT: {
                    return enumfacing != face && enumfacing != face.func_176735_f() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
                }
                case INNER_LEFT: {
                    return enumfacing != face && enumfacing != face.func_176746_e() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
                }
                case STRAIGHT: {
                    return enumfacing == face ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
                }
            }
            return BlockFaceShape.UNDEFINED;
        }
        return BlockFaceShape.UNDEFINED;
    }

    private static AxisAlignedBB getCollQuarterBlock(IBlockState bstate) {
        boolean flag = bstate.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP;
        switch ((EnumFacing)bstate.func_177229_b((IProperty)BlockStairs.field_176309_a)) {
            default: {
                return flag ? AABB_QTR_BOT_NORTH : AABB_QTR_TOP_NORTH;
            }
            case SOUTH: {
                return flag ? AABB_QTR_BOT_SOUTH : AABB_QTR_TOP_SOUTH;
            }
            case WEST: {
                return flag ? AABB_QTR_BOT_WEST : AABB_QTR_TOP_WEST;
            }
            case EAST: 
        }
        return flag ? AABB_QTR_BOT_EAST : AABB_QTR_TOP_EAST;
    }

    private static AxisAlignedBB getCollEighthBlock(IBlockState bstate) {
        EnumFacing collFace;
        EnumFacing face = (EnumFacing)bstate.func_177229_b((IProperty)BlockStairs.field_176309_a);
        switch ((BlockStairs.EnumShape)bstate.func_177229_b((IProperty)BlockStairs.field_176310_M)) {
            default: {
                collFace = face;
                break;
            }
            case OUTER_RIGHT: {
                collFace = face.func_176746_e();
                break;
            }
            case INNER_RIGHT: {
                collFace = face.func_176734_d();
                break;
            }
            case INNER_LEFT: {
                collFace = face.func_176735_f();
            }
        }
        boolean flag = bstate.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP;
        switch (collFace) {
            default: {
                return flag ? AABB_OCT_BOT_NW : AABB_OCT_TOP_NW;
            }
            case SOUTH: {
                return flag ? AABB_OCT_BOT_SE : AABB_OCT_TOP_SE;
            }
            case WEST: {
                return flag ? AABB_OCT_BOT_SW : AABB_OCT_TOP_SW;
            }
            case EAST: 
        }
        return flag ? AABB_OCT_BOT_NE : AABB_OCT_TOP_NE;
    }

    private static BlockStairs.EnumShape getStairsShape(IBlockState p_185706_0_, IBlockAccess p_185706_1_, BlockPos p_185706_2_) {
        EnumFacing enumfacing2;
        EnumFacing enumfacing1;
        EnumFacing enumfacing = (EnumFacing)p_185706_0_.func_177229_b((IProperty)BlockStairs.field_176309_a);
        IBlockState iblockstate = p_185706_1_.func_180495_p(p_185706_2_.func_177972_a(enumfacing));
        if (BlockDoubleStairs.isBlockStairs(iblockstate) && p_185706_0_.func_177229_b((IProperty)BlockStairs.field_176308_b) == iblockstate.func_177229_b((IProperty)BlockStairs.field_176308_b) && (enumfacing1 = (EnumFacing)iblockstate.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_176740_k() != ((EnumFacing)p_185706_0_.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_176740_k() && BlockDoubleStairs.isDifferentStairs(p_185706_0_, p_185706_1_, p_185706_2_, enumfacing1.func_176734_d())) {
            if (enumfacing1 == enumfacing.func_176735_f()) {
                return BlockStairs.EnumShape.OUTER_LEFT;
            }
            return BlockStairs.EnumShape.OUTER_RIGHT;
        }
        IBlockState iblockstate1 = p_185706_1_.func_180495_p(p_185706_2_.func_177972_a(enumfacing.func_176734_d()));
        if (BlockDoubleStairs.isBlockStairs(iblockstate1) && p_185706_0_.func_177229_b((IProperty)BlockStairs.field_176308_b) == iblockstate1.func_177229_b((IProperty)BlockStairs.field_176308_b) && (enumfacing2 = (EnumFacing)iblockstate1.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_176740_k() != ((EnumFacing)p_185706_0_.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_176740_k() && BlockDoubleStairs.isDifferentStairs(p_185706_0_, p_185706_1_, p_185706_2_, enumfacing2)) {
            if (enumfacing2 == enumfacing.func_176735_f()) {
                return BlockStairs.EnumShape.INNER_LEFT;
            }
            return BlockStairs.EnumShape.INNER_RIGHT;
        }
        return BlockStairs.EnumShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(IBlockState p_185704_0_, IBlockAccess p_185704_1_, BlockPos p_185704_2_, EnumFacing p_185704_3_) {
        IBlockState iblockstate = p_185704_1_.func_180495_p(p_185704_2_.func_177972_a(p_185704_3_));
        return !BlockDoubleStairs.isBlockStairs(iblockstate) || iblockstate.func_177229_b((IProperty)BlockStairs.field_176309_a) != p_185704_0_.func_177229_b((IProperty)BlockStairs.field_176309_a) || iblockstate.func_177229_b((IProperty)BlockStairs.field_176308_b) != p_185704_0_.func_177229_b((IProperty)BlockStairs.field_176308_b);
    }

    public static boolean isBlockStairs(IBlockState state) {
        return state.func_177230_c() instanceof BlockDoubleStairs;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockDoubleStairs.getStairsShape(state, worldIn, pos));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        this.originalStairs.func_180655_c(stateIn, worldIn, pos, rand);
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        this.originalStairs.func_180649_a(worldIn, pos, playerIn);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        this.originalStairs.func_176206_d(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.modelState.func_185889_a(source, pos);
    }

    public float func_149638_a(Entity exploder) {
        return this.originalStairs.func_149638_a(exploder);
    }

    public int func_149738_a(World worldIn) {
        return this.originalStairs.func_149738_a(worldIn);
    }

    public Vec3d func_176197_a(World worldIn, BlockPos pos, Entity entityIn, Vec3d motion) {
        return this.originalStairs.func_176197_a(worldIn, pos, entityIn, motion);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.originalStairs.func_180664_k();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return this.modelState.func_185918_c(worldIn, pos);
    }

    public boolean func_149703_v() {
        return this.originalStairs.func_149703_v();
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return this.originalStairs.func_176209_a(state, hitIfLiquid);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.modelState.func_189546_a(worldIn, pos, Blocks.field_150350_a, pos);
        this.originalStairs.func_176213_c(worldIn, pos, this.modelState);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.originalStairs.func_180663_b(worldIn, pos, this.modelState);
        IBlockState upState = worldIn.func_180495_p(pos.func_177984_a());
        IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        if (upState.func_177230_c() instanceof BlockDoubleStairsTop && upState.func_177228_b().get((Object)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.BOTTOM) {
            worldIn.func_175698_g(pos.func_177984_a());
        } else if (downState.func_177230_c() instanceof BlockDoubleStairsTop && downState.func_177228_b().get((Object)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP) {
            worldIn.func_175698_g(pos.func_177977_b());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.originalStairs.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.originalStairs.func_180650_b(worldIn, pos, state, rand);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.originalStairs.func_180639_a(worldIn, pos, this.modelState, playerIn, hand, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.originalStairs.func_180652_a(worldIn, pos, explosionIn);
    }

    public boolean func_185481_k(IBlockState state) {
        return state.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.originalStairs.func_180659_g(this.modelState, worldIn, pos);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        BlockStairs.EnumHalf half;
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        iblockstate = iblockstate.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT);
        BlockStairs.EnumHalf enumHalf = half = facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? BlockStairs.EnumHalf.BOTTOM : BlockStairs.EnumHalf.TOP;
        if (half == BlockStairs.EnumHalf.BOTTOM && !super.func_176196_c(worldIn, pos.func_177984_a())) {
            half = BlockStairs.EnumHalf.TOP;
        } else if (half == BlockStairs.EnumHalf.TOP && !super.func_176196_c(worldIn, pos.func_177977_b())) {
            half = BlockStairs.EnumHalf.BOTTOM;
        }
        return iblockstate.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)half);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : BlockDoubleStairs.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)((meta & 4) > 0 ? BlockStairs.EnumHalf.TOP : BlockStairs.EnumHalf.BOTTOM));
        iblockstate = iblockstate.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.func_82600_a((int)(5 - (meta & 3))));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP) {
            i |= 4;
        }
        return i |= 5 - ((EnumFacing)state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStairs.field_176309_a, BlockStairs.field_176308_b, BlockStairs.field_176310_M});
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (ForgeModContainer.disableStairSlabCulling) {
            return super.doesSideBlockRendering(state, world, pos, face);
        }
        if (state.func_185914_p()) {
            return true;
        }
        state = this.func_176221_a(state, world, pos);
        BlockStairs.EnumHalf half = (BlockStairs.EnumHalf)state.func_177229_b((IProperty)BlockStairs.field_176308_b);
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)BlockStairs.field_176309_a);
        BlockStairs.EnumShape shape = (BlockStairs.EnumShape)state.func_177229_b((IProperty)BlockStairs.field_176310_M);
        if (face == EnumFacing.UP) {
            return half == BlockStairs.EnumHalf.TOP;
        }
        if (face == EnumFacing.DOWN) {
            return half == BlockStairs.EnumHalf.BOTTOM;
        }
        if (shape == BlockStairs.EnumShape.OUTER_LEFT || shape == BlockStairs.EnumShape.OUTER_RIGHT) {
            return false;
        }
        if (face == side) {
            return true;
        }
        if (shape == BlockStairs.EnumShape.INNER_LEFT && face.func_176746_e() == side) {
            return true;
        }
        return shape == BlockStairs.EnumShape.INNER_RIGHT && face.func_176735_f() == side;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        BlockStairs.EnumHalf half = (BlockStairs.EnumHalf)worldIn.func_180495_p(pos).func_177229_b((IProperty)BlockStairs.field_176308_b);
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)BlockStairs.field_176309_a);
        worldIn.func_180501_a(half == BlockStairs.EnumHalf.BOTTOM ? pos.func_177984_a() : pos.func_177977_b(), this.top.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)half).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)side), 11);
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return super.func_176196_c(worldIn, pos) && (pos.func_177956_o() < worldIn.func_72800_K() - 1 && super.func_176196_c(worldIn, pos.func_177984_a()) || super.func_176196_c(worldIn, pos.func_177977_b()));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int delta;
        BlockStairs.EnumHalf half = (BlockStairs.EnumHalf)world.func_180495_p(pos).func_177229_b((IProperty)BlockStairs.field_176308_b);
        int n = delta = half == BlockStairs.EnumHalf.BOTTOM ? -1 : 1;
        if (pos.func_177958_n() == fromPos.func_177958_n() && pos.func_177956_o() == fromPos.func_177956_o() + delta && pos.func_177952_p() == fromPos.func_177952_p() && world.func_175623_d(fromPos)) {
            this.func_180663_b(world, pos, world.func_180495_p(pos));
        }
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }
}

