/*
 * Decompiled with CFR 0.152.
 */
package ru.socol.advancedliftingmethods.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.socol.advancedliftingmethods.tile.TileEntityBlowingElevator;

public class BlockBlowingElevator
extends Block
implements ITileEntityProvider {
    public static final PropertyInteger POWER = PropertyInteger.func_177719_a((String)"power", (int)0, (int)8);
    private int distance;

    public BlockBlowingElevator(int distance) {
        super(Material.field_151576_e);
        this.distance = distance;
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149713_g(1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
    }

    public int getDistance() {
        return this.distance;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWER});
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (face.func_176740_k() != EnumFacing.Axis.Y) {
            return world.func_180495_p(pos.func_177972_a(face)).func_177230_c() == this;
        }
        return super.doesSideBlockRendering(state, world, pos, face);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBlowingElevator();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int power = Math.min(7, worldIn.func_175687_A(pos));
        BlockPos northPos = pos.func_177978_c();
        BlockPos southPos = pos.func_177968_d();
        BlockPos eastPos = pos.func_177974_f();
        BlockPos westPos = pos.func_177976_e();
        IBlockState northState = worldIn.func_180495_p(northPos);
        IBlockState southState = worldIn.func_180495_p(southPos);
        IBlockState eastState = worldIn.func_180495_p(eastPos);
        IBlockState westState = worldIn.func_180495_p(westPos);
        int northPower = 0;
        int southPower = 0;
        int eastPower = 0;
        int westPower = 0;
        if (northState.func_177230_c() == this) {
            northPower = (Integer)northState.func_177229_b((IProperty)POWER);
        }
        if (southState.func_177230_c() == this) {
            southPower = (Integer)southState.func_177229_b((IProperty)POWER);
        }
        if (eastState.func_177230_c() == this) {
            eastPower = (Integer)eastState.func_177229_b((IProperty)POWER);
        }
        if (westState.func_177230_c() == this) {
            westPower = (Integer)westState.func_177229_b((IProperty)POWER);
        }
        power = Math.max(0, Math.max(power, Math.max(Math.max(northPower, southPower), Math.max(eastPower, westPower)) - 1));
        int currentPower = (Integer)state.func_177229_b((IProperty)POWER);
        if (currentPower != power) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(power)), 3);
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            state.func_189546_a(worldIn, pos, (Block)this, pos);
        }
    }
}

