/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.util;

import bettercombat.mod.client.ClientProxy;
import bettercombat.mod.client.SoundHandler;
import bettercombat.mod.network.PacketHandler;
import bettercombat.mod.network.server.PacketParrying;
import bettercombat.mod.server.EventHandlers;
import bettercombat.mod.util.ConfigurationHandler;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Helpers {
    public static UUID weaponModifierUUID = UUID.fromString("fa233e1c-4180-4865-b01b-bcce9785aca3");
    public static String ATTACK_SPEED = "attackSpeed";
    public static String REACH_DISTANCE = "reachDistance";
    public static String ATTRIBUTE_NAME = "AttributeName";
    public static String QUALITY = "Quality";
    public static String ATTRIBUTE_MODIFIERS = "AttributeModifiers";
    public static String ATTACK_DAMAGE = "attackDamage";
    public static Random rand = new Random();
    public static final int[] values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    public static final String[] romanLiterals = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};

    private Helpers() {
    }

    public static boolean playerAttackVictim(EntityPlayer player, Entity victim, boolean mainhandAttack) {
        ItemStack mainhand = player.func_184614_ca();
        ItemStack offhand = player.func_184592_cb();
        boolean attacked = false;
        if (mainhandAttack) {
            player.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
            attacked = Helpers.playerAttackVictimWithWeapon(player, victim, mainhand, offhand, true);
            player.func_184611_a(EnumHand.OFF_HAND, offhand);
            if (player.field_70170_p.field_72995_K) {
                ClientProxy.EHC_INSTANCE.checkItemstacksChanged(true);
            }
            if (!mainhand.func_190926_b() && victim instanceof EntityLivingBase) {
                ItemStack beforeHitCopy = mainhand.func_77946_l();
                mainhand.func_77961_a((EntityLivingBase)victim, player);
                if (mainhand.func_190926_b()) {
                    player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)beforeHitCopy, (EnumHand)EnumHand.MAIN_HAND);
                    if (player.field_70170_p.field_72995_K) {
                        ClientProxy.EHC_INSTANCE.checkItemstacksChanged(true);
                    }
                }
            }
        } else {
            player.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
            player.func_184611_a(EnumHand.MAIN_HAND, offhand);
            attacked = offhand.func_77973_b() instanceof ItemShield ? Helpers.playerAttackVictimWithShield(player, victim, (ItemShield)offhand.func_77973_b()) : Helpers.playerAttackVictimWithWeapon(player, victim, mainhand, offhand, false);
            player.func_184611_a(EnumHand.OFF_HAND, offhand);
            player.func_184611_a(EnumHand.MAIN_HAND, mainhand);
            if (player.field_70170_p.field_72995_K) {
                ClientProxy.EHC_INSTANCE.checkItemstacksChanged(true);
            }
            if (!offhand.func_190926_b() && victim instanceof EntityLivingBase) {
                ItemStack beforeHitCopy = offhand.func_77946_l();
                offhand.func_77961_a((EntityLivingBase)victim, player);
                if (offhand.func_190926_b()) {
                    player.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)beforeHitCopy, (EnumHand)EnumHand.OFF_HAND);
                    if (player.field_70170_p.field_72995_K) {
                        ClientProxy.EHC_INSTANCE.checkItemstacksChanged(true);
                    }
                }
            }
        }
        return attacked;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean playerAttackVictimWithWeapon(EntityPlayer player, Entity entity, ItemStack mainhand, ItemStack offhand, boolean mainhandAttack) {
        EntityLivingBase victim;
        float tgtHealthPercent;
        float tgtMaxHealth;
        float tgtHealth;
        double damage;
        double armorToughness;
        double armor;
        boolean isCrit;
        block81: {
            Vec3d vec3d;
            ItemStack activeItem;
            boolean configWeapon;
            ItemStack weapon;
            block80: {
                EntityLiving el;
                MultiPartEntityPart bodyPart;
                boolean isMetal;
                ConfigurationHandler.ConfigWeaponPotionEffect customWeaponPotionEffect;
                ConfigurationHandler.Animation animation;
                ConfigurationHandler.SoundType soundType;
                double enchantmentModifier;
                double additionalReach;
                double critDamage;
                int sweepAmount;
                int fireAspect;
                double knockbackMod;
                block79: {
                    if (entity == null || entity == player) {
                        return false;
                    }
                    isCrit = false;
                    knockbackMod = EnchantmentHelper.func_77501_a((EntityLivingBase)player);
                    fireAspect = EnchantmentHelper.func_90036_a((EntityLivingBase)player);
                    sweepAmount = 0;
                    double critChance = player.func_110148_a(EventHandlers.CRIT_CHANCE).func_111126_e();
                    critDamage = player.func_110148_a(EventHandlers.CRIT_DAMAGE).func_111126_e();
                    additionalReach = 0.0;
                    enchantmentModifier = 0.0;
                    armor = 0.0;
                    armorToughness = 0.0;
                    damage = 0.0;
                    soundType = null;
                    animation = null;
                    if (mainhandAttack) {
                        weapon = mainhand;
                        damage = Helpers.getMainhandAttackDamage(player, mainhand);
                    } else {
                        weapon = offhand;
                        damage = Helpers.getOffhandAttackDamage(player, offhand, mainhand);
                        damage *= ConfigurationHandler.offHandEfficiency;
                    }
                    customWeaponPotionEffect = null;
                    if (ConfigurationHandler.isConfigWeapon(weapon.func_77973_b())) {
                        configWeapon = true;
                        String weaponName = Helpers.getRegistryNameFromItem(weapon);
                        isMetal = Helpers.isMetalRegistryName(weaponName);
                        boolean customWeapon = false;
                        for (ConfigurationHandler.ConfigWeapon s : ConfigurationHandler.weapons) {
                            if (!weaponName.contains(s.name)) continue;
                            customWeapon = true;
                            sweepAmount += s.sweepMod;
                            knockbackMod += s.knockbackMod;
                            critChance += s.critChanceMod - player.func_110148_a(EventHandlers.CRIT_CHANCE).func_111125_b();
                            critDamage += s.additionalCritDamageMod;
                            additionalReach = s.additionalReachMod;
                            soundType = s.soundType;
                            animation = s.animation;
                            customWeaponPotionEffect = s.configWeaponPotionEffect;
                            break;
                        }
                        if (!customWeapon) {
                            sweepAmount += ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.sweepMod;
                            knockbackMod += ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.knockbackMod;
                            critChance += ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.critChanceMod - player.func_110148_a(EventHandlers.CRIT_CHANCE).func_111125_b();
                            critDamage += ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.additionalCritDamageMod;
                            additionalReach = ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.additionalReachMod;
                            soundType = ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.soundType;
                            animation = ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.animation;
                        }
                    } else {
                        damage -= ConfigurationHandler.fistAndNonWeaponDamageReduction;
                        knockbackMod += ConfigurationHandler.baseKnockback;
                        knockbackMod -= ConfigurationHandler.fistAndNonWeaponKnockbackReduction;
                        additionalReach -= ConfigurationHandler.fistAndNonWeaponReachReduction;
                        isMetal = false;
                        configWeapon = false;
                    }
                    tgtHealth = 0.0f;
                    tgtMaxHealth = 0.0f;
                    tgtHealthPercent = 0.0f;
                    if (player.func_70051_ag()) {
                        knockbackMod += ConfigurationHandler.sprintingKnockbackAmount;
                    }
                    bodyPart = null;
                    if (entity instanceof MultiPartEntityPart) {
                        bodyPart = (MultiPartEntityPart)entity;
                        if (bodyPart.field_70259_a instanceof EntityLivingBase) {
                            victim = (EntityLivingBase)bodyPart.field_70259_a;
                            break block79;
                        } else {
                            if (bodyPart.field_70259_a != null) {
                                SoundHandler.playImpactSound((EntityLivingBase)player, mainhand, soundType, animation, isMetal);
                                return bodyPart.field_70259_a.func_70965_a(bodyPart, DamageSource.func_76365_a((EntityPlayer)player), (float)damage);
                            }
                            return false;
                        }
                    }
                    if (entity instanceof EntityLivingBase) {
                        victim = (EntityLivingBase)entity;
                        if (victim instanceof EntityArmorStand) {
                            ((EntityArmorStand)victim).field_175437_i = victim.field_70170_p.func_82737_E();
                        }
                    } else {
                        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187724_dU, player.func_184176_by(), 1.0f, 1.0f);
                        entity.func_85031_j((Entity)player);
                        return entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), damage > 2.0 ? (float)damage : 2.0f);
                    }
                }
                if (!entity.func_70089_S() || !entity.func_70075_an()) {
                    return false;
                }
                try {
                    armor = victim.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    armorToughness = victim.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (PotionEffect effect : player.func_70651_bq()) {
                    switch (effect.func_188419_a().getRegistryName().toString()) {
                        case "bettercombat:precision": {
                            critChance += (1.0 + (double)effect.func_76458_c()) * ConfigurationHandler.critChancePotionAmplifier;
                            break;
                        }
                        case "bettercombat:brutality": {
                            critDamage += (1.0 + (double)effect.func_76458_c()) * ConfigurationHandler.critDamagePotionAmplifier;
                            break;
                        }
                        case "wards:effect_knockback": {
                            knockbackMod += 1.0 + (double)effect.func_76458_c();
                            break;
                        }
                        case "wards:effect_sharpness": {
                            enchantmentModifier += 0.5 + (double)(1 + effect.func_76458_c()) * 0.5;
                            break;
                        }
                        case "wards:effect_smite": {
                            if (victim.func_70668_bt() != EnumCreatureAttribute.UNDEAD) break;
                            enchantmentModifier += (1.0 + (double)effect.func_76458_c()) * 2.5;
                            break;
                        }
                        case "wards:effect_arthropods": {
                            if (victim.func_70668_bt() != EnumCreatureAttribute.ARTHROPOD) break;
                            enchantmentModifier += (1.0 + (double)effect.func_76458_c()) * 2.5;
                            break;
                        }
                        case "wards:effect_fire_aspect": {
                            fireAspect += 1 + effect.func_76458_c();
                            break;
                        }
                        case "wards:effect_sweeping": {
                            sweepAmount += 1 + effect.func_76458_c();
                            break;
                        }
                        case "wards:effect_unbreaking": {
                            if (weapon.func_190926_b() || !weapon.func_77951_h() || player.func_70681_au().nextInt(2 + effect.func_76458_c()) <= 0) break;
                            weapon.func_77964_b(weapon.func_77952_i() - 1);
                            break;
                        }
                    }
                }
                if (ConfigurationHandler.autoCritOnSneakAttacks && victim instanceof IMob && victim instanceof EntityLiving && (el = (EntityLiving)victim).func_70638_az() != player && el.func_70643_av() != player) {
                    isCrit = true;
                }
                try {
                    tgtHealthPercent = tgtHealth / tgtMaxHealth;
                }
                catch (Exception e) {
                    tgtHealthPercent = 0.0f;
                }
                if (fireAspect > 0) {
                    victim.func_70015_d(fireAspect * 4);
                }
                damage += (double)EnchantmentHelper.func_152377_a((ItemStack)weapon, (EnumCreatureAttribute)victim.func_70668_bt());
                if (ConfigurationHandler.baseCritPercentChance < 0.0) {
                    isCrit = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_184218_aH() && !player.func_70644_a(MobEffects.field_76440_q);
                } else if (!isCrit) {
                    if (!(!((double)player.field_70143_R > 0.0) || player.field_70122_E || player.func_70617_f_() || player.func_70090_H() || player.func_70644_a(MobEffects.field_76440_q))) {
                        critChance += ConfigurationHandler.jumpCrits;
                    }
                    boolean bl = isCrit = (critChance += player.func_110148_a(SharedMonsterAttributes.field_188792_h).func_111126_e() * ConfigurationHandler.luckCritModifier) > (double)player.func_70681_au().nextFloat();
                }
                if (isCrit) {
                    CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((EntityPlayer)player, (Entity)victim, (boolean)false, (float)((float)critDamage));
                    damage = hitResult != null ? (damage *= (double)hitResult.getDamageModifier()) : (damage *= critDamage);
                }
                if (ConfigurationHandler.miningFatigueDamageReduction > 0.0 && player.func_70644_a(MobEffects.field_76419_f) && damage > ConfigurationHandler.baseAttackDamage) {
                    damage = MathHelper.func_151237_a((double)(damage - damage * (ConfigurationHandler.miningFatigueDamageReduction * ((double)player.func_70660_b(MobEffects.field_76419_f).func_76458_c() + 1.0))), (double)ConfigurationHandler.baseAttackDamage, (double)damage);
                }
                if (!ConfigurationHandler.moreSprint) {
                    player.func_70031_b(false);
                }
                player.func_71020_j(0.1f);
                if (!Helpers.playerAttackedVictim(player, victim, bodyPart, (float)damage)) {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187724_dU, player.func_184176_by(), 1.0f, 1.0f);
                    return false;
                }
                SoundHandler.playImpactSound((EntityLivingBase)player, mainhand, soundType, animation, isMetal);
                if (customWeaponPotionEffect != null && (customWeaponPotionEffect.potionChance <= 0.0f && isCrit || customWeaponPotionEffect.potionChance >= player.func_70681_au().nextFloat())) {
                    if (customWeaponPotionEffect.afflict) {
                        victim.func_70690_d(new PotionEffect(customWeaponPotionEffect.getPotion(), customWeaponPotionEffect.potionDuration, customWeaponPotionEffect.potionPower - 1, customWeaponPotionEffect.ambient, customWeaponPotionEffect.showParticles));
                    } else {
                        player.func_70690_d(new PotionEffect(customWeaponPotionEffect.getPotion(), customWeaponPotionEffect.potionDuration, customWeaponPotionEffect.potionPower - 1, customWeaponPotionEffect.ambient, customWeaponPotionEffect.showParticles));
                    }
                }
                if (configWeapon && ConfigurationHandler.attackSweepParticles) {
                    Helpers.sweepParticles(player, (Entity)victim);
                }
                victim.func_70653_a((Entity)player, (float)(0.5 * knockbackMod), (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                NBTTagList nbttaglist = mainhand.func_77986_q();
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                    Enchantment enchantment = Enchantment.func_185262_c((int)nbttagcompound.func_74765_d("id"));
                    short j = nbttagcompound.func_74765_d("lvl");
                    if (enchantment != Enchantments.field_191530_r || j <= 0) continue;
                    sweepAmount += j;
                }
                if (sweepAmount-- > 0) {
                    boolean swept = false;
                    double sweepRange = 1.0 + (double)player.field_70130_N + (double)sweepAmount * 0.25;
                    additionalReach = mainhandAttack ? Helpers.getMainhandReach(player, additionalReach) : Helpers.getOffhandReach(player, additionalReach, offhand, mainhand);
                    List sweepVictims = player.field_70170_p.func_72872_a(EntityLivingBase.class, victim.func_174813_aQ().func_72314_b(sweepRange * (double)MathHelper.field_180189_a, 1.0, sweepRange * (double)MathHelper.field_180189_a));
                    for (EntityLivingBase sweepVictim : sweepVictims) {
                        if (sweepVictim == player || sweepVictim == victim || !sweepVictim.func_70089_S() || !(player.func_70068_e((Entity)sweepVictim) <= (additionalReach + (double)sweepVictim.field_70130_N) * (additionalReach + (double)sweepVictim.field_70130_N)) || !(victim.func_70068_e((Entity)sweepVictim) <= sweepRange * sweepRange) || !ConfigurationHandler.rightClickAttackable(player, (Entity)sweepVictim) || player.func_184191_r((Entity)sweepVictim)) continue;
                        swept = true;
                        double sweepDamage = ConfigurationHandler.baseAttackDamage;
                        sweepDamage = MathHelper.func_151237_a((double)(damage * ((double)sweepAmount * 0.25)), (double)ConfigurationHandler.baseAttackDamage, (double)damage);
                        if (!Helpers.playerAttackedVictim(player, sweepVictim, null, (float)sweepDamage)) continue;
                        sweepVictim.func_70653_a((Entity)player, (float)(0.5 * knockbackMod * MathHelper.func_151237_a((double)((4.0 + (double)sweepAmount) / 8.0), (double)0.5, (double)1.0)), (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                        if (!ConfigurationHandler.customPotionEffectsWorkOnSweep || customWeaponPotionEffect == null || !(customWeaponPotionEffect.potionChance <= 0.0f && isCrit) && !(customWeaponPotionEffect.potionChance >= player.func_70681_au().nextFloat())) continue;
                        if (customWeaponPotionEffect.afflict) {
                            sweepVictim.func_70690_d(new PotionEffect(customWeaponPotionEffect.getPotion(), customWeaponPotionEffect.potionDuration, customWeaponPotionEffect.potionPower - 1, true, false));
                            continue;
                        }
                        player.func_70690_d(new PotionEffect(customWeaponPotionEffect.getPotion(), customWeaponPotionEffect.potionDuration, customWeaponPotionEffect.potionPower - 1, true, false));
                    }
                    if (swept) {
                        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, player.func_184176_by(), ConfigurationHandler.weaponHitSoundVolume, SoundHandler.getRandomImpactPitch());
                    }
                }
                if (isCrit) {
                    player.func_71009_b((Entity)victim);
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187718_dS, player.func_184176_by(), ConfigurationHandler.weaponHitSoundVolume, SoundHandler.getRandomImpactPitch());
                    if (enchantmentModifier > 0.0) {
                        player.func_71047_c((Entity)victim);
                    }
                }
                ItemStack itemStack = activeItem = victim.func_184587_cr() ? victim.func_184607_cu() : ItemStack.field_190927_a;
                if (!victim.func_184585_cz() || !configWeapon) break block80;
                Vec3d vec3d2 = player.func_174791_d();
                if (vec3d2 == null) break block81;
                Vec3d vec3d1 = victim.func_70676_i(1.0f);
                Vec3d vec3d22 = vec3d2.func_72444_a(new Vec3d(victim.field_70165_t, victim.field_70163_u, victim.field_70161_v)).func_72432_b();
                vec3d22 = new Vec3d(vec3d22.field_72450_a, 0.0, vec3d22.field_72449_c);
                if (vec3d22.func_72430_b(vec3d1) < 0.0) {
                    int disableDuration = 0;
                    for (ConfigurationHandler.CustomAxe axe : ConfigurationHandler.axes) {
                        if (!weapon.func_77973_b().getRegistryName().toString().contains(axe.name)) continue;
                        disableDuration += axe.disableDuration;
                        break;
                    }
                    if (isCrit) {
                        disableDuration = (int)((double)disableDuration * MathHelper.func_151237_a((double)(damage * ConfigurationHandler.critsDisableShield), (double)5.0, (double)100.0));
                    }
                    if (disableDuration > 0) {
                        if (victim instanceof EntityPlayer) {
                            ((EntityPlayer)victim).func_184811_cZ().func_185145_a(activeItem.func_77973_b(), disableDuration);
                        }
                        victim.func_184597_cx();
                        player.field_70170_p.func_72960_a((Entity)victim, (byte)30);
                    }
                }
                break block81;
            }
            if (victim.func_184600_cs().equals((Object)EnumHand.MAIN_HAND) && victim.getEntityData().func_74764_b("isParrying") && victim.getEntityData().func_74767_n("isParrying") && configWeapon && (vec3d = player.func_174791_d()) != null) {
                Vec3d vec3d1 = victim.func_70676_i(1.0f);
                Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(victim.field_70165_t, victim.field_70163_u, victim.field_70161_v)).func_72432_b();
                vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
                if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                    int disableDuration = 0;
                    for (ConfigurationHandler.CustomAxe axe : ConfigurationHandler.axes) {
                        if (!weapon.func_77973_b().getRegistryName().toString().contains(axe.name)) continue;
                        disableDuration += axe.disableDuration;
                        break;
                    }
                    if (isCrit) {
                        disableDuration = (int)((double)disableDuration + damage * ConfigurationHandler.critsDisableShield);
                    }
                    if (disableDuration > 0) {
                        if (victim instanceof EntityPlayer) {
                            ((EntityPlayer)victim).func_184811_cZ().func_185145_a(activeItem.func_77973_b(), disableDuration);
                        }
                        PacketHandler.instance.sendToServer((IMessage)new PacketParrying(false));
                    }
                }
            }
        }
        EnchantmentHelper.func_151384_a((EntityLivingBase)victim, (Entity)player);
        EnchantmentHelper.func_151385_b((EntityLivingBase)player, (Entity)victim);
        player.func_130011_c((Entity)victim);
        armor += armorToughness;
        if (armor > 1.0 && !isCrit && damage <= (double)tgtHealth && (double)(player.func_70681_au().nextFloat() * 2.0f) * damage <= (player.func_70681_au().nextDouble() + (double)tgtHealthPercent) * armor) {
            SoundHandler.playImpactArmorMetalSound((EntityLivingBase)player, tgtMaxHealth, tgtHealthPercent);
        }
        if (ConfigurationHandler.damageParticles && player.field_70170_p instanceof WorldServer && damage >= 1.0) {
            int k = (int)(damage * 0.5);
            ((WorldServer)player.field_70170_p).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, victim.field_70165_t, victim.field_70163_u + (double)(victim.field_70131_O * 0.5f), victim.field_70161_v, k, 0.1, 0.0, 0.1, 0.2, new int[0]);
        }
        return true;
    }

    private static boolean playerAttackedVictim(EntityPlayer player, EntityLivingBase victim, @Nullable MultiPartEntityPart bodyPart, float damage) {
        victim.field_70172_ad = 0;
        boolean attacked = false;
        if (bodyPart != null && victim instanceof IEntityMultiPart) {
            attacked = ((IEntityMultiPart)victim).func_70965_a(bodyPart, DamageSource.func_76365_a((EntityPlayer)player), damage);
        }
        if (!attacked) {
            attacked = victim.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), damage);
        }
        if (victim.func_85031_j((Entity)player)) {
            attacked = true;
        }
        if (attacked) {
            player.func_130011_c((Entity)victim);
            victim.field_70172_ad = 0;
        }
        return attacked;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean playerAttackVictimWithShield(EntityPlayer player, Entity entity, ItemShield shield) {
        EntityLivingBase victim;
        MultiPartEntityPart bodyPart;
        double damage;
        double knockbackMod;
        block18: {
            if (entity == null) return false;
            if (entity == player) {
                return false;
            }
            knockbackMod = EnchantmentHelper.func_77501_a((EntityLivingBase)player);
            damage = ConfigurationHandler.baseAttackDamage;
            try {
                knockbackMod += (double)player.func_70660_b(MobEffects.field_76420_g).func_76458_c();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                knockbackMod -= (double)player.func_70660_b(MobEffects.field_76437_t).func_76458_c();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (ConfigurationHandler.CustomShield customShield : ConfigurationHandler.shields) {
                if (!shield.equals(customShield.shield)) continue;
                damage = customShield.damage;
                knockbackMod += customShield.knockback;
                break;
            }
            bodyPart = null;
            if (entity instanceof MultiPartEntityPart) {
                bodyPart = (MultiPartEntityPart)entity;
                if (bodyPart.field_70259_a instanceof EntityLivingBase) {
                    victim = (EntityLivingBase)bodyPart.field_70259_a;
                    break block18;
                } else {
                    if (bodyPart.field_70259_a == null) return false;
                    if (Helpers.isMetalItem((Item)shield)) {
                        SoundHandler.playBashMetalShieldSound((EntityLivingBase)player);
                        return bodyPart.field_70259_a.func_70965_a(bodyPart, DamageSource.func_76365_a((EntityPlayer)player), (float)damage);
                    }
                    SoundHandler.playBashWoodShieldSound((EntityLivingBase)player);
                    return bodyPart.field_70259_a.func_70965_a(bodyPart, DamageSource.func_76365_a((EntityPlayer)player), (float)damage);
                }
            }
            if (entity instanceof EntityLivingBase) {
                victim = (EntityLivingBase)entity;
                if (victim instanceof EntityArmorStand) {
                    ((EntityArmorStand)victim).field_175437_i = victim.field_70170_p.func_82737_E();
                }
            } else {
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187724_dU, player.func_184176_by(), 1.0f, 1.0f);
                entity.func_85031_j((Entity)player);
                if (!entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), damage > 2.0 ? (float)damage : 2.0f)) return false;
                return true;
            }
        }
        if (!entity.func_70089_S()) return false;
        if (!entity.func_70075_an()) {
            return false;
        }
        if (ConfigurationHandler.shieldSilverDamageMultiplier != 1.0f && victim.func_70662_br() && Helpers.isSilverRegistryName(Helpers.getRegistryNameFromItem((Item)shield))) {
            damage *= (double)ConfigurationHandler.shieldSilverDamageMultiplier;
            Helpers.silverArmorParticles((Entity)victim);
        }
        player.func_71020_j(0.1f);
        if (!Helpers.playerAttackedVictim(player, victim, bodyPart, (float)damage)) return false;
        if (Helpers.isMetalRegistryName(Helpers.getRegistryNameFromItem((Item)shield))) {
            SoundHandler.playBashMetalShieldSound((EntityLivingBase)player);
        } else {
            SoundHandler.playBashWoodShieldSound((EntityLivingBase)player);
        }
        victim.func_70653_a((Entity)player, (float)(0.5 * knockbackMod), (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
        if (ConfigurationHandler.shieldBashingTaunts && victim instanceof EntityCreature) {
            ((EntityCreature)victim).func_70624_b((EntityLivingBase)player);
            ((EntityCreature)victim).func_70604_c((EntityLivingBase)player);
        }
        player.func_71009_b((Entity)victim);
        return true;
    }

    public static double calculateAttribute(double attribute, double additive, double multiplicative) {
        return attribute *= additive * multiplicative;
    }

    public static double getBaseReach(EntityPlayer player) {
        if (ConfigurationHandler.baseReachDistance > 0.0) {
            return ConfigurationHandler.baseReachDistance;
        }
        return player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111125_b();
    }

    public static double getMainhandAttackDamage(EntityPlayer player, ItemStack mh) {
        double attackDamage = player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
        double multiply_base = 1.0;
        double multiply = 1.0;
        for (AttributeModifier attribute : player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111122_c()) {
            switch (attribute.func_111169_c()) {
                case 0: {
                    attackDamage += attribute.func_111164_d();
                    break;
                }
                case 1: {
                    multiply_base += attribute.func_111164_d();
                    break;
                }
                case 2: {
                    multiply *= 1.0 + attribute.func_111164_d();
                }
            }
        }
        return attackDamage *= (multiply_base *= multiply);
    }

    public static double getMainhandReach(EntityPlayer player, double additionalReach) {
        double reach = additionalReach + Helpers.getBaseReach(player);
        double additive = 1.0;
        double multiplicative = 1.0;
        for (AttributeModifier attribute : player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111122_c()) {
            switch (attribute.func_111169_c()) {
                case 0: {
                    reach += attribute.func_111164_d();
                    break;
                }
                case 1: {
                    additive += attribute.func_111164_d();
                    break;
                }
                case 2: {
                    multiplicative *= 1.0 + attribute.func_111164_d();
                }
            }
        }
        return Helpers.calculateAttribute(reach, additive, multiplicative);
    }

    public static double getOffhandAttackDamage(EntityPlayer player, ItemStack oh, ItemStack mh) {
        String attributeName;
        AttributeModifier modifier;
        int j;
        NBTTagList attributeList;
        NBTTagCompound tag;
        double attackDamage = player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
        double multiply_base = 1.0;
        double multiply = 1.0;
        for (AttributeModifier attribute : player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111122_c()) {
            switch (attribute.func_111169_c()) {
                case 0: {
                    attackDamage += attribute.func_111164_d();
                    break;
                }
                case 1: {
                    multiply_base += attribute.func_111164_d();
                    break;
                }
                case 2: {
                    multiply *= 1.0 + attribute.func_111164_d();
                }
            }
        }
        for (Map.Entry modifier2 : mh.func_111283_C(EntityEquipmentSlot.MAINHAND).entries()) {
            if (!((String)modifier2.getKey()).contains(ATTACK_DAMAGE)) continue;
            switch (((AttributeModifier)modifier2.getValue()).func_111169_c()) {
                case 0: {
                    attackDamage -= ((AttributeModifier)modifier2.getValue()).func_111164_d();
                    break;
                }
                case 1: {
                    multiply_base -= ((AttributeModifier)modifier2.getValue()).func_111164_d();
                    break;
                }
                case 2: {
                    multiply /= 1.0 + ((AttributeModifier)modifier2.getValue()).func_111164_d();
                }
            }
        }
        for (Map.Entry modifier2 : oh.func_111283_C(EntityEquipmentSlot.MAINHAND).entries()) {
            if (!((String)modifier2.getKey()).contains(ATTACK_DAMAGE)) continue;
            switch (((AttributeModifier)modifier2.getValue()).func_111169_c()) {
                case 0: {
                    attackDamage += ((AttributeModifier)modifier2.getValue()).func_111164_d();
                    break;
                }
                case 1: {
                    multiply_base += ((AttributeModifier)modifier2.getValue()).func_111164_d();
                    break;
                }
                case 2: {
                    multiply *= 1.0 + ((AttributeModifier)modifier2.getValue()).func_111164_d();
                }
            }
        }
        if (mh.func_77942_o() && mh.func_77978_p().func_150297_b("Quality", 10)) {
            tag = mh.func_179543_a("Quality");
            attributeList = tag.func_150295_c("AttributeModifiers", 10);
            block28: for (j = 0; j < attributeList.func_74745_c(); ++j) {
                modifier = SharedMonsterAttributes.func_111259_a((NBTTagCompound)attributeList.func_150305_b(j));
                attributeName = attributeList.func_150305_b(j).func_74779_i("AttributeName");
                if (!attributeName.contains(ATTACK_DAMAGE)) continue;
                switch (modifier.func_111169_c()) {
                    case 0: {
                        attackDamage -= modifier.func_111164_d();
                        continue block28;
                    }
                    case 1: {
                        multiply_base -= modifier.func_111164_d();
                        continue block28;
                    }
                    case 2: {
                        multiply /= 1.0 + modifier.func_111164_d();
                    }
                }
            }
        }
        if (oh.func_77942_o() && oh.func_77978_p().func_150297_b("Quality", 10)) {
            tag = oh.func_179543_a("Quality");
            attributeList = tag.func_150295_c("AttributeModifiers", 10);
            block29: for (j = 0; j < attributeList.func_74745_c(); ++j) {
                modifier = SharedMonsterAttributes.func_111259_a((NBTTagCompound)attributeList.func_150305_b(j));
                attributeName = attributeList.func_150305_b(j).func_74779_i("AttributeName");
                if (!attributeName.contains(ATTACK_DAMAGE)) continue;
                switch (modifier.func_111169_c()) {
                    case 0: {
                        attackDamage += modifier.func_111164_d();
                        continue block29;
                    }
                    case 1: {
                        multiply_base += modifier.func_111164_d();
                        continue block29;
                    }
                    case 2: {
                        multiply *= 1.0 + modifier.func_111164_d();
                    }
                }
            }
        }
        return attackDamage *= (multiply_base *= multiply);
    }

    public static double getOffhandReach(EntityPlayer player, double additionalReach, ItemStack oh, ItemStack mh) {
        String attributeName;
        AttributeModifier modifier;
        int j;
        NBTTagList attributeList;
        NBTTagCompound tag;
        double reach = additionalReach + Helpers.getBaseReach(player);
        double additive = 1.0;
        double multiplicative = 1.0;
        for (AttributeModifier attribute : player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111122_c()) {
            switch (attribute.func_111169_c()) {
                case 0: {
                    reach += attribute.func_111164_d();
                    break;
                }
                case 1: {
                    additive += attribute.func_111164_d();
                    break;
                }
                case 2: {
                    multiplicative *= 1.0 + attribute.func_111164_d();
                }
            }
        }
        for (Map.Entry modifier2 : mh.func_111283_C(EntityEquipmentSlot.MAINHAND).entries()) {
            if (!((String)modifier2.getKey()).contains(REACH_DISTANCE)) continue;
            switch (((AttributeModifier)modifier2.getValue()).func_111169_c()) {
                case 0: {
                    reach -= ((AttributeModifier)modifier2.getValue()).func_111164_d();
                    break;
                }
                case 1: {
                    additive -= ((AttributeModifier)modifier2.getValue()).func_111164_d();
                    break;
                }
                case 2: {
                    multiplicative /= 1.0 + ((AttributeModifier)modifier2.getValue()).func_111164_d();
                }
            }
        }
        for (Map.Entry modifier2 : oh.func_111283_C(EntityEquipmentSlot.MAINHAND).entries()) {
            if (!((String)modifier2.getKey()).contains(REACH_DISTANCE)) continue;
            switch (((AttributeModifier)modifier2.getValue()).func_111169_c()) {
                case 0: {
                    reach += ((AttributeModifier)modifier2.getValue()).func_111164_d();
                    break;
                }
                case 1: {
                    additive += ((AttributeModifier)modifier2.getValue()).func_111164_d();
                    break;
                }
                case 2: {
                    multiplicative *= 1.0 + ((AttributeModifier)modifier2.getValue()).func_111164_d();
                }
            }
        }
        if (mh.func_77942_o() && mh.func_77978_p().func_150297_b(QUALITY, 10)) {
            tag = mh.func_179543_a(QUALITY);
            attributeList = tag.func_150295_c(ATTRIBUTE_MODIFIERS, 10);
            block28: for (j = 0; j < attributeList.func_74745_c(); ++j) {
                modifier = SharedMonsterAttributes.func_111259_a((NBTTagCompound)attributeList.func_150305_b(j));
                attributeName = attributeList.func_150305_b(j).func_74779_i(ATTRIBUTE_NAME);
                if (!attributeName.contains(REACH_DISTANCE)) continue;
                switch (modifier.func_111169_c()) {
                    case 0: {
                        reach -= modifier.func_111164_d();
                        continue block28;
                    }
                    case 1: {
                        additive -= modifier.func_111164_d();
                        continue block28;
                    }
                    case 2: {
                        multiplicative /= 1.0 + modifier.func_111164_d();
                    }
                }
            }
        }
        if (oh.func_77942_o() && oh.func_77978_p().func_150297_b(QUALITY, 10)) {
            tag = oh.func_179543_a(QUALITY);
            attributeList = tag.func_150295_c(ATTRIBUTE_MODIFIERS, 10);
            block29: for (j = 0; j < attributeList.func_74745_c(); ++j) {
                modifier = SharedMonsterAttributes.func_111259_a((NBTTagCompound)attributeList.func_150305_b(j));
                attributeName = attributeList.func_150305_b(j).func_74779_i(ATTRIBUTE_NAME);
                if (!attributeName.contains(REACH_DISTANCE)) continue;
                switch (modifier.func_111169_c()) {
                    case 0: {
                        reach += modifier.func_111164_d();
                        continue block29;
                    }
                    case 1: {
                        additive += modifier.func_111164_d();
                        continue block29;
                    }
                    case 2: {
                        multiplicative *= 1.0 + modifier.func_111164_d();
                    }
                }
            }
        }
        return Helpers.calculateAttribute(reach, additive, multiplicative);
    }

    public static void applySwingInteria(EntityPlayer player) {
        if (ConfigurationHandler.inertiaOnAttack != 1.0 && player.field_70122_E && !player.func_184218_aH()) {
            player.field_70159_w *= ConfigurationHandler.inertiaOnAttack;
            player.field_70179_y *= ConfigurationHandler.inertiaOnAttack;
            player.field_70133_I = true;
        }
    }

    public static int getOffhandFireAspect(EntityPlayer player) {
        NBTTagList tagList = player.func_184592_cb().func_77986_q();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            if (tag.func_74762_e("id") != Enchantment.func_185258_b((Enchantment)Enchantments.field_77334_n)) continue;
            return tag.func_74762_e("lvl");
        }
        return 0;
    }

    public static int getOffhandKnockback(EntityPlayer player) {
        NBTTagList tagList = player.func_184592_cb().func_77986_q();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            if (tag.func_74762_e("id") != Enchantment.func_185258_b((Enchantment)Enchantments.field_180313_o)) continue;
            return tag.func_74762_e("lvl");
        }
        return 0;
    }

    public static String getRegistryNameFromItem(ItemStack itemStack) {
        return itemStack.func_77973_b().getRegistryName().func_110623_a();
    }

    public static String getRegistryNameFromItem(Item item) {
        return item.getRegistryName().func_110623_a();
    }

    public static boolean isSilverRegistryName(String string) {
        return string.contains("silver");
    }

    public static boolean isSilverItem(ItemStack itemStack) {
        return Helpers.getRegistryNameFromItem(itemStack).contains("silver");
    }

    public static boolean isSilverItem(Item item) {
        return Helpers.getRegistryNameFromItem(item).contains("silver");
    }

    public static boolean isMetalRegistryName(String string) {
        for (String s : ConfigurationHandler.nonMetalList) {
            if (!string.contains(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMetalItem(ItemStack itemStack) {
        String string = Helpers.getRegistryNameFromItem(itemStack);
        for (String s : ConfigurationHandler.nonMetalList) {
            if (!string.contains(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMetalItem(Item item) {
        String string = Helpers.getRegistryNameFromItem(item);
        for (String s : ConfigurationHandler.nonMetalList) {
            if (!string.contains(s)) continue;
            return false;
        }
        return true;
    }

    public static String integerToRoman(int num) {
        StringBuilder roman = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            while (num >= values[i]) {
                num -= values[i];
                roman.append(romanLiterals[i]);
            }
        }
        return roman.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public static void sweepParticlesClient(EntityPlayer e, int x, int z) {
        double d0 = -Math.sin(e.field_70177_z * ((float)Math.PI / 180));
        double d1 = MathHelper.func_76134_b((float)(e.field_70177_z * ((float)Math.PI / 180)));
        e.field_70170_p.func_175688_a(EnumParticleTypes.SWEEP_ATTACK, (double)x + d0 * 0.5, e.field_70163_u + (double)e.field_70131_O * 0.5, (double)z + d1 * 0.5, 0.0, 0.0, 0.0, new int[0]);
    }

    public static void sweepParticles(EntityPlayer e, Entity target) {
        double d0 = -MathHelper.func_76126_a((float)(e.field_70177_z * ((float)Math.PI / 180)));
        double d1 = MathHelper.func_76134_b((float)(e.field_70177_z * ((float)Math.PI / 180)));
        if (e.field_70170_p instanceof WorldServer) {
            ((WorldServer)e.field_70170_p).func_175739_a(EnumParticleTypes.SWEEP_ATTACK, target.field_70165_t + d0 * 0.5, e.field_70163_u + (double)e.field_70131_O * 0.5, target.field_70161_v + d1 * 0.5, 0, d0, 0.0, d1, 0.0, new int[0]);
        }
    }

    public static void dragonArrowParticles(Entity e) {
        if (e.field_70170_p instanceof WorldServer) {
            int i;
            for (i = 12; i > 0; --i) {
                ((WorldServer)e.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, e.field_70165_t + e.field_70170_p.field_73012_v.nextGaussian() * 0.12, e.field_70163_u + e.field_70170_p.field_73012_v.nextGaussian() * 0.18, e.field_70161_v + e.field_70170_p.field_73012_v.nextGaussian() * 0.12, 1, e.field_70170_p.field_73012_v.nextGaussian() * 0.06, e.field_70170_p.field_73012_v.nextGaussian() * 0.06, e.field_70170_p.field_73012_v.nextGaussian() * 0.06, e.field_70170_p.field_73012_v.nextDouble() * 0.08, new int[0]);
            }
            for (i = 4; i > 0; --i) {
                ((WorldServer)e.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_LARGE, e.field_70165_t + e.field_70170_p.field_73012_v.nextGaussian() * 0.12, e.field_70163_u + e.field_70170_p.field_73012_v.nextGaussian() * 0.18, e.field_70161_v + e.field_70170_p.field_73012_v.nextGaussian() * 0.12, 1, e.field_70170_p.field_73012_v.nextGaussian() * 0.06, e.field_70170_p.field_73012_v.nextGaussian() * 0.06, e.field_70170_p.field_73012_v.nextGaussian() * 0.06, e.field_70170_p.field_73012_v.nextDouble() * 0.08, new int[0]);
            }
        }
    }

    public static void silverArrowParticles(Entity e) {
        if (e.field_70170_p instanceof WorldServer) {
            for (int i = 12; i > 0; --i) {
                ((WorldServer)e.field_70170_p).func_175739_a(EnumParticleTypes.CRIT_MAGIC, e.field_70165_t + e.field_70170_p.field_73012_v.nextGaussian() * (double)e.field_70130_N, e.field_70163_u + e.field_70170_p.field_73012_v.nextGaussian() * (double)e.field_70131_O, e.field_70161_v + e.field_70170_p.field_73012_v.nextGaussian() * (double)e.field_70130_N, 1, e.field_70170_p.field_73012_v.nextGaussian() * 0.01, e.field_70170_p.field_73012_v.nextGaussian() * 0.01, e.field_70170_p.field_73012_v.nextGaussian() * 0.01, e.field_70170_p.field_73012_v.nextDouble() * 0.02, new int[0]);
            }
        }
    }

    public static void silverArmorParticles(Entity e) {
        if (e.field_70170_p instanceof WorldServer) {
            for (int i = 12; i > 0; --i) {
                ((WorldServer)e.field_70170_p).func_175739_a(EnumParticleTypes.CRIT_MAGIC, e.field_70165_t + e.field_70170_p.field_73012_v.nextGaussian() * (double)e.field_70130_N, e.field_70163_u + e.field_70170_p.field_73012_v.nextGaussian() * (double)e.field_70131_O, e.field_70161_v + e.field_70170_p.field_73012_v.nextGaussian() * (double)e.field_70130_N, 1, e.field_70170_p.field_73012_v.nextGaussian() * 0.06, e.field_70170_p.field_73012_v.nextGaussian() * 0.06, e.field_70170_p.field_73012_v.nextGaussian() * 0.06, e.field_70170_p.field_73012_v.nextDouble() * 0.06, new int[0]);
            }
        }
    }

    public static void healParticles(Entity e, int amount) {
        if (e.field_70170_p instanceof WorldServer) {
            for (int i = 0; i < amount; ++i) {
                double d0 = e.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                double d1 = e.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                double d2 = e.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                ((WorldServer)e.field_70170_p).func_175688_a(EnumParticleTypes.HEART, e.field_70165_t + (double)(e.field_70170_p.field_73012_v.nextFloat() * e.field_70130_N * 2.0f) - (double)e.field_70130_N, e.field_70163_u + 0.5 + (double)(e.field_70170_p.field_73012_v.nextFloat() * e.field_70131_O), e.field_70161_v + (double)(e.field_70170_p.field_73012_v.nextFloat() * e.field_70130_N * 2.0f) - (double)e.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
    }

    public static boolean isHandActive(EntityPlayer player, EnumHand hand) {
        return player.func_184587_cr() && player.func_184605_cv() > 0 && player.func_184600_cs().equals((Object)hand);
    }

    public static <T> void execNullable(@Nullable T obj, Consumer<T> onNonNull) {
        if (obj != null) {
            onNonNull.accept(obj);
        }
    }

    public static <T, R> R execNullable(@Nullable T obj, Function<T, R> onNonNull, R orElse) {
        if (obj != null) {
            return onNonNull.apply(obj);
        }
        return orElse;
    }
}

